/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.cmp.jdbc.metadata.JDBCApplicationMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCRelationMetaData;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedCmpField;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedRelationshipRole;
import org.jboss.metadata.ejb.spec.RelationRoleMetaData;

public final class JDBCRelationshipRoleMetaData {
    private final JDBCRelationMetaData relationMetaData;
    private final String relationshipRoleName;
    private final boolean foreignKeyConstraint;
    private final boolean batchCascadeDelete;
    private boolean genIndex;
    private JDBCReadAheadMetaData readAhead;
    private final boolean multiplicityOne;
    private final boolean cascadeDelete;
    private final JDBCEntityMetaData entity;
    private final String cmrFieldName;
    private final boolean navigable;
    private final String cmrFieldType;
    private JDBCRelationshipRoleMetaData relatedRole;
    private Map<String, JDBCCMPFieldMetaData> keyFields = new HashMap<String, JDBCCMPFieldMetaData>();

    public JDBCRelationshipRoleMetaData(JDBCRelationMetaData relationMetaData, JDBCApplicationMetaData application, RelationRoleMetaData role) {
        String fieldName;
        this.relationMetaData = relationMetaData;
        this.relationshipRoleName = role.getEjbRelationshipRoleName();
        this.multiplicityOne = role.isMultiplicityOne();
        this.cascadeDelete = role.isCascadedDelete();
        this.batchCascadeDelete = false;
        this.foreignKeyConstraint = false;
        this.readAhead = null;
        String string = fieldName = role.getCmrField() != null ? role.getCmrField().getCmrFieldName() : null;
        if (fieldName == null) {
            this.cmrFieldName = JDBCRelationshipRoleMetaData.generateNonNavigableCMRName(role);
            this.navigable = false;
        } else {
            this.cmrFieldName = fieldName;
            this.navigable = true;
        }
        this.cmrFieldType = role.getCmrField() != null ? role.getCmrField().getCmrFieldType() : null;
        this.entity = application.getBeanByEjbName(role.getRoleSource().getEjbName());
        if (this.entity == null) {
            throw new IllegalArgumentException("Entity: " + role.getRoleSource().getEjbName() + " not found for relation: " + role.getRelation().getEjbRelationName());
        }
    }

    public JDBCRelationshipRoleMetaData(JDBCRelationMetaData relationMetaData, JDBCApplicationMetaData application, JDBCRelationshipRoleMetaData defaultValues) {
        this.relationMetaData = relationMetaData;
        this.entity = application.getBeanByEjbName(defaultValues.getEntity().getName());
        this.relationshipRoleName = defaultValues.getRelationshipRoleName();
        this.multiplicityOne = defaultValues.isMultiplicityOne();
        this.cascadeDelete = defaultValues.isCascadeDelete();
        this.cmrFieldName = defaultValues.getCMRFieldName();
        this.navigable = defaultValues.isNavigable();
        this.cmrFieldType = defaultValues.getCMRFieldType();
        this.foreignKeyConstraint = defaultValues.hasForeignKeyConstraint();
        this.readAhead = this.entity.getReadAhead();
        this.batchCascadeDelete = defaultValues.isBatchCascadeDelete();
        if (this.batchCascadeDelete) {
            if (!this.cascadeDelete) {
                throw new RuntimeException(relationMetaData.getRelationName() + '/' + this.relationshipRoleName + " has batch-cascade-delete in jbosscmp-jdbc.xml but has no cascade-delete in ejb-jar.xml");
            }
            if (relationMetaData.isTableMappingStyle()) {
                throw new RuntimeException("Relationship " + relationMetaData.getRelationName() + " with relation-table-mapping style was setup for batch cascade-delete." + " Batch cascade-delete supported only for foreign key mapping style.");
            }
        }
    }

    public JDBCRelationshipRoleMetaData(JDBCRelationMetaData relationMetaData, JDBCApplicationMetaData application, ParsedRelationshipRole parsedRelationshipRole, JDBCRelationshipRoleMetaData defaultValues) {
        this.relationMetaData = relationMetaData;
        this.entity = application.getBeanByEjbName(defaultValues.getEntity().getName());
        this.relationshipRoleName = defaultValues.getRelationshipRoleName();
        this.multiplicityOne = defaultValues.isMultiplicityOne();
        this.cascadeDelete = defaultValues.isCascadeDelete();
        this.cmrFieldName = defaultValues.getCMRFieldName();
        this.navigable = defaultValues.isNavigable();
        this.cmrFieldType = defaultValues.getCMRFieldType();
        this.foreignKeyConstraint = parsedRelationshipRole.getForeignKeyConstraint() != null ? parsedRelationshipRole.getForeignKeyConstraint().booleanValue() : defaultValues.hasForeignKeyConstraint();
        this.readAhead = parsedRelationshipRole.getReadAhead() != null ? new JDBCReadAheadMetaData(parsedRelationshipRole.getReadAhead(), this.entity.getReadAhead()) : this.entity.getReadAhead();
        boolean bl = this.batchCascadeDelete = parsedRelationshipRole.getBatchCascadeDelete() != null && parsedRelationshipRole.getBatchCascadeDelete() != false;
        if (this.batchCascadeDelete) {
            if (!this.cascadeDelete) {
                throw new RuntimeException(relationMetaData.getRelationName() + '/' + this.relationshipRoleName + " has batch-cascade-delete in jbosscmp-jdbc.xml but has no cascade-delete in ejb-jar.xml");
            }
            if (relationMetaData.isTableMappingStyle()) {
                throw new RuntimeException("Relationship " + relationMetaData.getRelationName() + " with relation-table-mapping style was setup for batch cascade-delete." + " Batch cascade-delete supported only for foreign key mapping style.");
            }
        }
    }

    public void init(JDBCRelationshipRoleMetaData relatedRole) {
        this.relatedRole = relatedRole;
        this.keyFields.putAll(this.loadKeyFields());
    }

    public void init(JDBCRelationshipRoleMetaData relatedRole, ParsedRelationshipRole parsedRole) {
        this.relatedRole = relatedRole;
        this.keyFields.putAll(this.loadKeyFields(parsedRole));
    }

    public JDBCRelationMetaData getRelationMetaData() {
        return this.relationMetaData;
    }

    public String getRelationshipRoleName() {
        return this.relationshipRoleName;
    }

    public boolean hasForeignKeyConstraint() {
        return this.foreignKeyConstraint;
    }

    public boolean isBatchCascadeDelete() {
        return this.batchCascadeDelete;
    }

    public JDBCReadAheadMetaData getReadAhead() {
        return this.readAhead;
    }

    public JDBCEntityMetaData getEntity() {
        return this.entity;
    }

    public Collection<JDBCCMPFieldMetaData> getKeyFields() {
        return Collections.unmodifiableCollection(this.keyFields.values());
    }

    public boolean isIndexed() {
        return this.genIndex;
    }

    private static String generateNonNavigableCMRName(RelationRoleMetaData role) {
        RelationRoleMetaData relatedRole = role.getRelatedRole();
        return relatedRole.getRoleSource().getEjbName() + "_" + relatedRole.getCmrField().getCmrFieldName();
    }

    public boolean isMultiplicityOne() {
        return this.multiplicityOne;
    }

    public boolean isMultiplicityMany() {
        return !this.multiplicityOne;
    }

    public boolean isCascadeDelete() {
        return this.cascadeDelete;
    }

    public String getCMRFieldName() {
        return this.cmrFieldName;
    }

    public boolean isNavigable() {
        return this.navigable;
    }

    public String getCMRFieldType() {
        return this.cmrFieldType;
    }

    public JDBCRelationshipRoleMetaData getRelatedRole() {
        return this.relationMetaData.getOtherRelationshipRole(this);
    }

    private Map<String, JDBCCMPFieldMetaData> loadKeyFields() {
        if (this.relationMetaData.isForeignKeyMappingStyle()) {
            if (this.isMultiplicityMany()) {
                return Collections.emptyMap();
            }
            if (this.getRelatedRole().isMultiplicityOne() && !this.getRelatedRole().isNavigable()) {
                return Collections.emptyMap();
            }
        }
        ArrayList<JDBCCMPFieldMetaData> pkFields = new ArrayList<JDBCCMPFieldMetaData>();
        for (JDBCCMPFieldMetaData cmpField : this.entity.getCMPFields()) {
            if (!cmpField.isPrimaryKeyMember()) continue;
            pkFields.add(cmpField);
        }
        HashMap<String, JDBCCMPFieldMetaData> fields = new HashMap<String, JDBCCMPFieldMetaData>(pkFields.size());
        for (JDBCCMPFieldMetaData cmpField : pkFields) {
            String columnName = this.relationMetaData.isTableMappingStyle() ? (this.entity.equals(this.relatedRole.getEntity()) ? this.getCMRFieldName() : this.entity.getName()) : this.relatedRole.getCMRFieldName();
            if (pkFields.size() > 1) {
                columnName = columnName + "_" + cmpField.getFieldName();
            }
            this.genIndex = this.genIndex || cmpField.isIndexed();
            cmpField = new JDBCCMPFieldMetaData(this.entity, cmpField, columnName, false, this.relationMetaData.isTableMappingStyle(), this.relationMetaData.isReadOnly(), this.relationMetaData.getReadTimeOut(), this.relationMetaData.isTableMappingStyle());
            fields.put(cmpField.getFieldName(), cmpField);
        }
        return Collections.unmodifiableMap(fields);
    }

    private Map<String, JDBCCMPFieldMetaData> loadKeyFields(ParsedRelationshipRole parsedRole) {
        List<ParsedCmpField> keyFields = parsedRole.getKeyFields();
        if (keyFields == null) {
            return this.loadKeyFields();
        }
        if (keyFields.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        if (this.relationMetaData.isForeignKeyMappingStyle() && this.isMultiplicityMany()) {
            throw new RuntimeException("Role: " + this.relationshipRoleName + " with multiplicity many using " + "foreign-key mapping is not allowed to have key-fields");
        }
        Map<String, JDBCCMPFieldMetaData> defaultFields = this.getPrimaryKeyFields();
        HashMap<String, JDBCCMPFieldMetaData> fields = new HashMap<String, JDBCCMPFieldMetaData>(defaultFields.size());
        for (ParsedCmpField keyField : keyFields) {
            String fieldName = keyField.getFieldName();
            JDBCCMPFieldMetaData cmpField = defaultFields.remove(fieldName);
            if (cmpField == null) {
                throw new RuntimeException("Role '" + this.relationshipRoleName + "' on Entity Bean '" + this.entity.getName() + "' : CMP field for key not found: field " + "name='" + fieldName + "'");
            }
            this.genIndex = keyField.getGenIndex() != null && keyField.getGenIndex() != false;
            cmpField = new JDBCCMPFieldMetaData(this.entity, keyField, cmpField, false, this.relationMetaData.isTableMappingStyle(), this.relationMetaData.isReadOnly(), this.relationMetaData.getReadTimeOut(), this.relationMetaData.isTableMappingStyle());
            fields.put(cmpField.getFieldName(), cmpField);
        }
        if (!defaultFields.isEmpty()) {
            throw new RuntimeException("Mappings were not provided for all fields: unmaped fields=" + defaultFields.keySet() + " in role=" + this.relationshipRoleName);
        }
        return Collections.unmodifiableMap(fields);
    }

    private Map<String, JDBCCMPFieldMetaData> getPrimaryKeyFields() {
        HashMap<String, JDBCCMPFieldMetaData> pkFields = new HashMap<String, JDBCCMPFieldMetaData>();
        for (JDBCCMPFieldMetaData cmpField : this.entity.getCMPFields()) {
            if (!cmpField.isPrimaryKeyMember()) continue;
            pkFields.put(cmpField.getFieldName(), cmpField);
        }
        return pkFields;
    }
}

