/* Generated By:JJTree&JavaCC: Do not edit this line. JBossQLParser.java */
package org.jboss.as.cmp.ejbql;

import java.io.CharArrayReader;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.cmp.bridge.EntityBridge;
import org.jboss.as.cmp.bridge.CMPFieldBridge;
import org.jboss.as.cmp.bridge.CMRFieldBridge;
import org.jboss.as.cmp.bridge.FieldBridge;

/**
 * This class parses JBossQL into an abstract syntax tree.
 *
 * @author <a href="mailto:dain@daingroup.com">Dain Sundstrom</a>
 * @author <a href="mailto:alex@jboss.org">Alex Loubyansky</a>
 * @version $Revision: 94178 $
 */
public class JBossQLParser/*@bgen(jjtree)*/implements JBossQLParserTreeConstants, JBossQLParserConstants {/*@bgen(jjtree)*/
  protected JJTJBossQLParserState jjtree = new JJTJBossQLParserState();private Catalog catalog;
   private Class[] argumentTypes;
   private IdentifierManager idManager;
   private boolean selectDistinct;
   private String selectPath;

   public ASTEJBQL parse(Catalog catalog, Class[] argumentTypes, String ejbql)
         throws ParseException {

      this.catalog = catalog;
      token_source.catalog = catalog;
      this.argumentTypes = argumentTypes;
      token_source.argumentTypes = argumentTypes;
      idManager = new IdentifierManager(catalog);
      token_source.idManager = idManager;

      String lowerCase = ejbql.toLowerCase();
      int fromBeginIndex = indexOf(lowerCase, "from");
      if(fromBeginIndex < 0) {
         throw new ParseException("FROM not found");
      }

      int fromEndIndex = indexOf(lowerCase, "where");
      ///////////////////// CHANGED //////////////////////////////
      if(fromEndIndex < 0) {
         fromEndIndex = indexOfOrderBy(lowerCase);
      }
      if(fromEndIndex < 0) {
         fromEndIndex = indexOf(lowerCase, "offset");
      }
      if(fromEndIndex < 0) {
         fromEndIndex = indexOf(lowerCase, "limit");
      }
      if(fromEndIndex < 0) {
         fromEndIndex = ejbql.length();
      }
      ////////////////////////////////////////////////////////////

      // just the from clause
      char[] from = ejbql.toCharArray();
      clear(from, 0, fromBeginIndex);
      clear(from, fromEndIndex, from.length);

      // everything except for the from clause
      char[] sansFrom = ejbql.toCharArray();
      clear(sansFrom, fromBeginIndex + 4, fromEndIndex);

      // From clause
      ReInit(new CharArrayReader(from));
      ASTFrom fromNode = ParseFromClause();

      // Everything else
      ReInit(new CharArrayReader(sansFrom));
      ASTEJBQL ejbqlNode = EJBQL();

      // replace the dummy from clause in the EJBQL
      // node with the real from node
      ejbqlNode.jjtAddChild(fromNode, 1);

      return ejbqlNode;
   }

   /**
    * Returns the first index of the word (surrounded with whitespaces) in the string
    * or -1 if the word was not found.
    */
   private static final int indexOf(String ql, String word)
   {
      return indexOf(ql, word, 0);
   }

   /**
    * Returns the first index of the word (surrounded with whitespaces) in the string
    * starting with startInd position or -1 if the word was not found.
    */
   private static final int indexOf(String ql, String word, int startInd)
   {
      int i = ql.indexOf(word, startInd);
      if(i < 0)
      {
         return -1;
      }

      int qlLength = ql.length();
      int wordLength = word.length();
      while(i >= 0)
      {
         int endInd = i + wordLength;
         if((i == 0 || Character.isWhitespace(ql.charAt(i - 1))) &&
            (endInd == qlLength || endInd < qlLength && Character.isWhitespace(ql.charAt(endInd))))
         {
            break;
         }

         i = ql.indexOf(word, i + 1);
      }
      return i;
   }

   private static final int indexOfOrderBy(String ql)
   {
      int orderInd = indexOf(ql, "order", 0);
      int byInd = -1;
      while(orderInd > 0)
      {
         if(byInd < orderInd)
         {
            byInd = indexOf(ql, "by", orderInd + 5);
         }

         if(byInd > 0)
         {
            int i = byInd - 1;
            while(i >= orderInd + 5 && Character.isWhitespace(ql.charAt(i--)));
            if(i == orderInd + 4)
            {
               break;
            }
            else
            {
               orderInd = indexOf(ql, "order", orderInd + 5);
            }
         }
         else
         {
            orderInd = -1;
         }
      }
      return orderInd;
   }

   private final void clear(char[] c, int beginIndex, int endIndex) {
      for(int i=beginIndex; i < endIndex; i++) {
         if(c[i]!='\u005cr' && c[i]!='\u005cn' && c[i]!='\u005ct') {
            c[i] = ' ';
         }
      }
   }

   private final void initPathNode(ASTPath pathNode, String path, int type) {
      pathNode.pathList = idManager.getPathList(path);
      pathNode.fieldList = idManager.getFieldList(path);
      pathNode.type = type;
   }

   private final void initParameterNode(
         ASTParameter parameterNode,
         String number,
         int type) {

      parameterNode.number = Integer.parseInt(number);
      parameterNode.type = type;
   }

////////////////////// New or changed elements /////////////////////////////
  final public ASTEJBQL EJBQL() throws ParseException {
 /*@bgen(jjtree) EJBQL */
  ASTEJBQL jjtn000 = new ASTEJBQL(JJTEJBQL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      SelectClause();
      FromKeyword();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHERE:
        WhereClause();
        break;
      default:
        jj_la1[0] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ORDER:
        OrderByClause();
        break;
      default:
        jj_la1[1] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LIMIT:
      case OFFSET:
        LimitClause();
        break;
      default:
        jj_la1[2] = jj_gen;
        ;
      }
      jj_consume_token(0);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
    throw new Error("Missing return statement in function");
  }

  final public ASTOrderBy OrderByClause() throws ParseException {
 /*@bgen(jjtree) OrderBy */
  ASTOrderBy jjtn000 = new ASTOrderBy(JJTORDERBY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(ORDER);
      jj_consume_token(BY);
      OrderByPathExpression();
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[3] = jj_gen;
          break label_1;
        }
        jj_consume_token(COMMA);
        OrderByPathExpression();
      }
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
    throw new Error("Missing return statement in function");
  }

  final public void OrderByPathExpression() throws ParseException {
 /*@bgen(jjtree) OrderByPath */
  ASTOrderByPath jjtn000 = new ASTOrderByPath(JJTORDERBYPATH);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMERIC_VALUED_PATH:
        NumericValuedPath();
        break;
      case STRING_VALUED_PATH:
        StringValuedPath();
        break;
      case DATETIME_VALUED_PATH:
        DatetimeValuedPath();
        break;
      case VALUE_CLASS_VALUED_PARAMETER:
      case VALUE_CLASS_VALUED_PATH:
        ValueClassExpression();
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASC:
      case DESC:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ASC:
          jj_consume_token(ASC);
          break;
        case DESC:
          jj_consume_token(DESC);
                        jjtn000.ascending=false;
          break;
        default:
          jj_la1[5] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[6] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void LimitClause() throws ParseException {
 /*@bgen(jjtree) LimitOffset */
  ASTLimitOffset jjtn000 = new ASTLimitOffset(JJTLIMITOFFSET);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OFFSET:
        jj_consume_token(OFFSET);
        ArithmeticValue();
                                  jjtn000.hasOffset = true;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LIMIT:
          jj_consume_token(LIMIT);
          ArithmeticValue();
                                                                                           jjtn000.hasLimit = true;
          break;
        default:
          jj_la1[7] = jj_gen;
          ;
        }
        break;
      case LIMIT:
        jj_consume_token(LIMIT);
        ArithmeticValue();
                                 jjtree.closeNodeScope(jjtn000, true);
                                 jjtc000 = false;
                                 jjtn000.hasLimit = true;
        break;
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
       if (jjtc000) {
         jjtree.clearNodeScope(jjtn000);
         jjtc000 = false;
       } else {
         jjtree.popNode();
       }
       if (jjte000 instanceof RuntimeException) {
         {if (true) throw (RuntimeException)jjte000;}
       }
       if (jjte000 instanceof ParseException) {
         {if (true) throw (ParseException)jjte000;}
       }
       {if (true) throw (Error)jjte000;}
    } finally {
       if (jjtc000) {
         jjtree.closeNodeScope(jjtn000, true);
       }
    }
  }

////////////////////////////////////////////////////////////////////////////
  final public void FromKeyword() throws ParseException {
 /*@bgen(jjtree) From */
  ASTFrom jjtn000 = new ASTFrom(JJTFROM);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(FROM);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public ASTFrom ParseFromClause() throws ParseException {
  ASTFrom node;
    node = FromClause();
    jj_consume_token(0);
     {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public ASTFrom FromClause() throws ParseException {
 /*@bgen(jjtree) From */
  ASTFrom jjtn000 = new ASTFrom(JJTFROM);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(FROM);
      IdentificationVariableDeclaration();
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[9] = jj_gen;
          break label_2;
        }
        jj_consume_token(COMMA);
        IdentificationVariableDeclaration();
      }
       jjtree.closeNodeScope(jjtn000, true);
       jjtc000 = false;
       {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
    throw new Error("Missing return statement in function");
  }

  final public void IdentificationVariableDeclaration() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IN:
      CollectionMemberDeclaration();
      break;
    case ORDER:
    case ABSTRACT_SCHEMA:
      RangeVariableDeclaration();
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void CollectionMemberDeclaration() throws ParseException {
 /*@bgen(jjtree) CollectionMemberDeclaration */
   ASTCollectionMemberDeclaration jjtn000 = new ASTCollectionMemberDeclaration(JJTCOLLECTIONMEMBERDECLARATION);
   boolean jjtc000 = true;
   jjtree.openNodeScope(jjtn000);Token path;
   Token id;
    try {
      jj_consume_token(IN);
      jj_consume_token(LPAREN);
      path = CollectionValuedPath();
      jj_consume_token(RPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[11] = jj_gen;
        ;
      }
      id = Identifier();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        idManager.declareCollectionMember(id.image, path.image);
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void RangeVariableDeclaration() throws ParseException {
 /*@bgen(jjtree) RangeVariableDeclaration */
   ASTRangeVariableDeclaration jjtn000 = new ASTRangeVariableDeclaration(JJTRANGEVARIABLEDECLARATION);
   boolean jjtc000 = true;
   jjtree.openNodeScope(jjtn000);Token schema;
   Token id;
    try {
      schema = AbstractSchema();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[12] = jj_gen;
        ;
      }
      id = Identifier();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        idManager.declareRangeVariable(id.image, schema.image);
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public ASTSelect SelectClause() throws ParseException {
 /*@bgen(jjtree) Select */
  ASTSelect jjtn000 = new ASTSelect(JJTSELECT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(SELECT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DISTINCT:
        jj_consume_token(DISTINCT);
                             jjtn000.distinct=true;
        break;
      default:
        jj_la1[13] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OBJECT:
        jj_consume_token(OBJECT);
        jj_consume_token(LPAREN);
        IdentificationVariable();
        jj_consume_token(RPAREN);
        break;
      case NUMERIC_VALUED_PATH:
      case STRING_VALUED_PATH:
      case DATETIME_VALUED_PATH:
      case BOOLEAN_VALUED_PATH:
      case ENTITY_VALUED_PATH:
      case VALUE_CLASS_VALUED_PATH:
        SingleValuedPath();
        break;
      case ABS:
      case CONCAT:
      case COUNT:
      case MAX:
      case MIN:
      case AVG:
      case SUM:
      case LENGTH:
      case LOCATE:
      case SUBSTRING:
      case SQRT:
      case LCASE:
      case UCASE:
      case MOD:
        FunctionsAllowedInSelect();
        break;
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
       jjtree.closeNodeScope(jjtn000, true);
       jjtc000 = false;
       {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
    throw new Error("Missing return statement in function");
  }

  final public ASTWhere WhereClause() throws ParseException {
 /*@bgen(jjtree) Where */
  ASTWhere jjtn000 = new ASTWhere(JJTWHERE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(WHERE);
      WhereExpression();
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
    throw new Error("Missing return statement in function");
  }

//
// ASTWhereExpression and ASTWhereConditionalTerm mimic
// ConditionalExpression and ConditionalTerm.
// They are added to support joins per WhereConditionalTerm.
//
  final public void WhereExpression() throws ParseException {
     ASTOr jjtn001 = new ASTOr(JJTOR);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      WhereConditionalTerm();
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OR:
          ;
          break;
        default:
          jj_la1[15] = jj_gen;
          break label_3;
        }
        jj_consume_token(OR);
        WhereConditionalTerm();
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public ASTWhereConditionalTerm WhereConditionalTerm() throws ParseException {
 /*@bgen(jjtree) WhereConditionalTerm */
  ASTWhereConditionalTerm jjtn000 = new ASTWhereConditionalTerm(JJTWHERECONDITIONALTERM);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
     ASTAnd jjtn001 = new ASTAnd(JJTAND);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
      try {
        ConditionalFactor();
        label_4:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case AND:
            ;
            break;
          default:
            jj_la1[16] = jj_gen;
            break label_4;
          }
          jj_consume_token(AND);
          ConditionalFactor();
        }
      } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
      } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
      }
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
    throw new Error("Missing return statement in function");
  }

  final public void ConditionalExpression() throws ParseException {
     ASTOr jjtn001 = new ASTOr(JJTOR);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      ConditionalTerm();
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OR:
          ;
          break;
        default:
          jj_la1[17] = jj_gen;
          break label_5;
        }
        jj_consume_token(OR);
        ConditionalTerm();
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public void ConditionalTerm() throws ParseException {
     ASTAnd jjtn001 = new ASTAnd(JJTAND);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      ConditionalFactor();
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AND:
          ;
          break;
        default:
          jj_la1[18] = jj_gen;
          break label_6;
        }
        jj_consume_token(AND);
        ConditionalFactor();
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public void ConditionalFactor() throws ParseException {
  boolean not = false;
     ASTNot jjtn001 = new ASTNot(JJTNOT);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
              not=true;
        break;
      default:
        jj_la1[19] = jj_gen;
        ;
      }
      ConditionalTest();
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001,  not);
     }
    }
  }

  final public void ConditionalTest() throws ParseException {
    ConditionalPrimary();
  }

  final public void ConditionalPrimary() throws ParseException {
    if (jj_2_1(2147483647)) {
        ASTConditionalParenthetical jjtn001 = new ASTConditionalParenthetical(JJTCONDITIONALPARENTHETICAL);
        boolean jjtc001 = true;
        jjtree.openNodeScope(jjtn001);
      try {
        jj_consume_token(LPAREN);
        ConditionalExpression();
        jj_consume_token(RPAREN);
      } catch (Throwable jjte001) {
        if (jjtc001) {
          jjtree.clearNodeScope(jjtn001);
          jjtc001 = false;
        } else {
          jjtree.popNode();
        }
        if (jjte001 instanceof RuntimeException) {
          {if (true) throw (RuntimeException)jjte001;}
        }
        if (jjte001 instanceof ParseException) {
          {if (true) throw (ParseException)jjte001;}
        }
        {if (true) throw (Error)jjte001;}
      } finally {
        if (jjtc001) {
          jjtree.closeNodeScope(jjtn001, true);
        }
      }
    } else if (jj_2_2(1)) {
      SimpleCondExpression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

////////////////////// New or changed elements /////////////////////////////
  final public void FunctionsAllowedInSelect() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABS:
    case COUNT:
    case MAX:
    case MIN:
    case AVG:
    case SUM:
    case LENGTH:
    case LOCATE:
    case SQRT:
    case MOD:
      FunctionsReturningNumerics();
      break;
    case CONCAT:
    case SUBSTRING:
    case LCASE:
    case UCASE:
      FunctionsReturningStrings();
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void SimpleCondExpression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLLECTION_VALUED_PATH:
      EmptyCollectionComparisonExpression();
      break;
    default:
      jj_la1[21] = jj_gen;
      if (getToken(2).kind==IS) {
        NullComparisonExpression();
      } else if (getToken(2).kind==MEMBER || getToken(3).kind==MEMBER) {
        CollectionMemberExpression();
      } else if (jj_2_3(2147483647)) {
        LikeExpression();
      } else if (jj_2_4(2147483647)) {
        InExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ABS:
        case CONCAT:
        case COUNT:
        case MAX:
        case MIN:
        case AVG:
        case SUM:
        case LENGTH:
        case LOCATE:
        case SUBSTRING:
        case SQRT:
        case LCASE:
        case UCASE:
        case MOD:
        case LPAREN:
        case PLUS:
        case MINUS:
        case STRING_LITERAL:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case FALSE:
        case TRUE:
        case IDENTIFICATION_VARIABLE:
        case NUMERIC_VALUED_PARAMETER:
        case STRING_VALUED_PARAMETER:
        case DATETIME_VALUED_PARAMETER:
        case BOOLEAN_VALUED_PARAMETER:
        case ENTITY_VALUED_PARAMETER:
        case VALUE_CLASS_VALUED_PARAMETER:
        case NUMERIC_VALUED_PATH:
        case STRING_VALUED_PATH:
        case DATETIME_VALUED_PATH:
        case BOOLEAN_VALUED_PATH:
        case ENTITY_VALUED_PATH:
        case VALUE_CLASS_VALUED_PATH:
          ComparisonExpression();
          break;
        default:
          jj_la1[22] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void BetweenExpression() throws ParseException {
 /*@bgen(jjtree) Between */
  ASTBetween jjtn000 = new ASTBetween(JJTBETWEEN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABS:
      case COUNT:
      case MAX:
      case MIN:
      case AVG:
      case SUM:
      case LENGTH:
      case LOCATE:
      case SQRT:
      case MOD:
      case LPAREN:
      case PLUS:
      case MINUS:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case NUMERIC_VALUED_PARAMETER:
      case NUMERIC_VALUED_PATH:
        ArithmeticExpression();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NOT:
          jj_consume_token(NOT);
                                    jjtn000.not=true;
          break;
        default:
          jj_la1[23] = jj_gen;
          ;
        }
        jj_consume_token(BETWEEN);
        ArithmeticExpression();
        jj_consume_token(AND);
        ArithmeticExpression();
        break;
      case DATETIME_VALUED_PARAMETER:
      case DATETIME_VALUED_PATH:
        DatetimeValue();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NOT:
          jj_consume_token(NOT);
                             jjtn000.not=true;
          break;
        default:
          jj_la1[24] = jj_gen;
          ;
        }
        jj_consume_token(BETWEEN);
        DatetimeValue();
        jj_consume_token(AND);
        DatetimeValue();
        break;
      case CONCAT:
      case SUBSTRING:
      case LCASE:
      case UCASE:
      case STRING_LITERAL:
      case STRING_VALUED_PARAMETER:
      case STRING_VALUED_PATH:
        StringValue();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NOT:
          jj_consume_token(NOT);
                           jjtn000.not=true;
          break;
        default:
          jj_la1[25] = jj_gen;
          ;
        }
        jj_consume_token(BETWEEN);
        StringValue();
        jj_consume_token(AND);
        StringValue();
        break;
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void InExpression() throws ParseException {
 /*@bgen(jjtree) In */
  ASTIn jjtn000 = new ASTIn(JJTIN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONCAT:
      case SUBSTRING:
      case LCASE:
      case UCASE:
      case LPAREN:
      case STRING_LITERAL:
      case STRING_VALUED_PARAMETER:
      case STRING_VALUED_PATH:
        StringExpression();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NOT:
          jj_consume_token(NOT);
                                jjtn000.not=true;
          break;
        default:
          jj_la1[27] = jj_gen;
          ;
        }
        jj_consume_token(IN);
        jj_consume_token(LPAREN);
        StringExpression();
        label_7:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[28] = jj_gen;
            break label_7;
          }
          jj_consume_token(COMMA);
          StringExpression();
        }
        jj_consume_token(RPAREN);
        break;
      case ABS:
      case COUNT:
      case MAX:
      case MIN:
      case AVG:
      case SUM:
      case LENGTH:
      case LOCATE:
      case SQRT:
      case MOD:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case NUMERIC_VALUED_PARAMETER:
      case NUMERIC_VALUED_PATH:
        ArithmeticPrimary();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NOT:
          jj_consume_token(NOT);
                                 jjtn000.not=true;
          break;
        default:
          jj_la1[29] = jj_gen;
          ;
        }
        jj_consume_token(IN);
        jj_consume_token(LPAREN);
        ArithmeticPrimary();
        label_8:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[30] = jj_gen;
            break label_8;
          }
          jj_consume_token(COMMA);
          ArithmeticPrimary();
        }
        jj_consume_token(RPAREN);
        break;
      case DATETIME_VALUED_PARAMETER:
      case DATETIME_VALUED_PATH:
        DatetimeValue();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NOT:
          jj_consume_token(NOT);
                             jjtn000.not=true;
          break;
        default:
          jj_la1[31] = jj_gen;
          ;
        }
        jj_consume_token(IN);
        jj_consume_token(LPAREN);
        DatetimeValue();
        label_9:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[32] = jj_gen;
            break label_9;
          }
          jj_consume_token(COMMA);
          DatetimeValue();
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void LikeExpression() throws ParseException {
 /*@bgen(jjtree) Like */
  ASTLike jjtn000 = new ASTLike(JJTLIKE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      StringValue();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                          jjtn000.not=true;
        break;
      default:
        jj_la1[34] = jj_gen;
        ;
      }
      jj_consume_token(LIKE);
      StringExpression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ESCAPE:
        jj_consume_token(ESCAPE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STRING_LITERAL:
          StringLiteral();
          break;
        case NUMERIC_VALUED_PARAMETER:
          NumericValuedParameter();
          break;
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[36] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

////////////////////////////////////////////////////////////////////////////
  final public void NullComparisonExpression() throws ParseException {
 /*@bgen(jjtree) NullComparison */
  ASTNullComparison jjtn000 = new ASTNullComparison(JJTNULLCOMPARISON);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMERIC_VALUED_PATH:
      case STRING_VALUED_PATH:
      case DATETIME_VALUED_PATH:
      case BOOLEAN_VALUED_PATH:
      case ENTITY_VALUED_PATH:
      case VALUE_CLASS_VALUED_PATH:
        SingleValuedPath();
        break;
      case NUMERIC_VALUED_PARAMETER:
        NumericValuedParameter();
        break;
      case ENTITY_VALUED_PARAMETER:
        EntityValuedParameter();
        break;
      case STRING_VALUED_PARAMETER:
        StringValuedParameter();
        break;
      case DATETIME_VALUED_PARAMETER:
        DatetimeValuedParameter();
        break;
      case BOOLEAN_VALUED_PARAMETER:
        BooleanValuedParameter();
        break;
      default:
        jj_la1[37] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(IS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                 jjtn000.not=true;
        break;
      default:
        jj_la1[38] = jj_gen;
        ;
      }
      jj_consume_token(NULL);
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void EmptyCollectionComparisonExpression() throws ParseException {
 /*@bgen(jjtree) IsEmpty */
  ASTIsEmpty jjtn000 = new ASTIsEmpty(JJTISEMPTY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      CollectionValuedPath();
      jj_consume_token(IS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                                        jjtn000.not=true;
        break;
      default:
        jj_la1[39] = jj_gen;
        ;
      }
      jj_consume_token(EMPTY);
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void CollectionMemberExpression() throws ParseException {
 /*@bgen(jjtree) MemberOf */
  ASTMemberOf jjtn000 = new ASTMemberOf(JJTMEMBEROF);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ENTITY_VALUED_PATH:
        EntityValuedPath();
        break;
      case IDENTIFICATION_VARIABLE:
        IdentificationVariable();
        break;
      case ENTITY_VALUED_PARAMETER:
        EntityValuedParameter();
        break;
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
               jjtn000.not=true;
        break;
      default:
        jj_la1[41] = jj_gen;
        ;
      }
      jj_consume_token(MEMBER);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OF:
        jj_consume_token(OF);
        break;
      default:
        jj_la1[42] = jj_gen;
        ;
      }
      CollectionValuedPath();
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void ComparisonExpression() throws ParseException {
    if (jj_2_5(2147483647)) {
     ASTStringComparison jjtn001 = new ASTStringComparison(JJTSTRINGCOMPARISON);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
      try {
        StringValue();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQ:
          jj_consume_token(EQ);
                jjtn001.opp="=";
          break;
        case GT:
          jj_consume_token(GT);
                jjtn001.opp=">";
          break;
        case GE:
          jj_consume_token(GE);
                jjtn001.opp=">=";
          break;
        case LT:
          jj_consume_token(LT);
                jjtn001.opp="<";
          break;
        case LE:
          jj_consume_token(LE);
                jjtn001.opp="<=";
          break;
        case NE:
          jj_consume_token(NE);
                jjtn001.opp="<>";
          break;
        default:
          jj_la1[43] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        StringExpression();
      } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
      } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, true);
     }
      }
    } else if (jj_2_6(2147483647)) {
     ASTBooleanComparison jjtn002 = new ASTBooleanComparison(JJTBOOLEANCOMPARISON);
     boolean jjtc002 = true;
     jjtree.openNodeScope(jjtn002);
      try {
        BooleanValue();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQ:
        case NE:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EQ:
            jj_consume_token(EQ);
                   jjtn002.opp="=";
            break;
          case NE:
            jj_consume_token(NE);
                   jjtn002.opp="<>";
            break;
          default:
            jj_la1[44] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          BooleanExpression();
          break;
        default:
          jj_la1[45] = jj_gen;
          ;
        }
      } catch (Throwable jjte002) {
     if (jjtc002) {
       jjtree.clearNodeScope(jjtn002);
       jjtc002 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte002 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte002;}
     }
     if (jjte002 instanceof ParseException) {
       {if (true) throw (ParseException)jjte002;}
     }
     {if (true) throw (Error)jjte002;}
      } finally {
     if (jjtc002) {
       jjtree.closeNodeScope(jjtn002, true);
     }
      }
    } else if (jj_2_7(2147483647)) {
     ASTDatetimeComparison jjtn003 = new ASTDatetimeComparison(JJTDATETIMECOMPARISON);
     boolean jjtc003 = true;
     jjtree.openNodeScope(jjtn003);
      try {
        DatetimeValue();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQ:
          jj_consume_token(EQ);
                jjtn003.opp="=";
          break;
        case GT:
          jj_consume_token(GT);
                jjtn003.opp=">";
          break;
        case GE:
          jj_consume_token(GE);
                jjtn003.opp=">=";
          break;
        case LT:
          jj_consume_token(LT);
                jjtn003.opp="<";
          break;
        case LE:
          jj_consume_token(LE);
                jjtn003.opp="<=";
          break;
        case NE:
          jj_consume_token(NE);
                jjtn003.opp="<>";
          break;
        default:
          jj_la1[46] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        DatetimeExpression();
      } catch (Throwable jjte003) {
     if (jjtc003) {
       jjtree.clearNodeScope(jjtn003);
       jjtc003 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte003 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte003;}
     }
     if (jjte003 instanceof ParseException) {
       {if (true) throw (ParseException)jjte003;}
     }
     {if (true) throw (Error)jjte003;}
      } finally {
     if (jjtc003) {
       jjtree.closeNodeScope(jjtn003, true);
     }
      }
    } else if (jj_2_8(2147483647)) {
     ASTValueClassComparison jjtn004 = new ASTValueClassComparison(JJTVALUECLASSCOMPARISON);
     boolean jjtc004 = true;
     jjtree.openNodeScope(jjtn004);
      try {
        ValueClassValue();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQ:
          jj_consume_token(EQ);
                jjtn004.opp="=";
          break;
        case GT:
          jj_consume_token(GT);
                jjtn004.opp=">";
          break;
        case GE:
          jj_consume_token(GE);
                jjtn004.opp=">=";
          break;
        case LT:
          jj_consume_token(LT);
                jjtn004.opp="<";
          break;
        case LE:
          jj_consume_token(LE);
                jjtn004.opp="<=";
          break;
        case NE:
          jj_consume_token(NE);
                jjtn004.opp="<>";
          break;
        default:
          jj_la1[47] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        ValueClassExpression();
      } catch (Throwable jjte004) {
     if (jjtc004) {
       jjtree.clearNodeScope(jjtn004);
       jjtc004 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte004 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte004;}
     }
     if (jjte004 instanceof ParseException) {
       {if (true) throw (ParseException)jjte004;}
     }
     {if (true) throw (Error)jjte004;}
      } finally {
     if (jjtc004) {
       jjtree.closeNodeScope(jjtn004, true);
     }
      }
    } else if (jj_2_9(2147483647)) {
     ASTEntityComparison jjtn005 = new ASTEntityComparison(JJTENTITYCOMPARISON);
     boolean jjtc005 = true;
     jjtree.openNodeScope(jjtn005);
      try {
        EntityBeanValue();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQ:
          jj_consume_token(EQ);
                jjtn005.opp="=";
          break;
        case NE:
          jj_consume_token(NE);
                jjtn005.opp="<>";
          break;
        default:
          jj_la1[48] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        EntityBeanExpression();
      } catch (Throwable jjte005) {
     if (jjtc005) {
       jjtree.clearNodeScope(jjtn005);
       jjtc005 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte005 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte005;}
     }
     if (jjte005 instanceof ParseException) {
       {if (true) throw (ParseException)jjte005;}
     }
     {if (true) throw (Error)jjte005;}
      } finally {
     if (jjtc005) {
       jjtree.closeNodeScope(jjtn005, true);
     }
      }
    } else if (jj_2_10(2147483647)) {
     ASTArithmeticComparison jjtn006 = new ASTArithmeticComparison(JJTARITHMETICCOMPARISON);
     boolean jjtc006 = true;
     jjtree.openNodeScope(jjtn006);
      try {
        ArithmeticValue();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQ:
          jj_consume_token(EQ);
                jjtn006.opp="=";
          break;
        case GT:
          jj_consume_token(GT);
                jjtn006.opp=">";
          break;
        case GE:
          jj_consume_token(GE);
                jjtn006.opp=">=";
          break;
        case LT:
          jj_consume_token(LT);
                jjtn006.opp="<";
          break;
        case LE:
          jj_consume_token(LE);
                jjtn006.opp="<=";
          break;
        case NE:
          jj_consume_token(NE);
                jjtn006.opp="<>";
          break;
        default:
          jj_la1[49] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        SingleValueDesignator();
      } catch (Throwable jjte006) {
     if (jjtc006) {
       jjtree.clearNodeScope(jjtn006);
       jjtc006 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte006 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte006;}
     }
     if (jjte006 instanceof ParseException) {
       {if (true) throw (ParseException)jjte006;}
     }
     {if (true) throw (Error)jjte006;}
      } finally {
     if (jjtc006) {
       jjtree.closeNodeScope(jjtn006, true);
     }
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABS:
      case CONCAT:
      case COUNT:
      case MAX:
      case MIN:
      case AVG:
      case SUM:
      case LENGTH:
      case LOCATE:
      case SUBSTRING:
      case SQRT:
      case LCASE:
      case UCASE:
      case MOD:
      case LPAREN:
      case PLUS:
      case MINUS:
      case STRING_LITERAL:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case NUMERIC_VALUED_PARAMETER:
      case STRING_VALUED_PARAMETER:
      case DATETIME_VALUED_PARAMETER:
      case NUMERIC_VALUED_PATH:
      case STRING_VALUED_PATH:
      case DATETIME_VALUED_PATH:
        BetweenExpression();
        break;
      default:
        jj_la1[50] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

////////////////////// New or changed elements /////////////////////////////
  final public void ArithmeticValue() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMERIC_VALUED_PATH:
      NumericValuedPath();
      break;
    case ABS:
    case COUNT:
    case MAX:
    case MIN:
    case AVG:
    case SUM:
    case LENGTH:
    case LOCATE:
    case SQRT:
    case MOD:
      FunctionsReturningNumerics();
      break;
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
      NumericLiteral();
      break;
    case NUMERIC_VALUED_PARAMETER:
      NumericValuedParameter();
      break;
    default:
      jj_la1[51] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

////////////////////////////////////////////////////////////////////////////
  final public void SingleValueDesignator() throws ParseException {
    ScalarExpression();
  }

  final public void ScalarExpression() throws ParseException {
    ArithmeticExpression();
  }

  final public void ArithmeticExpression() throws ParseException {
     ASTPlusMinus jjtn001 = new ASTPlusMinus(JJTPLUSMINUS);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      ArithmeticTerm();
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
        case MINUS:
          ;
          break;
        default:
          jj_la1[52] = jj_gen;
          break label_10;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
          jj_consume_token(PLUS);
                     jjtn001.addOpp("+");
          break;
        case MINUS:
          jj_consume_token(MINUS);
                      jjtn001.addOpp("-");
          break;
        default:
          jj_la1[53] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        ArithmeticTerm();
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public void ArithmeticTerm() throws ParseException {
     ASTMultDiv jjtn001 = new ASTMultDiv(JJTMULTDIV);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      ArithmeticFactor();
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MULT:
        case DIV:
          ;
          break;
        default:
          jj_la1[54] = jj_gen;
          break label_11;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MULT:
          jj_consume_token(MULT);
                     jjtn001.addOpp("*");
          break;
        case DIV:
          jj_consume_token(DIV);
                    jjtn001.addOpp("/");
          break;
        default:
          jj_la1[55] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        ArithmeticFactor();
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public void ArithmeticFactor() throws ParseException {
  boolean negation = false;
     ASTNegation jjtn001 = new ASTNegation(JJTNEGATION);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
          jj_consume_token(PLUS);
          break;
        case MINUS:
          jj_consume_token(MINUS);
                      negation=true;
          break;
        default:
          jj_la1[56] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[57] = jj_gen;
        ;
      }
      ArithmeticPrimary();
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001,  negation);
     }
    }
  }

  final public void ArithmeticPrimary() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMERIC_VALUED_PATH:
      NumericValuedPath();
      break;
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
      NumericLiteral();
      break;
    case LPAREN:
     ASTArithmeticParenthetical jjtn001 = new ASTArithmeticParenthetical(JJTARITHMETICPARENTHETICAL);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
      try {
        jj_consume_token(LPAREN);
        ArithmeticExpression();
        jj_consume_token(RPAREN);
      } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
      } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, true);
     }
      }
      break;
    case NUMERIC_VALUED_PARAMETER:
      NumericValuedParameter();
      break;
    case ABS:
    case COUNT:
    case MAX:
    case MIN:
    case AVG:
    case SUM:
    case LENGTH:
    case LOCATE:
    case SQRT:
    case MOD:
      FunctionsReturningNumerics();
      break;
    default:
      jj_la1[58] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

////////////////////// New or changed elements /////////////////////////////
  final public void StringValue() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_VALUED_PATH:
      StringValuedPath();
      break;
    case CONCAT:
    case SUBSTRING:
    case LCASE:
    case UCASE:
      FunctionsReturningStrings();
      break;
    case STRING_LITERAL:
      StringLiteral();
      break;
    case STRING_VALUED_PARAMETER:
      StringValuedParameter();
      break;
    default:
      jj_la1[59] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

////////////////////////////////////////////////////////////////////////////
  final public void StringExpression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONCAT:
    case SUBSTRING:
    case LCASE:
    case UCASE:
    case LPAREN:
    case STRING_LITERAL:
    case STRING_VALUED_PATH:
      StringPrimary();
      break;
    case STRING_VALUED_PARAMETER:
      StringValuedParameter();
      break;
    default:
      jj_la1[60] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void StringPrimary() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_VALUED_PATH:
      StringValuedPath();
      break;
    case STRING_LITERAL:
      StringLiteral();
      break;
    case LPAREN:
     ASTStringParenthetical jjtn001 = new ASTStringParenthetical(JJTSTRINGPARENTHETICAL);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
      try {
        jj_consume_token(LPAREN);
        StringExpression();
        jj_consume_token(RPAREN);
      } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
      } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, true);
     }
      }
      break;
    case CONCAT:
    case SUBSTRING:
    case LCASE:
    case UCASE:
      FunctionsReturningStrings();
      break;
    default:
      jj_la1[61] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

////////////////////// New or changed elements /////////////////////////////
  final public void DatetimeValue() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATETIME_VALUED_PATH:
      DatetimeValuedPath();
      break;
    case DATETIME_VALUED_PARAMETER:
      DatetimeValuedParameter();
      break;
    default:
      jj_la1[62] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void DatetimeExpression() throws ParseException {
    DatetimeValue();
  }

  final public void BooleanValue() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN_VALUED_PATH:
      BooleanValuedPath();
      break;
    case BOOLEAN_VALUED_PARAMETER:
      BooleanValuedParameter();
      break;
    case FALSE:
    case TRUE:
      BooleanLiteral();
      break;
    default:
      jj_la1[63] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void BooleanExpression() throws ParseException {
    BooleanValue();
  }

  final public void ValueClassValue() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VALUE_CLASS_VALUED_PATH:
      ValueClassValuedPath();
      break;
    case VALUE_CLASS_VALUED_PARAMETER:
      ValueClassValuedParameter();
      break;
    default:
      jj_la1[64] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ValueClassExpression() throws ParseException {
    ValueClassValue();
  }

  final public void EntityBeanValue() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENTITY_VALUED_PATH:
      EntityValuedPath();
      break;
    case IDENTIFICATION_VARIABLE:
      IdentificationVariable();
      break;
    case ENTITY_VALUED_PARAMETER:
      EntityValuedParameter();
      break;
    default:
      jj_la1[65] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void EntityBeanExpression() throws ParseException {
    EntityBeanValue();
  }

////////////////////////////////////////////////////////////////////////////
  final public void FunctionsReturningStrings() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONCAT:
     ASTConcat jjtn001 = new ASTConcat(JJTCONCAT);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
      try {
        jj_consume_token(CONCAT);
        jj_consume_token(LPAREN);
        StringExpression();
        jj_consume_token(COMMA);
        StringExpression();
        jj_consume_token(RPAREN);
      } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
      } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, true);
     }
      }
      break;
    case SUBSTRING:
     ASTSubstring jjtn002 = new ASTSubstring(JJTSUBSTRING);
     boolean jjtc002 = true;
     jjtree.openNodeScope(jjtn002);
      try {
        jj_consume_token(SUBSTRING);
        jj_consume_token(LPAREN);
        StringExpression();
        jj_consume_token(COMMA);
        ArithmeticExpression();
        jj_consume_token(COMMA);
        ArithmeticExpression();
        jj_consume_token(RPAREN);
      } catch (Throwable jjte002) {
     if (jjtc002) {
       jjtree.clearNodeScope(jjtn002);
       jjtc002 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte002 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte002;}
     }
     if (jjte002 instanceof ParseException) {
       {if (true) throw (ParseException)jjte002;}
     }
     {if (true) throw (Error)jjte002;}
      } finally {
     if (jjtc002) {
       jjtree.closeNodeScope(jjtn002, true);
     }
      }
      break;
    case UCASE:
     ASTUCase jjtn003 = new ASTUCase(JJTUCASE);
     boolean jjtc003 = true;
     jjtree.openNodeScope(jjtn003);
      try {
        jj_consume_token(UCASE);
        jj_consume_token(LPAREN);
        StringExpression();
        jj_consume_token(RPAREN);
      } catch (Throwable jjte003) {
     if (jjtc003) {
       jjtree.clearNodeScope(jjtn003);
       jjtc003 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte003 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte003;}
     }
     if (jjte003 instanceof ParseException) {
       {if (true) throw (ParseException)jjte003;}
     }
     {if (true) throw (Error)jjte003;}
      } finally {
     if (jjtc003) {
       jjtree.closeNodeScope(jjtn003, true);
     }
      }
      break;
    case LCASE:
     ASTLCase jjtn004 = new ASTLCase(JJTLCASE);
     boolean jjtc004 = true;
     jjtree.openNodeScope(jjtn004);
      try {
        jj_consume_token(LCASE);
        jj_consume_token(LPAREN);
        StringExpression();
        jj_consume_token(RPAREN);
      } catch (Throwable jjte004) {
     if (jjtc004) {
       jjtree.clearNodeScope(jjtn004);
       jjtc004 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte004 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte004;}
     }
     if (jjte004 instanceof ParseException) {
       {if (true) throw (ParseException)jjte004;}
     }
     {if (true) throw (Error)jjte004;}
      } finally {
     if (jjtc004) {
       jjtree.closeNodeScope(jjtn004, true);
     }
      }
      break;
    default:
      jj_la1[66] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void FunctionsReturningNumerics() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LENGTH:
     ASTLength jjtn001 = new ASTLength(JJTLENGTH);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
      try {
        jj_consume_token(LENGTH);
        jj_consume_token(LPAREN);
        StringExpression();
        jj_consume_token(RPAREN);
      } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
      } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, true);
     }
      }
      break;
    case LOCATE:
     ASTLocate jjtn002 = new ASTLocate(JJTLOCATE);
     boolean jjtc002 = true;
     jjtree.openNodeScope(jjtn002);
      try {
        jj_consume_token(LOCATE);
        jj_consume_token(LPAREN);
        StringExpression();
        jj_consume_token(COMMA);
        StringExpression();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          ArithmeticExpression();
          break;
        default:
          jj_la1[67] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
      } catch (Throwable jjte002) {
     if (jjtc002) {
       jjtree.clearNodeScope(jjtn002);
       jjtc002 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte002 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte002;}
     }
     if (jjte002 instanceof ParseException) {
       {if (true) throw (ParseException)jjte002;}
     }
     {if (true) throw (Error)jjte002;}
      } finally {
     if (jjtc002) {
       jjtree.closeNodeScope(jjtn002, true);
     }
      }
      break;
    case ABS:
     ASTAbs jjtn003 = new ASTAbs(JJTABS);
     boolean jjtc003 = true;
     jjtree.openNodeScope(jjtn003);
      try {
        jj_consume_token(ABS);
        jj_consume_token(LPAREN);
        ArithmeticExpression();
        jj_consume_token(RPAREN);
      } catch (Throwable jjte003) {
     if (jjtc003) {
       jjtree.clearNodeScope(jjtn003);
       jjtc003 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte003 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte003;}
     }
     if (jjte003 instanceof ParseException) {
       {if (true) throw (ParseException)jjte003;}
     }
     {if (true) throw (Error)jjte003;}
      } finally {
     if (jjtc003) {
       jjtree.closeNodeScope(jjtn003, true);
     }
      }
      break;
    case SQRT:
     ASTSqrt jjtn004 = new ASTSqrt(JJTSQRT);
     boolean jjtc004 = true;
     jjtree.openNodeScope(jjtn004);
      try {
        jj_consume_token(SQRT);
        jj_consume_token(LPAREN);
        ArithmeticExpression();
        jj_consume_token(RPAREN);
      } catch (Throwable jjte004) {
     if (jjtc004) {
       jjtree.clearNodeScope(jjtn004);
       jjtc004 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte004 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte004;}
     }
     if (jjte004 instanceof ParseException) {
       {if (true) throw (ParseException)jjte004;}
     }
     {if (true) throw (Error)jjte004;}
      } finally {
     if (jjtc004) {
       jjtree.closeNodeScope(jjtn004, true);
     }
      }
      break;
    case MOD:
     ASTMod jjtn005 = new ASTMod(JJTMOD);
     boolean jjtc005 = true;
     jjtree.openNodeScope(jjtn005);
      try {
        jj_consume_token(MOD);
        jj_consume_token(LPAREN);
        ArithmeticExpression();
        jj_consume_token(COMMA);
        ArithmeticExpression();
        jj_consume_token(RPAREN);
      } catch (Throwable jjte005) {
     if (jjtc005) {
       jjtree.clearNodeScope(jjtn005);
       jjtc005 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte005 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte005;}
     }
     if (jjte005 instanceof ParseException) {
       {if (true) throw (ParseException)jjte005;}
     }
     {if (true) throw (Error)jjte005;}
      } finally {
     if (jjtc005) {
       jjtree.closeNodeScope(jjtn005, true);
     }
      }
      break;
    case COUNT:
    case MAX:
    case MIN:
    case AVG:
    case SUM:
      AggregateFunctions();
      break;
    default:
      jj_la1[68] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void AggregateFunctions() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AVG:
     ASTAvg jjtn001 = new ASTAvg(JJTAVG);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
      try {
        jj_consume_token(AVG);
        jj_consume_token(LPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DISTINCT:
          jj_consume_token(DISTINCT);
                                  jjtn001.distinct="DISTINCT";
          break;
        default:
          jj_la1[69] = jj_gen;
          ;
        }
        SingleValuedPath();
        jj_consume_token(RPAREN);
      } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
      } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, true);
     }
      }
      break;
    case MAX:
     ASTMax jjtn002 = new ASTMax(JJTMAX);
     boolean jjtc002 = true;
     jjtree.openNodeScope(jjtn002);
      try {
        jj_consume_token(MAX);
        jj_consume_token(LPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DISTINCT:
          jj_consume_token(DISTINCT);
                                  jjtn002.distinct="DISTINCT";
          break;
        default:
          jj_la1[70] = jj_gen;
          ;
        }
        SingleValuedPath();
        jj_consume_token(RPAREN);
      } catch (Throwable jjte002) {
     if (jjtc002) {
       jjtree.clearNodeScope(jjtn002);
       jjtc002 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte002 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte002;}
     }
     if (jjte002 instanceof ParseException) {
       {if (true) throw (ParseException)jjte002;}
     }
     {if (true) throw (Error)jjte002;}
      } finally {
     if (jjtc002) {
       jjtree.closeNodeScope(jjtn002, true);
     }
      }
      break;
    case MIN:
     ASTMin jjtn003 = new ASTMin(JJTMIN);
     boolean jjtc003 = true;
     jjtree.openNodeScope(jjtn003);
      try {
        jj_consume_token(MIN);
        jj_consume_token(LPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DISTINCT:
          jj_consume_token(DISTINCT);
                                  jjtn003.distinct="DISTINCT";
          break;
        default:
          jj_la1[71] = jj_gen;
          ;
        }
        SingleValuedPath();
        jj_consume_token(RPAREN);
      } catch (Throwable jjte003) {
     if (jjtc003) {
       jjtree.clearNodeScope(jjtn003);
       jjtc003 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte003 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte003;}
     }
     if (jjte003 instanceof ParseException) {
       {if (true) throw (ParseException)jjte003;}
     }
     {if (true) throw (Error)jjte003;}
      } finally {
     if (jjtc003) {
       jjtree.closeNodeScope(jjtn003, true);
     }
      }
      break;
    case SUM:
     ASTSum jjtn004 = new ASTSum(JJTSUM);
     boolean jjtc004 = true;
     jjtree.openNodeScope(jjtn004);
      try {
        jj_consume_token(SUM);
        jj_consume_token(LPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DISTINCT:
          jj_consume_token(DISTINCT);
                                  jjtn004.distinct="DISTINCT";
          break;
        default:
          jj_la1[72] = jj_gen;
          ;
        }
        SingleValuedPath();
        jj_consume_token(RPAREN);
      } catch (Throwable jjte004) {
     if (jjtc004) {
       jjtree.clearNodeScope(jjtn004);
       jjtc004 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte004 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte004;}
     }
     if (jjte004 instanceof ParseException) {
       {if (true) throw (ParseException)jjte004;}
     }
     {if (true) throw (Error)jjte004;}
      } finally {
     if (jjtc004) {
       jjtree.closeNodeScope(jjtn004, true);
     }
      }
      break;
    case COUNT:
     ASTCount jjtn005 = new ASTCount(JJTCOUNT);
     boolean jjtc005 = true;
     jjtree.openNodeScope(jjtn005);
      try {
        jj_consume_token(COUNT);
        jj_consume_token(LPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DISTINCT:
          jj_consume_token(DISTINCT);
                                    jjtn005.distinct="DISTINCT";
          break;
        default:
          jj_la1[73] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NUMERIC_VALUED_PATH:
        case STRING_VALUED_PATH:
        case DATETIME_VALUED_PATH:
        case BOOLEAN_VALUED_PATH:
        case ENTITY_VALUED_PATH:
        case VALUE_CLASS_VALUED_PATH:
          SingleValuedPath();
          break;
        case IDENTIFICATION_VARIABLE:
        case ENTITY_VALUED_PARAMETER:
          EntityBeanValue();
          break;
        default:
          jj_la1[74] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(RPAREN);
      } catch (Throwable jjte005) {
     if (jjtc005) {
       jjtree.clearNodeScope(jjtn005);
       jjtc005 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte005 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte005;}
     }
     if (jjte005 instanceof ParseException) {
       {if (true) throw (ParseException)jjte005;}
     }
     {if (true) throw (Error)jjte005;}
      } finally {
     if (jjtc005) {
       jjtree.closeNodeScope(jjtn005, true);
     }
      }
      break;
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Token CollectionValuedPath() throws ParseException {
 /*@bgen(jjtree) Path */
  ASTPath jjtn000 = new ASTPath(JJTPATH);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(COLLECTION_VALUED_PATH);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
      initPathNode(jjtn000, t.image, EJBQLTypes.ENTITY_TYPE);
      {if (true) return t;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
    throw new Error("Missing return statement in function");
  }

  final public Token IdentificationVariable() throws ParseException {
 /*@bgen(jjtree) Path */
  ASTPath jjtn000 = new ASTPath(JJTPATH);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(IDENTIFICATION_VARIABLE);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
      t.image = t.image.toLowerCase();
      initPathNode(jjtn000, t.image, EJBQLTypes.ENTITY_TYPE);
      {if (true) return t;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
    throw new Error("Missing return statement in function");
  }

  final public Token AbstractSchema() throws ParseException {
 /*@bgen(jjtree) AbstractSchema */
  ASTAbstractSchema jjtn000 = new ASTAbstractSchema(JJTABSTRACTSCHEMA);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT_SCHEMA:
        t = jj_consume_token(ABSTRACT_SCHEMA);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
      jjtn000.abstractSchemaName = t.image;
      jjtn000.entity = catalog.getEntityByAbstractSchemaName(t.image);
      {if (true) return t;}
        break;
      case ORDER:
        t = jj_consume_token(ORDER);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
      jjtn000.abstractSchemaName = t.image;
      jjtn000.entity = catalog.getEntityByAbstractSchemaName(t.image);
      {if (true) return t;}
        break;
      default:
        jj_la1[76] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
    throw new Error("Missing return statement in function");
  }

  final public Token Identifier() throws ParseException {
 /*@bgen(jjtree) Identifier */
  ASTIdentifier jjtn000 = new ASTIdentifier(JJTIDENTIFIER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
      t.image = t.image.toLowerCase();
      jjtn000.identifier = t.image;
      {if (true) return t;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
    throw new Error("Missing return statement in function");
  }

  final public void SingleValuedPath() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMERIC_VALUED_PATH:
      NumericValuedPath();
      break;
    case STRING_VALUED_PATH:
      StringValuedPath();
      break;
    case DATETIME_VALUED_PATH:
      DatetimeValuedPath();
      break;
    case BOOLEAN_VALUED_PATH:
      BooleanValuedPath();
      break;
    case ENTITY_VALUED_PATH:
      EntityValuedPath();
      break;
    case VALUE_CLASS_VALUED_PATH:
      ValueClassValuedPath();
      break;
    default:
      jj_la1[77] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void NumericValuedPath() throws ParseException {
 /*@bgen(jjtree) Path */
  ASTPath jjtn000 = new ASTPath(JJTPATH);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(NUMERIC_VALUED_PATH);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     initPathNode(jjtn000, t.image, EJBQLTypes.NUMERIC_TYPE);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void StringValuedPath() throws ParseException {
 /*@bgen(jjtree) Path */
  ASTPath jjtn000 = new ASTPath(JJTPATH);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(STRING_VALUED_PATH);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     initPathNode(jjtn000, t.image, EJBQLTypes.STRING_TYPE);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void DatetimeValuedPath() throws ParseException {
 /*@bgen(jjtree) Path */
  ASTPath jjtn000 = new ASTPath(JJTPATH);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(DATETIME_VALUED_PATH);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     initPathNode(jjtn000, t.image, EJBQLTypes.DATETIME_TYPE);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void BooleanValuedPath() throws ParseException {
 /*@bgen(jjtree) Path */
  ASTPath jjtn000 = new ASTPath(JJTPATH);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(BOOLEAN_VALUED_PATH);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     initPathNode(jjtn000, t.image, EJBQLTypes.BOOLEAN_TYPE);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void EntityValuedPath() throws ParseException {
 /*@bgen(jjtree) Path */
  ASTPath jjtn000 = new ASTPath(JJTPATH);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(ENTITY_VALUED_PATH);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     initPathNode(jjtn000, t.image, EJBQLTypes.ENTITY_TYPE);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void ValueClassValuedPath() throws ParseException {
 /*@bgen(jjtree) Path */
  ASTPath jjtn000 = new ASTPath(JJTPATH);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(VALUE_CLASS_VALUED_PATH);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     initPathNode(jjtn000, t.image, EJBQLTypes.VALUE_CLASS_TYPE);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void NumericValuedParameter() throws ParseException {
 /*@bgen(jjtree) Parameter */
  ASTParameter jjtn000 = new ASTParameter(JJTPARAMETER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(NUMERIC_VALUED_PARAMETER);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     initParameterNode(jjtn000, t.image, EJBQLTypes.NUMERIC_TYPE);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void StringValuedParameter() throws ParseException {
 /*@bgen(jjtree) Parameter */
  ASTParameter jjtn000 = new ASTParameter(JJTPARAMETER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(STRING_VALUED_PARAMETER);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     initParameterNode(jjtn000, t.image, EJBQLTypes.STRING_TYPE);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void DatetimeValuedParameter() throws ParseException {
 /*@bgen(jjtree) Parameter */
  ASTParameter jjtn000 = new ASTParameter(JJTPARAMETER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(DATETIME_VALUED_PARAMETER);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     initParameterNode(jjtn000, t.image, EJBQLTypes.DATETIME_TYPE);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void BooleanValuedParameter() throws ParseException {
 /*@bgen(jjtree) Parameter */
  ASTParameter jjtn000 = new ASTParameter(JJTPARAMETER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(BOOLEAN_VALUED_PARAMETER);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     initParameterNode(jjtn000, t.image, EJBQLTypes.BOOLEAN_TYPE);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void EntityValuedParameter() throws ParseException {
 /*@bgen(jjtree) Parameter */
  ASTParameter jjtn000 = new ASTParameter(JJTPARAMETER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(ENTITY_VALUED_PARAMETER);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     initParameterNode(jjtn000, t.image, EJBQLTypes.ENTITY_TYPE);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void ValueClassValuedParameter() throws ParseException {
 /*@bgen(jjtree) Parameter */
  ASTParameter jjtn000 = new ASTParameter(JJTPARAMETER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(VALUE_CLASS_VALUED_PARAMETER);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     initParameterNode(jjtn000, t.image, EJBQLTypes.VALUE_CLASS_TYPE);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void NumericLiteral() throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
     ASTExactNumericLiteral jjtn001 = new ASTExactNumericLiteral(JJTEXACTNUMERICLITERAL);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
      try {
        t = jj_consume_token(INTEGER_LITERAL);
                            jjtree.closeNodeScope(jjtn001, true);
                            jjtc001 = false;
                            jjtn001.setValue(t.image);
      } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, true);
     }
      }
      break;
    case FLOATING_POINT_LITERAL:
     ASTApproximateNumericLiteral jjtn002 = new ASTApproximateNumericLiteral(JJTAPPROXIMATENUMERICLITERAL);
     boolean jjtc002 = true;
     jjtree.openNodeScope(jjtn002);
      try {
        t = jj_consume_token(FLOATING_POINT_LITERAL);
                                   jjtree.closeNodeScope(jjtn002, true);
                                   jjtc002 = false;
                                   jjtn002.setValue(t.image);
      } finally {
     if (jjtc002) {
       jjtree.closeNodeScope(jjtn002, true);
     }
      }
      break;
    default:
      jj_la1[78] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void StringLiteral() throws ParseException {
 /*@bgen(jjtree) StringLiteral */
  ASTStringLiteral jjtn000 = new ASTStringLiteral(JJTSTRINGLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(STRING_LITERAL);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     jjtn000.value=t.image;
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void BooleanLiteral() throws ParseException {
 /*@bgen(jjtree) BooleanLiteral */
  ASTBooleanLiteral jjtn000 = new ASTBooleanLiteral(JJTBOOLEANLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
            jjtree.closeNodeScope(jjtn000, true);
            jjtc000 = false;
            jjtn000.value=true;
        break;
      case FALSE:
        jj_consume_token(FALSE);
                                              jjtree.closeNodeScope(jjtn000, true);
                                              jjtc000 = false;
                                              jjtn000.value=false;
        break;
      default:
        jj_la1[79] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_3R_24() {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_scan_token(MOD)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_116()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_116()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_117() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_106() {
    if (jj_scan_token(SQRT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_116()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_75()) jj_scanpos = xsp;
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_scan_token(ABS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_116()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_scan_token(LOCATE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_113()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_113()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_117()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_23() {
    if (jj_3R_49()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_50()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_72() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_scan_token(LENGTH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_113()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_12() {
    if (jj_3R_23()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_24()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_scan_token(LCASE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_113()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_99() {
    if (jj_scan_token(UCASE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_113()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_37() {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_43() {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_scan_token(SUBSTRING)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_113()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_116()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_116()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_58() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) {
    jj_scanpos = xsp;
    if (jj_3R_99()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_97() {
    if (jj_scan_token(CONCAT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_113()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_113()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_41() {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_199() {
    if (jj_3R_21()) return true;
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_21() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_36() {
    if (jj_3R_62()) return true;
    return false;
  }

  private boolean jj_3R_196() {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_40() {
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3R_20() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) return true;
    }
    return false;
  }

  private boolean jj_3R_39() {
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_209() {
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_18() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_3R_61()) return true;
    return false;
  }

  private boolean jj_3R_189() {
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_127() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_38() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) return true;
    }
    return false;
  }

  private boolean jj_3R_32() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_158() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_157() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_113()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_156() {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_155() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_143() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_155()) {
    jj_scanpos = xsp;
    if (jj_3R_156()) {
    jj_scanpos = xsp;
    if (jj_3R_157()) {
    jj_scanpos = xsp;
    if (jj_3R_158()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_113() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_126()) {
    jj_scanpos = xsp;
    if (jj_3R_127()) return true;
    }
    return false;
  }

  private boolean jj_3R_126() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_14() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_31() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_162() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_132() {
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_131() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_130() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_116()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_114() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_128()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) {
    jj_scanpos = xsp;
    if (jj_3R_130()) {
    jj_scanpos = xsp;
    if (jj_3R_131()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_128() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_159() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_3R_162()) return true;
    }
    return false;
  }

  private boolean jj_3R_161() {
    if (jj_scan_token(DIV)) return true;
    return false;
  }

  private boolean jj_3R_144() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_159()) jj_scanpos = xsp;
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_160() {
    if (jj_scan_token(MULT)) return true;
    return false;
  }

  private boolean jj_3R_145() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) return true;
    }
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_147() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_136() {
    if (jj_3R_144()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_145()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_146() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_137() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_146()) {
    jj_scanpos = xsp;
    if (jj_3R_147()) return true;
    }
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_3R_136()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_137()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_210() {
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_206() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_101()) {
    jj_scanpos = xsp;
    if (jj_3R_102()) return true;
    }
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_47() {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_205() {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  private boolean jj_3R_204() {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_203() {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  private boolean jj_3R_202() {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  private boolean jj_3R_201() {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_200() {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_22()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_73() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) return true;
    }
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_scan_token(VALUE_CLASS_VALUED_PARAMETER)) return true;
    return false;
  }

  private boolean jj_3R_198() {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  private boolean jj_3R_197() {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_21()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_3R_22()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_200()) {
    jj_scanpos = xsp;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) {
    jj_scanpos = xsp;
    if (jj_3R_205()) return true;
    }
    }
    }
    }
    }
    if (jj_3R_206()) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_scan_token(ENTITY_VALUED_PARAMETER)) return true;
    return false;
  }

  private boolean jj_3R_195() {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  private boolean jj_3R_94() {
    if (jj_3R_21()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_197()) {
    jj_scanpos = xsp;
    if (jj_3R_198()) return true;
    }
    if (jj_3R_199()) return true;
    return false;
  }

  private boolean jj_3R_194() {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_scan_token(BOOLEAN_VALUED_PARAMETER)) return true;
    return false;
  }

  private boolean jj_3R_193() {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  private boolean jj_3R_192() {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  private boolean jj_3R_191() {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_190() {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_20()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_scan_token(DATETIME_VALUED_PARAMETER)) return true;
    return false;
  }

  private boolean jj_3R_188() {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  private boolean jj_3R_187() {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_3R_20()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_190()) {
    jj_scanpos = xsp;
    if (jj_3R_191()) {
    jj_scanpos = xsp;
    if (jj_3R_192()) {
    jj_scanpos = xsp;
    if (jj_3R_193()) {
    jj_scanpos = xsp;
    if (jj_3R_194()) {
    jj_scanpos = xsp;
    if (jj_3R_195()) return true;
    }
    }
    }
    }
    }
    if (jj_3R_196()) return true;
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_scan_token(STRING_VALUED_PARAMETER)) return true;
    return false;
  }

  private boolean jj_3R_186() {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  private boolean jj_3R_185() {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  private boolean jj_3R_184() {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_183() {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_19()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_scan_token(NUMERIC_VALUED_PARAMETER)) return true;
    return false;
  }

  private boolean jj_3R_208() {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  private boolean jj_3R_207() {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_3R_19()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_183()) {
    jj_scanpos = xsp;
    if (jj_3R_184()) {
    jj_scanpos = xsp;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) {
    jj_scanpos = xsp;
    if (jj_3R_187()) {
    jj_scanpos = xsp;
    if (jj_3R_188()) return true;
    }
    }
    }
    }
    }
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_scan_token(VALUE_CLASS_VALUED_PATH)) return true;
    return false;
  }

  private boolean jj_3R_182() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_207()) {
    jj_scanpos = xsp;
    if (jj_3R_208()) return true;
    }
    if (jj_3R_209()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_3R_18()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_scan_token(ENTITY_VALUED_PATH)) return true;
    return false;
  }

  private boolean jj_3R_181() {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_3R_18()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_182()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_180() {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  private boolean jj_3R_179() {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_scan_token(BOOLEAN_VALUED_PATH)) return true;
    return false;
  }

  private boolean jj_3R_178() {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  private boolean jj_3R_169() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_163() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_177() {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_176() {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_14()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_scan_token(DATETIME_VALUED_PATH)) return true;
    return false;
  }

  private boolean jj_3R_56() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_3R_14()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_176()) {
    jj_scanpos = xsp;
    if (jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) {
    jj_scanpos = xsp;
    if (jj_3R_179()) {
    jj_scanpos = xsp;
    if (jj_3R_180()) {
    jj_scanpos = xsp;
    if (jj_3R_181()) return true;
    }
    }
    }
    }
    }
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_scan_token(STRING_VALUED_PATH)) return true;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_165() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_168() {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_scan_token(NUMERIC_VALUED_PATH)) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_53() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_165()) jj_scanpos = xsp;
    if (jj_scan_token(MEMBER)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(27)) jj_scanpos = xsp;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_173() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_125() {
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3R_124() {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_175() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_167() {
    if (jj_scan_token(ESCAPE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_168()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) return true;
    }
    return false;
  }

  private boolean jj_3R_123() {
    if (jj_3R_61()) return true;
    return false;
  }

  private boolean jj_3R_164() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_51() {
    if (jj_3R_77()) return true;
    if (jj_scan_token(IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_163()) jj_scanpos = xsp;
    if (jj_scan_token(EMPTY)) return true;
    return false;
  }

  private boolean jj_3R_122() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_121() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_171() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_112() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_120()) {
    jj_scanpos = xsp;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3R_122()) {
    jj_scanpos = xsp;
    if (jj_3R_123()) {
    jj_scanpos = xsp;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_120() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_3R_62()) return true;
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_166() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_172() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_17() {
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_174() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_52() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) return true;
    }
    }
    }
    }
    }
    if (jj_scan_token(IS)) return true;
    xsp = jj_scanpos;
    if (jj_3R_164()) jj_scanpos = xsp;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_170() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_3R_14()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_166()) jj_scanpos = xsp;
    if (jj_scan_token(LIKE)) return true;
    if (jj_3R_113()) return true;
    xsp = jj_scanpos;
    if (jj_3R_167()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_211() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_213() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_212() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_3R_19()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_174()) jj_scanpos = xsp;
    if (jj_scan_token(IN)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_19()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_175()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_16() {
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_3R_114()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_172()) jj_scanpos = xsp;
    if (jj_scan_token(IN)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_114()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_173()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_154() {
    if (jj_3R_21()) return true;
    return false;
  }

  private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_3R_113()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_170()) jj_scanpos = xsp;
    if (jj_scan_token(IN)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_113()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_171()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_152() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_scan_token(IDENTIFICATION_VARIABLE)) return true;
    return false;
  }

  private boolean jj_3R_135() {
    if (jj_3R_14()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_213()) jj_scanpos = xsp;
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_3R_14()) return true;
    if (jj_scan_token(AND)) return true;
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_3R_19()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_212()) jj_scanpos = xsp;
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_3R_19()) return true;
    if (jj_scan_token(AND)) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_15() {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_151() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3_4() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_15()) {
    jj_scanpos = xsp;
    if (jj_3R_16()) {
    jj_scanpos = xsp;
    if (jj_3R_17()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(24)) jj_scanpos = xsp;
    if (jj_scan_token(IN)) return true;
    return false;
  }

  private boolean jj_3R_115() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_133() {
    if (jj_3R_116()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_211()) jj_scanpos = xsp;
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_3R_116()) return true;
    if (jj_scan_token(AND)) return true;
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_14()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(24)) jj_scanpos = xsp;
    if (jj_scan_token(LIKE)) return true;
    return false;
  }

  private boolean jj_3R_150() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_scan_token(COLLECTION_VALUED_PATH)) return true;
    return false;
  }

  private boolean jj_3R_153() {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_30() {
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3R_149() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_29() {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_148() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_28() {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_27() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_142() {
    if (jj_scan_token(COUNT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_152()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_153()) {
    jj_scanpos = xsp;
    if (jj_3R_154()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_26() {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_141() {
    if (jj_scan_token(SUM)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_151()) jj_scanpos = xsp;
    if (jj_3R_112()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_13() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind==IS;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_26()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind==MEMBER || getToken(3).kind==MEMBER;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_25() {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_140() {
    if (jj_scan_token(MIN)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_150()) jj_scanpos = xsp;
    if (jj_3R_112()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_139() {
    if (jj_scan_token(MAX)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_149()) jj_scanpos = xsp;
    if (jj_3R_112()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_12()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_118() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_138()) {
    jj_scanpos = xsp;
    if (jj_3R_139()) {
    jj_scanpos = xsp;
    if (jj_3R_140()) {
    jj_scanpos = xsp;
    if (jj_3R_141()) {
    jj_scanpos = xsp;
    if (jj_3R_142()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_138() {
    if (jj_scan_token(AVG)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_148()) jj_scanpos = xsp;
    if (jj_3R_112()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3R_111() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_119()) {
    jj_scanpos = xsp;
    if (jj_3_2()) return true;
    }
    return false;
  }

  private boolean jj_3R_119() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_12()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_3R_118()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public JBossQLParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[80];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x80,0x80,0x8000,0xc4a07e20,0x10000000,0x40,0x10000000,0x40,0x1000000,0xc0a07e20,0x0,0xc0a07e20,0x1000000,0x1000000,0x1000000,0xc0a07e20,0x1000000,0x0,0x1000000,0x0,0x1000000,0x0,0xc0a07e20,0x1000000,0x0,0x20000,0x0,0x1000000,0x1000000,0x0,0x1000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0a07e20,0x80a07c20,0x0,0x0,0x0,0x0,0x0,0x0,0x80a07c20,0x40000200,0x40000200,0x40000200,0x0,0x0,0x0,0x0,0x40000200,0x0,0x80a07c20,0x8000,0x8000,0x8000,0x8000,0x8000,0x0,0x7c00,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x2,0x100,0xc0,0x4000,0x0,0x18,0x18,0x40,0xc0,0x4000,0x100,0x0,0x0,0x0,0xc20,0x0,0x0,0x0,0x0,0x0,0xc20,0x0,0x8cc01c20,0x0,0x0,0x0,0x8cc01c20,0x0,0x4000,0x0,0x4000,0x0,0x4000,0x8c001c20,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f0000,0x240000,0x240000,0x3f0000,0x3f0000,0x240000,0x3f0000,0x8cc01c20,0x88000800,0xc00000,0xc00000,0x3000000,0x3000000,0xc00000,0xc00000,0x88001800,0x4000420,0x4001420,0x4001420,0x0,0x0,0x0,0x0,0x420,0x4000,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x88000000,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x13c0000,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x1f80000,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x1fff006,0x0,0x0,0x0,0x38e000,0x0,0x0,0x0,0x0,0x0,0x0,0x38e000,0x0,0x2000,0x0,0x1fbe000,0x0,0x0,0x821000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x38e000,0x82000,0x0,0x0,0x0,0x0,0x0,0x0,0x82000,0x104000,0x104000,0x100000,0x208000,0x410006,0x1040000,0x821000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fa1000,0x0,0x800,0x1f80000,0x0,0x6,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[10];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public JBossQLParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public JBossQLParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new JBossQLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 80; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 80; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public JBossQLParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new JBossQLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 80; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 80; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public JBossQLParser(JBossQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 80; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(JBossQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 80; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[91];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 80; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 91; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 10; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
