/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.keygen;

import javax.ejb.CreateException;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCInsertPKCreateCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
import org.jboss.as.cmp.keygenerator.KeyGenerator;
import org.jboss.as.cmp.keygenerator.KeyGeneratorFactory;

public class JDBCKeyGeneratorCreateCommand
extends JDBCInsertPKCreateCommand {
    protected KeyGenerator keyGenerator;
    protected JDBCCMPFieldBridge pkField;

    @Override
    public void init(JDBCStoreManager manager) {
        super.init(manager);
        this.pkField = this.getGeneratedPKField();
    }

    @Override
    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) {
        super.initEntityCommand(entityCommand);
        String factoryName = entityCommand.getAttribute("key-generator-factory");
        if (factoryName == null) {
            throw CmpMessages.MESSAGES.entityMustHaveKeyFactory(factoryName);
        }
        try {
            KeyGeneratorFactory keyGeneratorFactory = this.entity.getManager().getKeyGeneratorFactory(factoryName);
            if (keyGeneratorFactory == null) {
                throw CmpMessages.MESSAGES.invalidKeyFactory(factoryName);
            }
            this.keyGenerator = keyGeneratorFactory.getKeyGenerator();
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.errorCreatingKeyFactory(factoryName, e);
        }
    }

    @Override
    protected void generateFields(CmpEntityBeanContext ctx) throws CreateException {
        super.generateFields(ctx);
        Object pk = this.keyGenerator.generateKey();
        this.log.debug((Object)("Generated new pk: " + pk));
        this.pkField.setInstanceValue(ctx, pk);
    }
}

