/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import java.io.Closeable;
import java.io.InputStream;
import org.jboss.as.connector.metadata.xmldescriptors.IronJacamarXmlDescriptor;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.metadata.ironjacamar.IronJacamarParser;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.InjectedValue;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class IronJacamarDeploymentParsingProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.PARSE_DESCRIPTORS.plus(501L);
    private final InjectedValue<MetadataRepository> mdr = new InjectedValue();

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        block9: {
            VirtualFile deploymentRoot = VirtualFileAttachment.getVirtualFileAttachment((DeploymentUnitContext)context);
            if (deploymentRoot == null || !deploymentRoot.exists()) {
                return;
            }
            String deploymentRootName = deploymentRoot.getName();
            VirtualFile serviceXmlFile = null;
            if (deploymentRootName.endsWith(".rar")) {
                serviceXmlFile = deploymentRoot.getChild("/META-INF/ironjacamar.xml");
            }
            if (serviceXmlFile == null || !serviceXmlFile.exists()) {
                return;
            }
            InputStream xmlStream = null;
            IronJacamar result = null;
            try {
                xmlStream = serviceXmlFile.openStream();
                result = new IronJacamarParser().parse(xmlStream);
                if (result != null) {
                    IronJacamarXmlDescriptor xmlDescriptor = new IronJacamarXmlDescriptor(result);
                    context.putAttachment(IronJacamarXmlDescriptor.ATTACHMENT_KEY, (Object)xmlDescriptor);
                    break block9;
                }
                throw new DeploymentUnitProcessingException("Failed to parse service xml [" + serviceXmlFile + "]");
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException("Failed to parse service xml [" + serviceXmlFile + "]", (Throwable)e);
            }
            finally {
                VFSUtils.safeClose((Closeable)xmlStream);
            }
        }
    }

    public Injector<MetadataRepository> getMdrInjector() {
        return this.mdr;
    }
}

