/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.connector;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.connector.subsystems.connector.Attribute;
import org.jboss.as.connector.subsystems.connector.ConnectorSubsystemAdd;
import org.jboss.as.connector.subsystems.connector.Element;
import org.jboss.as.connector.subsystems.connector.Namespace;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

final class ConnectorSubsystemElement
extends AbstractSubsystemElement<ConnectorSubsystemElement> {
    private static final long serialVersionUID = 6451041006443208660L;
    private boolean archiveValidation = true;
    private boolean archiveValidationFailOnError = true;
    private boolean archiveValidationFailOnWarn = false;
    private boolean beanValidation = true;
    private String longRunningThreadPool;
    private String shortRunningThreadPool;

    public ConnectorSubsystemElement() {
        super(Namespace.CONNECTOR_1_0.getUriString());
    }

    protected Class<ConnectorSubsystemElement> getElementClass() {
        return ConnectorSubsystemElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeEmptyElement(Element.ARCHIVE_VALIDATION.getLocalName());
        streamWriter.writeAttribute(Attribute.ENABLED.getLocalName(), Boolean.toString(this.archiveValidation));
        streamWriter.writeAttribute(Attribute.FAIL_ON_WARN.getLocalName(), Boolean.toString(this.archiveValidationFailOnWarn));
        streamWriter.writeAttribute(Attribute.FAIL_ON_ERROR.getLocalName(), Boolean.toString(this.archiveValidationFailOnError));
        streamWriter.writeEmptyElement(Element.BEAN_VALIDATION.getLocalName());
        streamWriter.writeAttribute(Attribute.ENABLED.getLocalName(), Boolean.toString(this.beanValidation));
        streamWriter.writeEmptyElement(Element.DEFAULT_WORKMANAGER.getLocalName());
        streamWriter.writeAttribute(Attribute.SHORT_RUNNING_THREAD_POOL.getLocalName(), this.shortRunningThreadPool);
        streamWriter.writeAttribute(Attribute.LONG_RUNNING_THREAD_POOL.getLocalName(), this.longRunningThreadPool);
        streamWriter.writeEndElement();
    }

    protected void getUpdates(List<? super AbstractSubsystemUpdate<ConnectorSubsystemElement, ?>> objects) {
    }

    protected boolean isEmpty() {
        return true;
    }

    protected AbstractSubsystemAdd<ConnectorSubsystemElement> getAdd() {
        ConnectorSubsystemAdd add = new ConnectorSubsystemAdd();
        add.setArchiveValidation(this.archiveValidation);
        add.setArchiveValidationFailOnError(this.archiveValidationFailOnError);
        add.setArchiveValidationFailOnWarn(this.archiveValidationFailOnWarn);
        add.setBeanValidation(this.beanValidation);
        add.setLongRunningThreadPool(this.longRunningThreadPool);
        add.setShortRunningThreadPool(this.shortRunningThreadPool);
        return add;
    }

    protected <P> void applyRemove(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
    }

    public boolean isArchiveValidation() {
        return this.archiveValidation;
    }

    public void setArchiveValidation(boolean archiveValidation) {
        this.archiveValidation = archiveValidation;
    }

    public boolean isArchiveValidationFailOnError() {
        return this.archiveValidationFailOnError;
    }

    public void setArchiveValidationFailOnError(boolean archiveValidationFailOnError) {
        this.archiveValidationFailOnError = archiveValidationFailOnError;
    }

    public boolean isArchiveValidationFailOnWarn() {
        return this.archiveValidationFailOnWarn;
    }

    public void setArchiveValidationFailOnWarn(boolean archiveValidationFailOnWarn) {
        this.archiveValidationFailOnWarn = archiveValidationFailOnWarn;
    }

    public boolean isBeanValidation() {
        return this.beanValidation;
    }

    public void setBeanValidation(boolean beanValidation) {
        this.beanValidation = beanValidation;
    }

    public String getLongRunningThreadPool() {
        return this.longRunningThreadPool;
    }

    public void setLongRunningThreadPool(String longRunningThreadPool) {
        this.longRunningThreadPool = longRunningThreadPool;
    }

    public String getShortRunningThreadPool() {
        return this.shortRunningThreadPool;
    }

    public void setShortRunningThreadPool(String shortRunningThreadPool) {
        this.shortRunningThreadPool = shortRunningThreadPool;
    }
}

