/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.pool.PoolConfigurationRWHandler;
import org.jboss.as.connector.pool.PoolMetrics;
import org.jboss.as.connector.pool.PoolOperations;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.DataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.DataSourceDisable;
import org.jboss.as.connector.subsystems.datasources.DataSourceEnable;
import org.jboss.as.connector.subsystems.datasources.DataSourceModelNodeUtil;
import org.jboss.as.connector.subsystems.datasources.DataSourceRemove;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemAdd;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.connector.subsystems.datasources.Element;
import org.jboss.as.connector.subsystems.datasources.GetInstalledDriverOperationHandler;
import org.jboss.as.connector.subsystems.datasources.InstalledDriversListOperationHandler;
import org.jboss.as.connector.subsystems.datasources.JdbcDriverAdd;
import org.jboss.as.connector.subsystems.datasources.JdbcDriverRemove;
import org.jboss.as.connector.subsystems.datasources.LocalAndXaDataSourcesJdbcMetrics;
import org.jboss.as.connector.subsystems.datasources.Namespace;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceRemove;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.Driver;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.metadata.ds.DsParser;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class DataSourcesExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.datasources");

    public void initialize(ExtensionContext context) {
        log.debugf("Initializing Datasources Extension", new Object[0]);
        SubsystemRegistration registration = context.registerSubsystem("datasources");
        registration.registerXMLElementWriter((XMLElementWriter)NewDataSourceSubsystemParser.INSTANCE);
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel(DataSourcesSubsystemProviders.SUBSYSTEM);
        subsystem.registerOperationHandler("add", (OperationStepHandler)DataSourcesSubsystemAdd.INSTANCE, DataSourcesSubsystemProviders.SUBSYSTEM_ADD_DESC, false);
        subsystem.registerOperationHandler("describe", (OperationStepHandler)DataSourcesSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)DataSourcesSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerOperationHandler("installed-drivers-list", (OperationStepHandler)InstalledDriversListOperationHandler.INSTANCE, DataSourcesSubsystemProviders.INSTALLED_DRIVERS_LIST_DESC);
        subsystem.registerOperationHandler("get-installed-driver", (OperationStepHandler)GetInstalledDriverOperationHandler.INSTANCE, DataSourcesSubsystemProviders.GET_INSTALLED_DRIVER_DESC);
        ManagementResourceRegistration jdbcDrivers = subsystem.registerSubModel(PathElement.pathElement((String)"jdbc-driver"), DataSourcesSubsystemProviders.JDBC_DRIVER_DESC);
        jdbcDrivers.registerOperationHandler("add", (OperationStepHandler)JdbcDriverAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_JDBC_DRIVER_DESC, false);
        jdbcDrivers.registerOperationHandler("remove", (OperationStepHandler)JdbcDriverRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_JDBC_DRIVER_DESC, false);
        ManagementResourceRegistration dataSources = subsystem.registerSubModel(PathElement.pathElement((String)"data-source"), DataSourcesSubsystemProviders.DATA_SOURCE_DESC);
        dataSources.registerOperationHandler("add", (OperationStepHandler)DataSourceAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_DATA_SOURCE_DESC, false);
        dataSources.registerOperationHandler("remove", (OperationStepHandler)DataSourceRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_DATA_SOURCE_DESC, false);
        dataSources.registerOperationHandler("enable", (OperationStepHandler)DataSourceEnable.LOCAL_INSTANCE, DataSourcesSubsystemProviders.ENABLE_DATA_SOURCE_DESC, false);
        dataSources.registerOperationHandler("disable", (OperationStepHandler)DataSourceDisable.INSTANCE, DataSourcesSubsystemProviders.DISABLE_DATA_SOURCE_DESC, false);
        dataSources.registerOperationHandler("flush-idle-connection-in-pool", (OperationStepHandler)PoolOperations.FlushIdleConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.FLUSH_IDLE_CONNECTION_DESC, false);
        dataSources.registerOperationHandler("flush-all-connection-in-pool", (OperationStepHandler)PoolOperations.FlushAllConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.FLUSH_ALL_CONNECTION_DESC, false);
        dataSources.registerOperationHandler("test-connection-in-pool", (OperationStepHandler)PoolOperations.TestConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.TEST_CONNECTION_DESC, false);
        for (String attributeName : PoolMetrics.ATTRIBUTES) {
            dataSources.registerMetric(attributeName, (OperationStepHandler)PoolMetrics.LocalAndXaDataSourcePoolMetricsHandler.INSTANCE);
        }
        for (String attributeName : LocalAndXaDataSourcesJdbcMetrics.ATTRIBUTES) {
            dataSources.registerMetric(attributeName, (OperationStepHandler)LocalAndXaDataSourcesJdbcMetrics.INSTANCE);
        }
        for (String attributeName : PoolConfigurationRWHandler.ATTRIBUTES) {
            dataSources.registerReadWriteAttribute(attributeName, (OperationStepHandler)PoolConfigurationRWHandler.PoolConfigurationReadHandler.INSTANCE, (OperationStepHandler)PoolConfigurationRWHandler.LocalAndXaDataSourcePoolConfigurationWriteHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration xaDataSources = subsystem.registerSubModel(PathElement.pathElement((String)"xa-data-source"), DataSourcesSubsystemProviders.XA_DATA_SOURCE_DESC);
        xaDataSources.registerOperationHandler("add", (OperationStepHandler)XaDataSourceAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_XA_DATA_SOURCE_DESC, false);
        xaDataSources.registerOperationHandler("remove", (OperationStepHandler)XaDataSourceRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_XA_DATA_SOURCE_DESC, false);
        xaDataSources.registerOperationHandler("enable", (OperationStepHandler)DataSourceEnable.XA_INSTANCE, DataSourcesSubsystemProviders.ENABLE_XA_DATA_SOURCE_DESC, false);
        xaDataSources.registerOperationHandler("disable", (OperationStepHandler)DataSourceDisable.INSTANCE, DataSourcesSubsystemProviders.DISABLE_XA_DATA_SOURCE_DESC, false);
        xaDataSources.registerOperationHandler("flush-idle-connection-in-pool", (OperationStepHandler)PoolOperations.FlushIdleConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.FLUSH_IDLE_CONNECTION_DESC, false);
        xaDataSources.registerOperationHandler("flush-all-connection-in-pool", (OperationStepHandler)PoolOperations.FlushAllConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.FLUSH_ALL_CONNECTION_DESC, false);
        xaDataSources.registerOperationHandler("test-connection-in-pool", (OperationStepHandler)PoolOperations.TestConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.TEST_CONNECTION_DESC, false);
        for (String attributeName : PoolMetrics.ATTRIBUTES) {
            xaDataSources.registerMetric(attributeName, (OperationStepHandler)PoolMetrics.LocalAndXaDataSourcePoolMetricsHandler.INSTANCE);
        }
        for (String attributeName : LocalAndXaDataSourcesJdbcMetrics.ATTRIBUTES) {
            xaDataSources.registerMetric(attributeName, (OperationStepHandler)LocalAndXaDataSourcesJdbcMetrics.INSTANCE);
        }
        for (String attributeName : PoolConfigurationRWHandler.ATTRIBUTES) {
            xaDataSources.registerReadWriteAttribute(attributeName, (OperationStepHandler)PoolConfigurationRWHandler.PoolConfigurationReadHandler.INSTANCE, (OperationStepHandler)PoolConfigurationRWHandler.LocalAndXaDataSourcePoolConfigurationWriteHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)NewDataSourceSubsystemParser.INSTANCE);
    }

    private static class DataSourcesSubsystemDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final DataSourcesSubsystemDescribeHandler INSTANCE = new DataSourcesSubsystemDescribeHandler();

        private DataSourcesSubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode dataSource;
            ModelNode addOperation;
            ModelNode address;
            ModelNode result = context.getResult();
            PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
            ModelNode subModel = context.readModel(PathAddress.EMPTY_ADDRESS);
            ModelNode subsystemAdd = new ModelNode();
            subsystemAdd.get("operation").set("add");
            subsystemAdd.get("address").set(rootAddress.toModelNode());
            result.add(subsystemAdd);
            if (subModel.hasDefined("jdbc-driver")) {
                for (Property jdbcDriver : subModel.get("jdbc-driver").asPropertyList()) {
                    address = rootAddress.toModelNode();
                    address.add("jdbc-driver", jdbcDriver.getName());
                    addOperation = Util.getEmptyOperation((String)"add", (ModelNode)address);
                    addOperation.get("driver-name").set(jdbcDriver.getValue().get("driver-name"));
                    addOperation.get("driver-module-name").set(jdbcDriver.getValue().get("driver-module-name"));
                    addOperation.get("driver-major-version").set(jdbcDriver.getValue().get("driver-major-version"));
                    addOperation.get("driver-minor-version").set(jdbcDriver.getValue().get("driver-minor-version"));
                    addOperation.get("driver-class-name").set(jdbcDriver.getValue().get("driver-class-name"));
                    addOperation.get("driver-xa-datasource-class-name").set(jdbcDriver.getValue().get("driver-xa-datasource-class-name"));
                    result.add(addOperation);
                }
            }
            if (subModel.hasDefined("data-source")) {
                for (Property dataSourceProp : subModel.get("data-source").asPropertyList()) {
                    address = rootAddress.toModelNode();
                    address.add("data-source", dataSourceProp.getName());
                    addOperation = Util.getEmptyOperation((String)"add", (ModelNode)address);
                    dataSource = dataSourceProp.getValue();
                    AbstractDataSourceAdd.populateAddModel(dataSource, addOperation, "connection-properties", DataSourcesSubsystemProviders.DATASOURCE_ATTRIBUTE);
                    addOperation.get("driver-name").set(dataSourceProp.getValue().get("driver-name"));
                    result.add(addOperation);
                }
            }
            if (subModel.hasDefined("xa-data-source")) {
                for (Property dataSourceProp : subModel.get("xa-data-source").asPropertyList()) {
                    address = rootAddress.toModelNode();
                    address.add("xa-data-source", dataSourceProp.getName());
                    addOperation = Util.getEmptyOperation((String)"add", (ModelNode)address);
                    dataSource = dataSourceProp.getValue();
                    AbstractDataSourceAdd.populateAddModel(dataSource, addOperation, "xa-data-source-properties", DataSourcesSubsystemProviders.XA_DATASOURCE_ATTRIBUTE);
                    addOperation.get("driver-name").set(dataSourceProp.getValue().get("driver-name"));
                    result.add(addOperation);
                }
            }
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static final class NewDataSourceSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        static final NewDataSourceSubsystemParser INSTANCE = new NewDataSourceSubsystemParser();

        NewDataSourceSubsystemParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode node = context.getModelNode();
            writer.writeStartElement("datasources");
            if (node.hasDefined("data-source") || node.hasDefined("xa-data-source")) {
                List propertyList;
                List list = propertyList = node.hasDefined("data-source") ? node.get("data-source").asPropertyList() : new LinkedList();
                if (node.hasDefined("xa-data-source")) {
                    propertyList.addAll(node.get("xa-data-source").asPropertyList());
                }
                for (Property property : propertyList) {
                    boolean statementRequired;
                    boolean timeoutRequired;
                    boolean validationRequired;
                    boolean recoveryRequired;
                    boolean securityRequired;
                    ModelNode dataSourceNode = property.getValue();
                    boolean isXADataSource = this.hasAnyOf(dataSourceNode, "xa-resource-timeout", "xa-data-source-class", "xa-data-source-properties");
                    writer.writeStartElement(isXADataSource ? DataSources.Tag.XA_DATASOURCE.getLocalName() : DataSources.Tag.DATASOURCE.getLocalName());
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.JNDINAME, "jndi-name");
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.POOL_NAME, "pool-name");
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.ENABLED, "enabled");
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.JTA, "jta");
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.USEJAVACONTEXT, "use-java-context");
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.SPY, "spy");
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.USE_CCM, "use-ccm");
                    if (!isXADataSource) {
                        this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.CONNECTIONURL, "connection-url");
                        this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.DRIVERCLASS, "driver-class");
                        if (dataSourceNode.hasDefined("connection-properties")) {
                            for (Property connectionProperty : dataSourceNode.get("connection-properties").asPropertyList()) {
                                this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), DataSource.Tag.CONNECTIONPROPERTY.getLocalName());
                            }
                        }
                    }
                    if (isXADataSource) {
                        if (dataSourceNode.hasDefined("xa-data-source-properties")) {
                            for (Property prop : dataSourceNode.get("xa-data-source-properties").asPropertyList()) {
                                writer.writeStartElement(XaDataSource.Tag.XADATASOURCEPROPERTY.getLocalName());
                                writer.writeAttribute("name", prop.getName());
                                writer.writeCharacters(prop.getValue().asString());
                                writer.writeEndElement();
                            }
                        }
                        this.writeElementIfHas(writer, dataSourceNode, XaDataSource.Tag.XADATASOURCECLASS, "xa-data-source-class");
                    }
                    this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.DRIVER, "driver-name");
                    if (isXADataSource) {
                        this.writeElementIfHas(writer, dataSourceNode, XaDataSource.Tag.URLDELIMITER, "url-delimiter");
                        this.writeElementIfHas(writer, dataSourceNode, XaDataSource.Tag.URLSELECTORSTRATEGYCLASSNAME, "url-selector-strategy-class-name");
                    }
                    this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.NEWCONNECTIONSQL, "new-connection-sql");
                    this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.TRANSACTIONISOLATION, "transaction-isolation");
                    if (!isXADataSource) {
                        this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.URLDELIMITER, "url-delimiter");
                        this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.URLSELECTORSTRATEGYCLASSNAME, "url-selector-strategy-class-name");
                    }
                    boolean poolRequired = this.hasAnyOf(dataSourceNode, "min-pool-size", "max-pool-size", "pool-prefill", "pool-use-strict-min", "flush-strategy");
                    if (isXADataSource) {
                        boolean bl = poolRequired = poolRequired || this.hasAnyOf(dataSourceNode, "same-rm-override", "interliving", "no-tx-separate-pool", "pad-xid", "wrap-xa-datasource");
                    }
                    if (poolRequired) {
                        writer.writeStartElement(isXADataSource ? XaDataSource.Tag.XA_POOL.getLocalName() : DataSource.Tag.POOL.getLocalName());
                        this.writeElementIfHas(writer, dataSourceNode, CommonPool.Tag.MIN_POOL_SIZE, "min-pool-size");
                        this.writeElementIfHas(writer, dataSourceNode, CommonPool.Tag.MAXPOOLSIZE, "max-pool-size");
                        this.writeElementIfHas(writer, dataSourceNode, CommonPool.Tag.PREFILL, "pool-prefill");
                        this.writeElementIfHas(writer, dataSourceNode, CommonPool.Tag.USE_STRICT_MIN, "pool-use-strict-min");
                        this.writeElementIfHas(writer, dataSourceNode, CommonPool.Tag.FLUSH_STRATEGY, "flush-strategy");
                        if (isXADataSource) {
                            this.writeEmptyElementIfHasAndTrue(writer, dataSourceNode, CommonXaPool.Tag.ISSAMERMOVERRIDEVALUE, "same-rm-override");
                            this.writeEmptyElementIfHasAndTrue(writer, dataSourceNode, CommonXaPool.Tag.INTERLEAVING, "interliving");
                            this.writeEmptyElementIfHasAndTrue(writer, dataSourceNode, CommonXaPool.Tag.NO_TX_SEPARATE_POOLS, "no-tx-separate-pool");
                            this.writeElementIfHas(writer, dataSourceNode, CommonXaPool.Tag.PAD_XID, "pad-xid");
                            this.writeElementIfHas(writer, dataSourceNode, CommonXaPool.Tag.WRAP_XA_RESOURCE, "wrap-xa-datasource");
                        }
                        writer.writeEndElement();
                    }
                    if (securityRequired = this.hasAnyOf(dataSourceNode, "user-name", "password", "security-domain", "reauth-plugin-class-name", "reauth-plugin-properties")) {
                        writer.writeStartElement(DataSource.Tag.SECURITY.getLocalName());
                        this.writeElementIfHas(writer, dataSourceNode, DsSecurity.Tag.USERNAME, "user-name");
                        this.writeElementIfHas(writer, dataSourceNode, DsSecurity.Tag.PASSWORD, "password");
                        this.writeElementIfHas(writer, dataSourceNode, DsSecurity.Tag.SECURITY_DOMAIN, "security-domain");
                        if (dataSourceNode.hasDefined("reauth-plugin-class-name")) {
                            writer.writeStartElement(DsSecurity.Tag.REAUTH_PLUGIN.getLocalName());
                            writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get("reauth-plugin-class-name").asString());
                            if (dataSourceNode.hasDefined("reauth-plugin-properties")) {
                                for (Property connectionProperty : dataSourceNode.get("reauth-plugin-properties").asPropertyList()) {
                                    this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                                }
                            }
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    if (recoveryRequired = this.hasAnyOf(dataSourceNode, "recovery-username", "recovery-password", "recovery-security-domain", "recovery-plugin-class-name", "no-recovery", "recovery-plugin-properties")) {
                        writer.writeStartElement(XaDataSource.Tag.RECOVERY.getLocalName());
                        this.writeAttributeIfHas(writer, dataSourceNode, Recovery.Attribute.NO_RECOVERY, "no-recovery");
                        if (this.hasAnyOf(dataSourceNode, "recovery-username", "recovery-password", "recovery-security-domain")) {
                            writer.writeStartElement(Recovery.Tag.RECOVER_CREDENTIAL.getLocalName());
                            this.writeElementIfHas(writer, dataSourceNode, Credential.Tag.USERNAME.getLocalName(), "recovery-username");
                            this.writeElementIfHas(writer, dataSourceNode, Credential.Tag.PASSWORD.getLocalName(), "recovery-password");
                            this.writeElementIfHas(writer, dataSourceNode, Credential.Tag.SECURITY_DOMAIN.getLocalName(), "recovery-security-domain");
                            writer.writeEndElement();
                        }
                        if (this.hasAnyOf(dataSourceNode, "recovery-plugin-class-name")) {
                            writer.writeStartElement(Recovery.Tag.RECOVER_PLUGIN.getLocalName());
                            writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get("recovery-plugin-class-name").asString());
                            if (dataSourceNode.hasDefined("recovery-plugin-properties")) {
                                for (Property connectionProperty : dataSourceNode.get("recovery-plugin-properties").asPropertyList()) {
                                    this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                                }
                            }
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    if (validationRequired = this.hasAnyOf(dataSourceNode, "valid-connection-checker-class-name", "valid-connection-checker-properties", "check-valid-connection-sql", "validate-on-match", "background-validation", "background-validation-minutes", "use-fast-fail", "stale-connection-checker-class-name", "stale-connection-checker-properties", "exception-sorter-class-name", "exception-sorter-properties")) {
                        writer.writeStartElement(DataSource.Tag.VALIDATION.getLocalName());
                        if (dataSourceNode.hasDefined("valid-connection-checker-class-name")) {
                            writer.writeStartElement(Validation.Tag.VALIDCONNECTIONCHECKER.getLocalName());
                            writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get("valid-connection-checker-class-name").asString());
                            if (dataSourceNode.hasDefined("valid-connection-checker-properties")) {
                                for (Property connectionProperty : dataSourceNode.get("valid-connection-checker-properties").asPropertyList()) {
                                    this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                                }
                            }
                            writer.writeEndElement();
                        }
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.CHECKVALIDCONNECTIONSQL, "check-valid-connection-sql");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.VALIDATEONMATCH, "validate-on-match");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.BACKGROUNDVALIDATION, "background-validation");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.BACKGROUNDVALIDATIONMINUTES, "background-validation-minutes");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.USEFASTFAIL, "use-fast-fail");
                        if (dataSourceNode.hasDefined("stale-connection-checker-class-name")) {
                            writer.writeStartElement(Validation.Tag.STALECONNECTIONCHECKER.getLocalName());
                            writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get("stale-connection-checker-class-name").asString());
                            if (dataSourceNode.hasDefined("stale-connection-checker-properties")) {
                                for (Property connectionProperty : dataSourceNode.get("stale-connection-checker-properties").asPropertyList()) {
                                    this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                                }
                            }
                            writer.writeEndElement();
                        }
                        if (dataSourceNode.hasDefined("exception-sorter-class-name")) {
                            writer.writeStartElement(Validation.Tag.EXCEPTIONSORTER.getLocalName());
                            writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get("exception-sorter-class-name").asString());
                            if (dataSourceNode.hasDefined("exception-sorter-properties")) {
                                for (Property connectionProperty : dataSourceNode.get("exception-sorter-properties").asPropertyList()) {
                                    this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                                }
                            }
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    if (timeoutRequired = this.hasAnyOf(dataSourceNode, "blocking-timeout-wait-millis", "idle-timeout-minutes", "set-tx-query-timeout", "query-timeout", "use-try-lock", "allocation-retry", "allocation-retry-wait-millis", "xa-resource-timeout")) {
                        writer.writeStartElement(DataSource.Tag.TIMEOUT.getLocalName());
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.BLOCKINGTIMEOUTMILLIS, "blocking-timeout-wait-millis");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.IDLETIMEOUTMINUTES, "idle-timeout-minutes");
                        this.writeEmptyElementIfHasAndTrue(writer, dataSourceNode, TimeOut.Tag.SETTXQUERYTIMEOUT, "set-tx-query-timeout");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.QUERYTIMEOUT, "query-timeout");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.USETRYLOCK, "use-try-lock");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.ALLOCATIONRETRY, "allocation-retry");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.ALLOCATIONRETRYWAITMILLIS, "allocation-retry-wait-millis");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.XARESOURCETIMEOUT, "xa-resource-timeout");
                        writer.writeEndElement();
                    }
                    if (statementRequired = this.hasAnyOf(dataSourceNode, "track-statements", "prepared-statements-cacheSize", "share-prepared-statements")) {
                        writer.writeStartElement(DataSource.Tag.STATEMENT.getLocalName());
                        this.writeElementIfHas(writer, dataSourceNode, Statement.Tag.TRACKSTATEMENTS, "track-statements");
                        this.writeElementIfHas(writer, dataSourceNode, Statement.Tag.PREPAREDSTATEMENTCACHESIZE, "prepared-statements-cacheSize");
                        this.writeEmptyElementIfHasAndTrue(writer, dataSourceNode, Statement.Tag.SHAREPREPAREDSTATEMENTS, "share-prepared-statements");
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
            }
            if (node.hasDefined("jdbc-driver")) {
                writer.writeStartElement(DataSources.Tag.DRIVERS.getLocalName());
                for (Property driverProperty : node.get("jdbc-driver").asPropertyList()) {
                    writer.writeStartElement(DataSources.Tag.DRIVER.getLocalName());
                    writer.writeAttribute(Driver.Attribute.NAME.getLocalName(), driverProperty.getValue().require("driver-name").asString());
                    this.writeAttributeIfHas(writer, driverProperty.getValue(), Driver.Attribute.MODULE, "driver-module-name");
                    this.writeAttributeIfHas(writer, driverProperty.getValue(), Driver.Attribute.MAJOR_VERSION, "driver-major-version");
                    this.writeAttributeIfHas(writer, driverProperty.getValue(), Driver.Attribute.MINOR_VERSION, "driver-minor-version");
                    this.writeElementIfHas(writer, driverProperty.getValue(), Driver.Tag.DRIVERCLASS.getLocalName(), "driver-class-name");
                    this.writeElementIfHas(writer, driverProperty.getValue(), Driver.Tag.XADATASOURCECLASS.getLocalName(), "driver-xa-datasource-class-name");
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, Recovery.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, Driver.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, DataSource.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        private void writeProperty(XMLExtendedStreamWriter writer, ModelNode node, String name, String value, String localName) throws XMLStreamException {
            writer.writeStartElement(localName);
            writer.writeAttribute("name", name);
            writer.writeCharacters(value);
            writer.writeEndElement();
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, String localName, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeStartElement(localName);
                writer.writeCharacters(node.get(identifier).asString());
                writer.writeEndElement();
            }
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, XaDataSource.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, DataSource.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, DsSecurity.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonPool.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonXaPool.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, TimeOut.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, Validation.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, Statement.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, String localName, String identifier) throws XMLStreamException {
            if (node.has(identifier) && node.get(identifier).asBoolean()) {
                writer.writeEmptyElement(localName);
            }
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, Statement.Tag element, String identifier) throws XMLStreamException {
            this.writeEmptyElementIfHasAndTrue(writer, node, element.getLocalName(), identifier);
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, CommonXaPool.Tag element, String identifier) throws XMLStreamException {
            this.writeEmptyElementIfHasAndTrue(writer, node, element.getLocalName(), identifier);
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, TimeOut.Tag element, String identifier) throws XMLStreamException {
            this.writeEmptyElementIfHasAndTrue(writer, node, element.getLocalName(), identifier);
        }

        private boolean hasAnyOf(ModelNode node, String ... names) {
            for (String current : names) {
                if (!this.has(node, current)) continue;
                return true;
            }
            return false;
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode address = new ModelNode();
            address.add("subsystem", "datasources");
            address.protect();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address);
            list.add(subsystem);
            DataSources dataSources = null;
            try {
                String localName = null;
                block1 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case DATASOURCES_1_0: {
                        localName = reader.getLocalName();
                        Element element = Element.forName(reader.getLocalName());
                        log.tracef("%s -> %s", (Object)localName, (Object)element);
                        switch (element) {
                            case SUBSYSTEM: {
                                DsParser parser = new DsParser();
                                dataSources = parser.parse((XMLStreamReader)reader);
                                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                                break block1;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
            if (dataSources != null) {
                ModelNode operation;
                ModelNode dsAddress;
                for (DataSource dataSource : dataSources.getDataSource()) {
                    dsAddress = address.clone();
                    dsAddress.add("data-source", dataSource.getJndiName());
                    dsAddress.protect();
                    operation = new ModelNode();
                    operation.get("address").set(dsAddress);
                    operation.get("operation").set("add");
                    DataSourceModelNodeUtil.fillFrom(operation, dataSource);
                    list.add(operation);
                }
                for (XaDataSource xaDataSource : dataSources.getXaDataSource()) {
                    dsAddress = address.clone();
                    dsAddress.add("xa-data-source", xaDataSource.getJndiName());
                    dsAddress.protect();
                    operation = new ModelNode();
                    operation.get("address").set(dsAddress);
                    operation.get("operation").set("add");
                    DataSourceModelNodeUtil.fillFrom(operation, xaDataSource);
                    list.add(operation);
                }
                for (Driver driver : dataSources.getDrivers()) {
                    ModelNode driverAddress = address.clone();
                    driverAddress.add("jdbc-driver", driver.getName());
                    driverAddress.protect();
                    ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)driverAddress);
                    op.get("driver-name").set(driver.getName());
                    op.get("driver-module-name").set(driver.getModule());
                    if (driver.getMajorVersion() != null) {
                        op.get("driver-major-version").set(driver.getMajorVersion().intValue());
                    }
                    if (driver.getMinorVersion() != null) {
                        op.get("driver-minor-version").set(driver.getMinorVersion().intValue());
                    }
                    if (driver.getDriverClass() != null) {
                        op.get("driver-class-name").set(driver.getDriverClass());
                    }
                    if (driver.getXaDataSourceClass() != null) {
                        op.get("driver-xa-datasource-class-name").set(driver.getXaDataSourceClass());
                    }
                    list.add(op);
                }
            }
        }
    }
}

