/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.pool.PoolConfigurationRWHandler;
import org.jboss.as.connector.pool.PoolMetrics;
import org.jboss.as.connector.pool.PoolOperations;
import org.jboss.as.connector.subsystems.resourceadapters.Element;
import org.jboss.as.connector.subsystems.resourceadapters.Namespace;
import org.jboss.as.connector.subsystems.resourceadapters.RaAdd;
import org.jboss.as.connector.subsystems.resourceadapters.RaRemove;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubSystemAdd;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemProviders;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapters;
import org.jboss.jca.common.metadata.resourceadapter.ResourceAdapterParser;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class ResourceAdaptersExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.datasources");

    public void initialize(ExtensionContext context) {
        log.debugf("Initializing ResourceAdapters Extension", new Object[0]);
        SubsystemRegistration registration = context.registerSubsystem("resource-adapters");
        registration.registerXMLElementWriter((XMLElementWriter)ResourceAdapterSubsystemParser.INSTANCE);
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel(ResourceAdaptersSubsystemProviders.SUBSYSTEM);
        subsystem.registerOperationHandler("add", (OperationStepHandler)ResourceAdaptersSubSystemAdd.INSTANCE, ResourceAdaptersSubsystemProviders.SUBSYSTEM_ADD_DESC, false);
        subsystem.registerOperationHandler("describe", (OperationStepHandler)ResourceAdaptersSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)ResourceAdaptersSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        ManagementResourceRegistration resourceadapter = subsystem.registerSubModel(PathElement.pathElement((String)"resource-adapter"), ResourceAdaptersSubsystemProviders.RESOURCEADAPTER_DESC);
        resourceadapter.registerOperationHandler("add", (OperationStepHandler)RaAdd.INSTANCE, ResourceAdaptersSubsystemProviders.ADD_RESOURCEADAPTER_DESC, false);
        resourceadapter.registerOperationHandler("remove", (OperationStepHandler)RaRemove.INSTANCE, ResourceAdaptersSubsystemProviders.REMOVE_RESOURCEADAPTER_DESC, false);
        resourceadapter.registerOperationHandler("flush-idle-connection-in-pool", (OperationStepHandler)PoolOperations.FlushIdleConnectionInPool.DS_INSTANCE, ResourceAdaptersSubsystemProviders.FLUSH_IDLE_CONNECTION_DESC, false);
        resourceadapter.registerOperationHandler("flush-all-connection-in-pool", (OperationStepHandler)PoolOperations.FlushAllConnectionInPool.RA_INSTANCE, ResourceAdaptersSubsystemProviders.FLUSH_ALL_CONNECTION_DESC, false);
        resourceadapter.registerOperationHandler("test-connection-in-pool", (OperationStepHandler)PoolOperations.TestConnectionInPool.RA_INSTANCE, ResourceAdaptersSubsystemProviders.TEST_CONNECTION_DESC, false);
        for (String attributeName : PoolMetrics.ATTRIBUTES) {
            resourceadapter.registerMetric(attributeName, (OperationStepHandler)PoolMetrics.RaPoolMetricsHandler.INSTANCE);
        }
        for (String attributeName : PoolConfigurationRWHandler.ATTRIBUTES) {
            resourceadapter.registerReadWriteAttribute(attributeName, (OperationStepHandler)PoolConfigurationRWHandler.PoolConfigurationReadHandler.INSTANCE, (OperationStepHandler)PoolConfigurationRWHandler.RaPoolConfigurationWriteHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)ResourceAdapterSubsystemParser.INSTANCE);
    }

    private static void setStringIfNotNull(ModelNode node, String identifier, String value) {
        if (value != null) {
            node.get(identifier).set(value);
        }
    }

    private static void setExtensionIfNotNull(ModelNode dsModel, String extensionclassname, String extensionProperties, org.jboss.jca.common.api.metadata.common.Extension extension) {
        if (extension != null) {
            ResourceAdaptersExtension.setStringIfNotNull(dsModel, extensionclassname, extension.getClassName());
            if (extension.getConfigPropertiesMap() != null) {
                for (Map.Entry entry : extension.getConfigPropertiesMap().entrySet()) {
                    dsModel.get(new String[]{extensionProperties, (String)entry.getKey()}).set((String)entry.getValue());
                }
            }
        }
    }

    private static void setBooleanIfNotNull(ModelNode node, String identifier, Boolean value) {
        if (value != null) {
            node.get(identifier).set(value.booleanValue());
        }
    }

    private static void setIntegerIfNotNull(ModelNode node, String identifier, Integer value) {
        if (value != null) {
            node.get(identifier).set(value.intValue());
        }
    }

    private static void setLongIfNotNull(ModelNode node, String identifier, Long value) {
        if (value != null) {
            node.get(identifier).set(value.longValue());
        }
    }

    private static class ResourceAdaptersSubsystemDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final ResourceAdaptersSubsystemDescribeHandler INSTANCE = new ResourceAdaptersSubsystemDescribeHandler();

        private ResourceAdaptersSubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode address = new ModelNode();
            address.add("subsystem", "resource-adapters");
            address.protect();
            ModelNode add = new ModelNode();
            add.get("operation").set("add");
            add.get("address").set(address);
            ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
            boolean workaround = true;
            if (workaround && model.hasDefined("resource-adapters")) {
                ModelNode datasources = model.get("resource-adapters");
                add.get("resource-adapters").set(datasources);
            }
            context.getResult().add(add);
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static final class ResourceAdapterSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        static final ResourceAdapterSubsystemParser INSTANCE = new ResourceAdapterSubsystemParser();

        ResourceAdapterSubsystemParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            ModelNode node = context.getModelNode();
            boolean hasChildren = node.hasDefined("resource-adapter") && node.get("resource-adapter").asInt() > 0;
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), !hasChildren);
            if (hasChildren) {
                writer.writeStartElement(Element.RESOURCE_ADAPTERS.getLocalName());
                for (Property property : node.get("resource-adapter").asPropertyList()) {
                    ModelNode ra = property.getValue();
                    this.writeRaElement(writer, ra);
                }
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }

        private void writeRaElement(XMLExtendedStreamWriter streamWriter, ModelNode ra) throws XMLStreamException {
            streamWriter.writeStartElement(ResourceAdapters.Tag.RESOURCE_ADPTER.getLocalName());
            this.writeElementIfHas(streamWriter, ra, ResourceAdapter.Tag.ARCHIVE, "archive");
            if (ra.has("beanvalidationgroups")) {
                for (ModelNode bvg : ra.get("beanvalidationgroups").asList()) {
                    this.writeElementIfHas(streamWriter, bvg, ResourceAdapter.Tag.BEAN_VALIDATION_GROUP, "beanvalidationgroups");
                }
            }
            this.writeElementIfHas(streamWriter, ra, ResourceAdapter.Tag.BOOTSTRAP_CONTEXT, "bootstrapcontext");
            this.writeElementIfHas(streamWriter, ra, ResourceAdapter.Tag.TRANSACTION_SUPPORT, "transaction-support");
            this.writeConfigProperties(streamWriter, ra);
            if (ra.has("connection-definitions")) {
                streamWriter.writeStartElement(ResourceAdapter.Tag.CONNECTION_DEFINITIONS.getLocalName());
                for (ModelNode conDef : ra.get("connection-definitions").asList()) {
                    this.writeConDef(streamWriter, conDef);
                }
                streamWriter.writeEndElement();
            }
            if (ra.has("admin-objects")) {
                streamWriter.writeStartElement(ResourceAdapter.Tag.ADMIN_OBJECTS.getLocalName());
                for (ModelNode adminObject : ra.get("admin-objects").asList()) {
                    this.writeAdminObject(streamWriter, adminObject);
                }
                streamWriter.writeEndElement();
            }
            streamWriter.writeEndElement();
        }

        private void writeConfigProperties(XMLExtendedStreamWriter streamWriter, ModelNode ra) throws XMLStreamException {
            if (ra.has("config-properties")) {
                for (ModelNode property : ra.get("config-properties").asList()) {
                    streamWriter.writeStartElement(ResourceAdapter.Tag.CONFIG_PROPERTY.getLocalName());
                    streamWriter.writeCharacters(property.asString());
                    streamWriter.writeEndElement();
                }
            }
        }

        private void writeAdminObject(XMLExtendedStreamWriter streamWriter, ModelNode adminObject) throws XMLStreamException {
            streamWriter.writeStartElement(ResourceAdapter.Tag.ADMIN_OBJECT.getLocalName());
            this.writeAttributeIfHas(streamWriter, adminObject, CommonAdminObject.Attribute.CLASS_NAME, "class-name");
            this.writeAttributeIfHas(streamWriter, adminObject, CommonAdminObject.Attribute.JNDINAME, "jndi-name");
            this.writeAttributeIfHas(streamWriter, adminObject, CommonAdminObject.Attribute.ENABLED, "enabled");
            this.writeAttributeIfHas(streamWriter, adminObject, CommonAdminObject.Attribute.USEJAVACONTEXT, "use-java-context");
            this.writeAttributeIfHas(streamWriter, adminObject, CommonAdminObject.Attribute.POOL_NAME, "pool-name");
            this.writeConfigProperties(streamWriter, adminObject);
            streamWriter.writeEndElement();
        }

        private void writeConDef(XMLExtendedStreamWriter streamWriter, ModelNode conDef) throws XMLStreamException {
            streamWriter.writeStartElement(ResourceAdapter.Tag.CONNECTION_DEFINITION.getLocalName());
            this.writeAttributeIfHas(streamWriter, conDef, CommonConnDef.Attribute.CLASS_NAME, "class-name");
            this.writeAttributeIfHas(streamWriter, conDef, CommonConnDef.Attribute.JNDINAME, "jndi-name");
            this.writeAttributeIfHas(streamWriter, conDef, CommonConnDef.Attribute.ENABLED, "enabled");
            this.writeAttributeIfHas(streamWriter, conDef, CommonConnDef.Attribute.USEJAVACONTEXT, "use-java-context");
            this.writeAttributeIfHas(streamWriter, conDef, CommonConnDef.Attribute.POOL_NAME, "pool-name");
            this.writeAttributeIfHas(streamWriter, conDef, CommonConnDef.Attribute.USECCM, "use-ccm");
            this.writeConfigProperties(streamWriter, conDef);
            if (conDef.has("max-pool-size") || conDef.has("min-pool-size") || conDef.has("pool-use-strict-min") || conDef.has("pool-prefill")) {
                if (conDef.has("interliving") || conDef.has("wrap-xa-datasource") || conDef.has("no-tx-separate-pool") || conDef.has("pad-xid") || conDef.has("same-rm-override")) {
                    streamWriter.writeStartElement(CommonConnDef.Tag.XA_POOL.getLocalName());
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.MIN_POOL_SIZE, "min-pool-size");
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.MAXPOOLSIZE, "max-pool-size");
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.PREFILL, "pool-prefill");
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.FLUSH_STRATEGY, "flush-strategy");
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.USE_STRICT_MIN, "pool-use-strict-min");
                    this.writeElementIfHas(streamWriter, conDef, CommonXaPool.Tag.ISSAMERMOVERRIDEVALUE, "same-rm-override");
                    this.writeElementIfHas(streamWriter, conDef, CommonXaPool.Tag.INTERLEAVING, "interliving");
                    this.writeElementIfHas(streamWriter, conDef, CommonXaPool.Tag.NO_TX_SEPARATE_POOLS, "no-tx-separate-pool");
                    this.writeElementIfHas(streamWriter, conDef, CommonXaPool.Tag.PAD_XID, "pad-xid");
                    this.writeElementIfHas(streamWriter, conDef, CommonXaPool.Tag.WRAP_XA_RESOURCE, "wrap-xa-datasource");
                    streamWriter.writeEndElement();
                } else {
                    streamWriter.writeStartElement(CommonConnDef.Tag.POOL.getLocalName());
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.MIN_POOL_SIZE, "min-pool-size");
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.MAXPOOLSIZE, "max-pool-size");
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.PREFILL, "pool-prefill");
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.USE_STRICT_MIN, "pool-use-strict-min");
                    streamWriter.writeEndElement();
                }
            }
            if (conDef.hasDefined("security-application") || conDef.hasDefined("security-domain") || conDef.hasDefined("security-domain-and-application")) {
                streamWriter.writeStartElement(CommonConnDef.Tag.SECURITY.getLocalName());
                this.writeElementIfHas(streamWriter, conDef, CommonSecurity.Tag.APPLICATION, "security-application");
                this.writeElementIfHas(streamWriter, conDef, CommonSecurity.Tag.SECURITY_DOMAIN, "security-domain");
                this.writeElementIfHas(streamWriter, conDef, CommonSecurity.Tag.SECURITY_DOMAIN_AND_APPLICATION, "security-domain-and-application");
                streamWriter.writeEndElement();
            }
            if (conDef.has("blocking-timeout-wait-millis") || conDef.has("idle-timeout-minutes") || conDef.has("allocation-retry") || conDef.has("allocation-retry-wait-millis") || conDef.has("xa-resource-timeout")) {
                streamWriter.writeStartElement(CommonConnDef.Tag.TIMEOUT.getLocalName());
                this.writeElementIfHas(streamWriter, conDef, CommonTimeOut.Tag.BLOCKINGTIMEOUTMILLIS, "blocking-timeout-wait-millis");
                this.writeElementIfHas(streamWriter, conDef, CommonTimeOut.Tag.IDLETIMEOUTMINUTES, "idle-timeout-minutes");
                this.writeElementIfHas(streamWriter, conDef, CommonTimeOut.Tag.ALLOCATIONRETRY, "allocation-retry");
                this.writeElementIfHas(streamWriter, conDef, CommonTimeOut.Tag.ALLOCATIONRETRYWAITMILLIS, "allocation-retry-wait-millis");
                this.writeElementIfHas(streamWriter, conDef, CommonTimeOut.Tag.XARESOURCETIMEOUT, "xa-resource-timeout");
                streamWriter.writeEndElement();
            }
            if (conDef.has("background-validation") || conDef.has("background-validation-minutes") || conDef.has("use-fast-fail")) {
                streamWriter.writeStartElement(CommonConnDef.Tag.VALIDATION.getLocalName());
                this.writeElementIfHas(streamWriter, conDef, CommonValidation.Tag.BACKGROUNDVALIDATION, "background-validation");
                this.writeElementIfHas(streamWriter, conDef, CommonValidation.Tag.BACKGROUNDVALIDATIONMINUTES, "background-validation-minutes");
                this.writeElementIfHas(streamWriter, conDef, CommonValidation.Tag.USEFASTFAIL, "use-fast-fail");
                streamWriter.writeEndElement();
            }
            if (conDef.hasDefined("recovery-username") || conDef.hasDefined("recovery-password") || conDef.hasDefined("recovery-security-domain") || conDef.hasDefined("recovery-plugin-properties") || conDef.hasDefined("recovery-plugin-properties") || conDef.hasDefined("no-recovery")) {
                streamWriter.writeStartElement(CommonConnDef.Tag.RECOVERY.getLocalName());
                if (conDef.hasDefined("recovery-username") || conDef.hasDefined("recovery-password") || conDef.hasDefined("recovery-security-domain")) {
                    streamWriter.writeStartElement(Recovery.Tag.RECOVER_CREDENTIAL.getLocalName());
                    this.writeElementIfHas(streamWriter, conDef, Credential.Tag.USERNAME.getLocalName(), "recovery-username");
                    this.writeElementIfHas(streamWriter, conDef, Credential.Tag.PASSWORD.getLocalName(), "recovery-password");
                    this.writeElementIfHas(streamWriter, conDef, Credential.Tag.SECURITY_DOMAIN.getLocalName(), "recovery-security-domain");
                    streamWriter.writeEndElement();
                }
                if (conDef.hasDefined("recovery-plugin-properties") || conDef.hasDefined("recovery-plugin-properties")) {
                    streamWriter.writeStartElement(Recovery.Tag.RECOVER_PLUGIN.getLocalName());
                    this.writeAttributeIfHas(streamWriter, conDef, Extension.Attribute.CLASS_NAME.getLocalName(), "recovery-plugin-properties");
                    if (conDef.hasDefined("recovery-plugin-properties")) {
                        for (ModelNode property : conDef.get("recovery-plugin-properties").asList()) {
                            streamWriter.writeStartElement(Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            streamWriter.writeCharacters(property.asString());
                            streamWriter.writeEndElement();
                        }
                    }
                    streamWriter.writeEndElement();
                }
                this.writeAttributeIfHas(streamWriter, conDef, Recovery.Attribute.NO_RECOVERY.getLocalName(), "no-recovery");
            }
            streamWriter.writeEndElement();
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, String localName, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeStartElement(localName);
                writer.writeCharacters(node.get(identifier).asString());
                writer.writeEndElement();
            }
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, ResourceAdapter.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonPool.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonXaPool.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonSecurity.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonTimeOut.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonValidation.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonAdminObject.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, String attrName, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attrName, node.get(identifier).asString());
            }
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonConnDef.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode address = new ModelNode();
            address.add("subsystem", "resource-adapters");
            address.protect();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address);
            list.add(subsystem);
            ResourceAdapters ras = null;
            try {
                String localName = null;
                block1 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case RESOURCEADAPTERS_1_0: {
                        localName = reader.getLocalName();
                        Element element = Element.forName(reader.getLocalName());
                        log.tracef("%s -> %s", (Object)localName, (Object)element);
                        switch (element) {
                            case SUBSYSTEM: {
                                ResourceAdapterParser parser = new ResourceAdapterParser();
                                ras = parser.parse((XMLStreamReader)reader);
                                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                                break block1;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
            if (ras != null && ras.getResourceAdapters() != null) {
                for (ResourceAdapter ra : ras.getResourceAdapters()) {
                    ModelNode raAddress = address.clone();
                    raAddress.add("resource-adapter", ra.getArchive());
                    raAddress.protect();
                    ModelNode operation = new ModelNode();
                    operation.get("address").set(raAddress);
                    operation.get("operation").set("add");
                    if (ra.getConfigProperties() != null) {
                        for (Map.Entry entry : ra.getConfigProperties().entrySet()) {
                            operation.get(new String[]{"config-properties", (String)entry.getKey()}).set((String)entry.getValue());
                        }
                    }
                    ResourceAdaptersExtension.setStringIfNotNull(operation, "archive", ra.getArchive());
                    ResourceAdaptersExtension.setStringIfNotNull(operation, "transaction-support", ra.getTransactionSupport() != null ? ra.getTransactionSupport().name() : null);
                    ResourceAdaptersExtension.setStringIfNotNull(operation, "bootstrapcontext", ra.getBootstrapContext());
                    if (ra.getBeanValidationGroups() != null) {
                        for (String beanValidationGroup : ra.getBeanValidationGroups()) {
                            operation.get("beanvalidationgroups").add(beanValidationGroup);
                        }
                    }
                    if (ra.getConnectionDefinitions() != null) {
                        for (CommonConnDef conDef : ra.getConnectionDefinitions()) {
                            operation.get("connection-definitions").add(this.createConnectionDefinitionModel(conDef));
                        }
                    }
                    if (ra.getAdminObjects() != null) {
                        for (CommonAdminObject adminObject : ra.getAdminObjects()) {
                            operation.get("admin-objects").add(this.createAdminObjectModel(adminObject));
                        }
                    }
                    list.add(operation);
                }
            }
        }

        private ModelNode createAdminObjectModel(CommonAdminObject adminObject) {
            ModelNode adminObjectModel = new ModelNode();
            for (Map.Entry entry : adminObject.getConfigProperties().entrySet()) {
                adminObjectModel.get(new String[]{"config-properties", (String)entry.getKey()}).set((String)entry.getValue());
            }
            ResourceAdaptersExtension.setStringIfNotNull(adminObjectModel, "class-name", adminObject.getClassName());
            ResourceAdaptersExtension.setStringIfNotNull(adminObjectModel, "jndi-name", adminObject.getJndiName());
            ResourceAdaptersExtension.setStringIfNotNull(adminObjectModel, "pool-name", adminObject.getPoolName());
            ResourceAdaptersExtension.setBooleanIfNotNull(adminObjectModel, "enabled", adminObject.isEnabled());
            ResourceAdaptersExtension.setBooleanIfNotNull(adminObjectModel, "use-java-context", adminObject.isUseJavaContext());
            return adminObjectModel;
        }

        private ModelNode createConnectionDefinitionModel(CommonConnDef conDef) {
            ModelNode condefModel = new ModelNode();
            for (Map.Entry entry : conDef.getConfigProperties().entrySet()) {
                condefModel.get(new String[]{"config-properties", (String)entry.getKey()}).set((String)entry.getValue());
            }
            ResourceAdaptersExtension.setStringIfNotNull(condefModel, "class-name", conDef.getClassName());
            ResourceAdaptersExtension.setStringIfNotNull(condefModel, "jndi-name", conDef.getJndiName());
            ResourceAdaptersExtension.setStringIfNotNull(condefModel, "pool-name", conDef.getPoolName());
            ResourceAdaptersExtension.setBooleanIfNotNull(condefModel, "enabled", conDef.isEnabled() != null ? conDef.isEnabled() : true);
            ResourceAdaptersExtension.setBooleanIfNotNull(condefModel, "use-java-context", conDef.isUseJavaContext() != null ? conDef.isUseJavaContext() : true);
            ResourceAdaptersExtension.setBooleanIfNotNull(condefModel, "use-ccm", conDef.isUseCcm());
            if (conDef.getPool() != null) {
                ResourceAdaptersExtension.setIntegerIfNotNull(condefModel, "max-pool-size", conDef.getPool().getMaxPoolSize());
                ResourceAdaptersExtension.setIntegerIfNotNull(condefModel, "min-pool-size", conDef.getPool().getMinPoolSize());
                ResourceAdaptersExtension.setBooleanIfNotNull(condefModel, "pool-prefill", conDef.getPool().isPrefill());
                ResourceAdaptersExtension.setBooleanIfNotNull(condefModel, "pool-use-strict-min", conDef.getPool().isUseStrictMin());
                if (conDef.getPool().getFlushStrategy() != null) {
                    ResourceAdaptersExtension.setStringIfNotNull(condefModel, "flush-strategy", conDef.getPool().getFlushStrategy().name());
                }
                if (conDef.isXa().booleanValue()) {
                    CommonXaPool xaPool = (CommonXaPool)conDef.getPool();
                    ResourceAdaptersExtension.setBooleanIfNotNull(condefModel, "interliving", xaPool.isInterleaving());
                    ResourceAdaptersExtension.setBooleanIfNotNull(condefModel, "pad-xid", xaPool.isPadXid());
                    ResourceAdaptersExtension.setBooleanIfNotNull(condefModel, "same-rm-override", xaPool.isSameRmOverride());
                    ResourceAdaptersExtension.setBooleanIfNotNull(condefModel, "no-tx-separate-pool", xaPool.isNoTxSeparatePool());
                    ResourceAdaptersExtension.setBooleanIfNotNull(condefModel, "wrap-xa-datasource", xaPool.isWrapXaDataSource());
                }
            }
            if (conDef.getTimeOut() != null) {
                ResourceAdaptersExtension.setIntegerIfNotNull(condefModel, "allocation-retry", conDef.getTimeOut().getAllocationRetry());
                ResourceAdaptersExtension.setLongIfNotNull(condefModel, "allocation-retry-wait-millis", conDef.getTimeOut().getAllocationRetryWaitMillis());
                ResourceAdaptersExtension.setLongIfNotNull(condefModel, "blocking-timeout-wait-millis", conDef.getTimeOut().getBlockingTimeoutMillis());
                ResourceAdaptersExtension.setLongIfNotNull(condefModel, "idle-timeout-minutes", conDef.getTimeOut().getIdleTimeoutMinutes());
                ResourceAdaptersExtension.setIntegerIfNotNull(condefModel, "xa-resource-timeout", conDef.getTimeOut().getXaResourceTimeout());
            }
            if (conDef.getSecurity() != null) {
                ResourceAdaptersExtension.setBooleanIfNotNull(condefModel, "security-application", conDef.getSecurity().isApplication());
                ResourceAdaptersExtension.setStringIfNotNull(condefModel, "security-domain", conDef.getSecurity().getSecurityDomain());
                ResourceAdaptersExtension.setStringIfNotNull(condefModel, "security-domain-and-application", conDef.getSecurity().getSecurityDomainAndApplication());
            }
            if (conDef.getValidation() != null) {
                ResourceAdaptersExtension.setLongIfNotNull(condefModel, "background-validation-minutes", conDef.getValidation().getBackgroundValidationMinutes());
                ResourceAdaptersExtension.setBooleanIfNotNull(condefModel, "background-validation", conDef.getValidation().isBackgroundValidation());
                ResourceAdaptersExtension.setBooleanIfNotNull(condefModel, "use-fast-fail", conDef.getValidation().isUseFastFail());
            }
            if (conDef.getRecovery() != null) {
                Recovery recovery = conDef.getRecovery();
                ResourceAdaptersExtension.setStringIfNotNull(condefModel, "recovery-username", recovery.getCredential() != null ? recovery.getCredential().getUserName() : null);
                ResourceAdaptersExtension.setStringIfNotNull(condefModel, "recovery-password", recovery.getCredential() != null ? recovery.getCredential().getPassword() : null);
                ResourceAdaptersExtension.setStringIfNotNull(condefModel, "recovery-security-domain", recovery.getCredential() != null ? recovery.getCredential().getSecurityDomain() : null);
                ResourceAdaptersExtension.setExtensionIfNotNull(condefModel, "recovery-plugin-properties", "recovery-plugin-properties", recovery.getRecoverPlugin());
                ResourceAdaptersExtension.setBooleanIfNotNull(condefModel, "no-recovery", recovery.getNoRecovery());
            }
            return condefModel;
        }
    }
}

