/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.workmanager;

import java.util.concurrent.Executor;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.security.UsersRoles;
import org.jboss.jca.core.spi.security.Callback;
import org.jboss.jca.core.spi.transaction.xa.XATerminator;
import org.jboss.jca.core.tx.jbossts.XATerminatorImpl;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.BlockingExecutor;
import org.jboss.tm.JBossXATerminator;

public final class WorkManagerService
implements Service<WorkManager> {
    private final WorkManager value;
    private final InjectedValue<Executor> executorShort = new InjectedValue();
    private final InjectedValue<Executor> executorLong = new InjectedValue();
    private final InjectedValue<JBossXATerminator> xaTerminator = new InjectedValue();
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.connector");
    private UsersRoles usersRoles;

    public WorkManagerService(WorkManager value) {
        log.debugf("Building WorkManager", new Object[0]);
        this.value = value;
    }

    public WorkManager getValue() throws IllegalStateException {
        return ConnectorServices.notNull(this.value);
    }

    public void start(StartContext context) throws StartException {
        this.value.setLongRunningThreadPool((BlockingExecutor)this.executorLong.getValue());
        this.value.setShortRunningThreadPool((BlockingExecutor)this.executorShort.getValue());
        this.value.setXATerminator((XATerminator)new XATerminatorImpl((JBossXATerminator)this.xaTerminator.getValue()));
        String usersProperties = System.getProperty("users.properties");
        String rolesProperties = System.getProperty("roles.properties");
        if (usersProperties != null && rolesProperties != null) {
            try {
                this.usersRoles = new UsersRoles();
                this.usersRoles.setUsersProperties(usersProperties);
                this.usersRoles.setRolesProperties(rolesProperties);
                this.usersRoles.start();
                this.value.setCallbackSecurity((Callback)this.usersRoles);
            }
            catch (Throwable t) {
                log.debug((Object)t.getMessage(), t);
            }
        }
        log.debugf("Starting JCA WorkManager", new Object[0]);
    }

    public void stop(StopContext context) {
        try {
            if (this.usersRoles != null) {
                this.usersRoles.stop();
            }
        }
        catch (Throwable t) {
            log.debug((Object)t.getMessage(), t);
        }
    }

    public Injector<Executor> getExecutorShortInjector() {
        return this.executorShort;
    }

    public Injector<Executor> getExecutorLongInjector() {
        return this.executorLong;
    }

    public Injector<JBossXATerminator> getXaTerminatorInjector() {
        return this.xaTerminator;
    }
}

