/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.sql.Driver;
import java.util.List;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.registry.DriverRegistry;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SubjectFactory;

public abstract class AbstractDataSourceAdd
extends AbstractAddStepHandler {
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> controllers) throws OperationFailedException {
        ModelNode address = operation.require("address");
        String dsName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        String jndiName = operation.hasDefined(Constants.JNDINAME.getName()) ? operation.get(Constants.JNDINAME.getName()).asString() : dsName;
        ServiceTarget serviceTarget = context.getServiceTarget();
        boolean enabled = false;
        ModelNode node = operation.require(Constants.DATASOURCE_DRIVER.getName());
        AbstractDataSourceService dataSourceService = this.createDataSourceService(dsName);
        ServiceName dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{dsName});
        ServiceBuilder dataSourceServiceBuilder = serviceTarget.addService(dataSourceServiceName, (Service)dataSourceService).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, dataSourceService.getTransactionIntegrationInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE, ManagementRepository.class, dataSourceService.getmanagementRepositoryInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, dataSourceService.getSubjectFactoryInjector()).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, dataSourceService.getDriverRegistryInjector()).addDependency(NamingService.SERVICE_NAME);
        this.startConfigAndAddDependency(dataSourceServiceBuilder, dataSourceService, dsName, serviceTarget, operation, verificationHandler);
        String driverName = node.asString();
        ServiceName driverServiceName = ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName.replaceAll("\\.", "_")});
        if (driverServiceName != null) {
            dataSourceServiceBuilder.addDependency(driverServiceName, Driver.class, dataSourceService.getDriverInjector());
        }
        dataSourceServiceBuilder.setInitialMode(ServiceController.Mode.NEVER);
        controllers.add(dataSourceServiceBuilder.install());
    }

    static String cleanupJavaContext(String jndiName) {
        String bindName = jndiName.startsWith("java:/") ? jndiName.substring(6) : (jndiName.startsWith("java:") ? jndiName.substring(5) : jndiName);
        return bindName;
    }

    protected abstract void startConfigAndAddDependency(ServiceBuilder<?> var1, AbstractDataSourceService var2, String var3, ServiceTarget var4, ModelNode var5, ServiceVerificationHandler var6) throws OperationFailedException;

    protected abstract void populateModel(ModelNode var1, ModelNode var2) throws OperationFailedException;

    protected abstract AbstractDataSourceService createDataSourceService(String var1) throws OperationFailedException;

    static void populateAddModel(ModelNode operation, ModelNode modelNode, String connectionPropertiesProp, SimpleAttributeDefinition[] attributes) throws OperationFailedException {
        if (operation.hasDefined(connectionPropertiesProp)) {
            for (Property property : operation.get(connectionPropertiesProp).asPropertyList()) {
                modelNode.get(new String[]{connectionPropertiesProp, property.getName()}).set(property.getValue().asString());
            }
        }
        for (SimpleAttributeDefinition attribute : attributes) {
            attribute.validateAndSet(operation, modelNode);
        }
    }
}

