/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.util.ParserException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.CommonLogger;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public abstract class AbstractParser {
    private static CommonLogger log = (CommonLogger)Logger.getMessageLogger(CommonLogger.class, (String)AbstractParser.class.getName());
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    public String rawElementText(XMLStreamReader reader) throws XMLStreamException {
        String elementtext = reader.getElementText();
        elementtext = elementtext == null || elementtext.trim().length() == 0 ? null : elementtext.trim();
        return elementtext;
    }

    public String rawAttributeText(XMLStreamReader reader, String attributeName) {
        String attributeString = reader.getAttributeValue("", attributeName) == null ? null : reader.getAttributeValue("", attributeName).trim();
        return attributeString;
    }

    protected void parseExtension(XMLExtendedStreamReader reader, String enclosingTag, ModelNode operation, SimpleAttributeDefinition extensionclassname, SimpleAttributeDefinition extensionProperties) throws XMLStreamException, ParserException, ValidateException {
        Object className = null;
        Object properties = null;
        block10: for (Extension.Attribute attribute : Extension.Attribute.values()) {
            switch (attribute) {
                case CLASS_NAME: {
                    Location location = reader.getLocation();
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
                    String value = reader.getAttributeValue(0);
                    extensionclassname.parseAndSetParameter(value, operation, location);
                    continue block10;
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 2: {
                    if (reader.getLocalName().equals(enclosingTag)) {
                        return;
                    }
                    if (Extension.Tag.forName((String)reader.getLocalName()) != Extension.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Extension.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            Location location = reader.getLocation();
                            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
                            String name = reader.getAttributeValue(0);
                            String value = this.rawElementText((XMLStreamReader)reader);
                            ModelNode node = extensionProperties.parse(value, location);
                            operation.get(new String[]{extensionProperties.getName(), name}).set(node);
                            break block3;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private static class SecurityActions {
        private SecurityActions() {
        }

        static String getSystemProperty(final String name) {
            if (System.getSecurityManager() == null) {
                return System.getProperty(name);
            }
            return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty(name);
                }
            });
        }
    }
}

