/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;

public class StatisticsDescriptionProvider
implements DescriptionProvider {
    private final String bundleName;
    private final String resourceDescriptionKey;
    private final List<StatisticsPlugin> plugins;

    public StatisticsDescriptionProvider(StatisticsPlugin ... plugins) {
        this((String)null, (String)null, plugins);
    }

    public StatisticsDescriptionProvider(String bundleName, String resourceDescriptionKey, StatisticsPlugin ... plugins) {
        this.bundleName = bundleName;
        this.resourceDescriptionKey = resourceDescriptionKey;
        this.plugins = Arrays.asList(plugins);
    }

    public ModelNode getModelDescription(Locale locale) {
        ResourceBundle bundle2 = this.getResourceBundle(locale);
        ModelNode subsystem = new ModelNode();
        subsystem.get("description").set(bundle2.getString(this.resourceDescriptionKey));
        ModelNode attrs = subsystem.get("attributes");
        Map<String, ModelNode> attributeDescriptions = this.getAttributeOverrideDescriptions(locale);
        for (Map.Entry<String, ModelNode> entry : attributeDescriptions.entrySet()) {
            attrs.get(entry.getKey()).set(entry.getValue());
        }
        subsystem.get("operations");
        subsystem.get("children").setEmptyObject();
        return subsystem;
    }

    public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
        HashMap<String, ModelNode> attributes = new HashMap<String, ModelNode>();
        for (StatisticsPlugin plugin : this.plugins) {
            for (String name : plugin.getNames()) {
                ModelNode node = new ModelNode();
                node.get("description").set(plugin.getDescription(name));
                ModelType modelType = ModelType.STRING;
                if (plugin.getType(name) == Integer.TYPE) {
                    modelType = ModelType.INT;
                }
                if (plugin.getType(name) == Long.TYPE) {
                    modelType = ModelType.LONG;
                }
                node.get("type").set(modelType);
                node.get("required").set(false);
                node.get("read-only").set(true);
                attributes.put(name, node);
            }
        }
        return attributes;
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(this.bundleName, locale);
    }
}

