/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.jca.Attribute;
import org.jboss.as.connector.subsystems.jca.Element;
import org.jboss.as.connector.subsystems.jca.JcaArchiveValidationDefinition;
import org.jboss.as.connector.subsystems.jca.JcaBeanValidationDefinition;
import org.jboss.as.connector.subsystems.jca.JcaBootstrapContextDefinition;
import org.jboss.as.connector.subsystems.jca.JcaCachedConnectionManagerDefinition;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemRootDefinition;
import org.jboss.as.connector.subsystems.jca.JcaWorkManagerDefinition;
import org.jboss.as.connector.subsystems.jca.Namespace;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.threads.ThreadsParser;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JcaExtension
implements Extension {
    public static String SUBSYSTEM_NAME = "jca";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    private static final String RESOURCE_NAME = JcaExtension.class.getPackage().getName() + ".LocalDescriptions";

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, JcaExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        ConnectorLogger.ROOT_LOGGER.debugf("Initializing Connector Extension", new Object[0]);
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        subsystem.registerSubsystemModel((ResourceDefinition)JcaSubsystemRootDefinition.createInstance(registerRuntimeOnly));
        subsystem.registerXMLElementWriter((XMLElementWriter)ConnectorSubsystemParser.INSTANCE);
        if (context.isRegisterTransformers()) {
            JcaSubsystemRootDefinition.registerTransformers(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JCA_1_0.getUriString(), (XMLElementReader)ConnectorSubsystemParser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JCA_1_1.getUriString(), (XMLElementReader)ConnectorSubsystemParser.INSTANCE);
    }

    static final class ConnectorSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        static final ConnectorSubsystemParser INSTANCE = new ConnectorSubsystemParser();

        ConnectorSubsystemParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode node = context.getModelNode();
            this.writeArchiveValidation(writer, node);
            this.writeBeanValidation(writer, node);
            this.writeWorkManagers(writer, node);
            this.writeBootstrapContexts(writer, node);
            this.writeCachedConnectionManager(writer, node);
            writer.writeEndElement();
        }

        private void writeArchiveValidation(XMLExtendedStreamWriter writer, ModelNode parentNode) throws XMLStreamException {
            if (parentNode.hasDefined("archive-validation")) {
                ModelNode node = parentNode.get("archive-validation").get("archive-validation");
                if (JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_ENABLED.getAttribute().isMarshallable(node) || JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_ERROR.getAttribute().isMarshallable(node) || JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_WARN.getAttribute().isMarshallable(node)) {
                    writer.writeEmptyElement(Element.ARCHIVE_VALIDATION.getLocalName());
                    JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_ENABLED.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                    JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_ERROR.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                    JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_WARN.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                }
            }
        }

        private void writeBeanValidation(XMLExtendedStreamWriter writer, ModelNode parentNode) throws XMLStreamException {
            if (parentNode.hasDefined("bean-validation")) {
                ModelNode node = parentNode.get("bean-validation").get("bean-validation");
                if (JcaBeanValidationDefinition.BeanValidationParameters.BEAN_VALIDATION_ENABLED.getAttribute().isMarshallable(node)) {
                    writer.writeEmptyElement(Element.BEAN_VALIDATION.getLocalName());
                    JcaBeanValidationDefinition.BeanValidationParameters.BEAN_VALIDATION_ENABLED.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                }
            }
        }

        private void writeCachedConnectionManager(XMLExtendedStreamWriter writer, ModelNode parentNode) throws XMLStreamException {
            String name;
            ModelNode node;
            if (parentNode.hasDefined("cached-connection-manager") && (node = parentNode.get("cached-connection-manager").get("cached-connection-manager")).hasDefined(name = JcaCachedConnectionManagerDefinition.CcmParameters.INSTALL.getAttribute().getName()) && node.get(name).asBoolean()) {
                writer.writeEmptyElement(Element.CACHED_CONNECTION_MANAGER.getLocalName());
                JcaCachedConnectionManagerDefinition.CcmParameters.DEBUG.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                JcaCachedConnectionManagerDefinition.CcmParameters.ERROR.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
            }
        }

        private void writeWorkManagers(XMLExtendedStreamWriter writer, ModelNode parentNode) throws XMLStreamException {
            if (parentNode.hasDefined("workmanager") && parentNode.get("workmanager").asList().size() != 0) {
                for (Property property : parentNode.get("workmanager").asPropertyList()) {
                    if ("default".equals(property.getValue().get("name").asString())) {
                        writer.writeStartElement(Element.DEFAULT_WORKMANAGER.getLocalName());
                    } else {
                        writer.writeStartElement(Element.WORKMANAGER.getLocalName());
                        JcaWorkManagerDefinition.WmParameters.NAME.getAttribute().marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                    }
                    for (Property prop : property.getValue().asPropertyList()) {
                        if ("long-running-threads".equals(prop.getName()) && prop.getValue().isDefined() && prop.getValue().asPropertyList().size() != 0) {
                            ThreadsParser.getInstance().writeBoundedQueueThreadPool(writer, prop.getValue().asProperty(), Element.LONG_RUNNING_THREADS.getLocalName(), false);
                        }
                        if (!"short-running-threads".equals(prop.getName()) || !prop.getValue().isDefined() || prop.getValue().asPropertyList().size() == 0) continue;
                        ThreadsParser.getInstance().writeBoundedQueueThreadPool(writer, prop.getValue().asProperty(), Element.SHORT_RUNNING_THREADS.getLocalName(), false);
                    }
                    writer.writeEndElement();
                }
            }
        }

        private void writeBootstrapContexts(XMLExtendedStreamWriter writer, ModelNode parentNode) throws XMLStreamException {
            if (parentNode.hasDefined("bootstrap-context") && parentNode.get("bootstrap-context").asList().size() != 0) {
                boolean started = false;
                for (Property property : parentNode.get("bootstrap-context").asPropertyList()) {
                    if (property.getValue().get(JcaBootstrapContextDefinition.BootstrapCtxParameters.NAME.getAttribute().getName()).asString().equals("default") || !JcaBootstrapContextDefinition.BootstrapCtxParameters.NAME.getAttribute().isMarshallable(property.getValue()) && !JcaBootstrapContextDefinition.BootstrapCtxParameters.WORKMANAGER.getAttribute().isMarshallable(property.getValue())) continue;
                    if (!started) {
                        writer.writeStartElement(Element.BOOTSTRAP_CONTEXTS.getLocalName());
                        started = true;
                    }
                    writer.writeStartElement(Element.BOOTSTRAP_CONTEXT.getLocalName());
                    JcaBootstrapContextDefinition.BootstrapCtxParameters.NAME.getAttribute().marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                    JcaBootstrapContextDefinition.BootstrapCtxParameters.WORKMANAGER.getAttribute().marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                if (started) {
                    writer.writeEndElement();
                }
            }
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode address = new ModelNode();
            address.add("subsystem", "jca");
            address.protect();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address);
            list.add(subsystem);
            EnumSet<Element> visited = EnumSet.noneOf(Element.class);
            EnumSet<Element> requiredElement = EnumSet.of(Element.DEFAULT_WORKMANAGER);
            boolean ccmAdded = false;
            block11: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case JCA_1_1: 
                    case JCA_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (!visited.add(element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        switch (element) {
                            case ARCHIVE_VALIDATION: {
                                list.add(this.parseArchiveValidation(reader, address));
                                continue block11;
                            }
                            case BEAN_VALIDATION: {
                                list.add(this.parseBeanValidation(reader, address));
                                continue block11;
                            }
                            case DEFAULT_WORKMANAGER: {
                                this.parseWorkManager(reader, address, list, subsystem, true);
                                ModelNode bootstrapContextOperation = new ModelNode();
                                bootstrapContextOperation.get("operation").set("add");
                                ModelNode bootStrapCOntextAddress = address.clone();
                                bootStrapCOntextAddress.add("bootstrap-context", "default");
                                bootStrapCOntextAddress.protect();
                                bootstrapContextOperation.get("address").set(bootStrapCOntextAddress);
                                bootstrapContextOperation.get("workmanager").set("default");
                                bootstrapContextOperation.get("name").set("default");
                                list.add(bootstrapContextOperation);
                                requiredElement.remove((Object)Element.DEFAULT_WORKMANAGER);
                                continue block11;
                            }
                            case CACHED_CONNECTION_MANAGER: {
                                list.add(this.parseCcm(reader, address));
                                ccmAdded = true;
                                continue block11;
                            }
                            case WORKMANAGER: {
                                this.parseWorkManager(reader, address, list, subsystem, false);
                                visited.remove((Object)Element.WORKMANAGER);
                                continue block11;
                            }
                            case BOOTSTRAP_CONTEXTS: {
                                this.parseBootstrapContexts(reader, address, list);
                                continue block11;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (!requiredElement.isEmpty()) {
                throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, requiredElement);
            }
            if (!ccmAdded) {
                ModelNode ccmOperation = new ModelNode();
                ccmOperation.get("operation").set("add");
                ModelNode ccmAddress = address.clone();
                ccmAddress.add("cached-connection-manager", "cached-connection-manager");
                ccmAddress.protect();
                ccmOperation.get("address").set(ccmAddress);
                list.add(ccmOperation);
            }
        }

        private ModelNode parseArchiveValidation(XMLExtendedStreamReader reader, ModelNode parentOperation) throws XMLStreamException {
            ModelNode archiveValidationOperation = new ModelNode();
            archiveValidationOperation.get("operation").set("add");
            ModelNode archiveValidationAddress = parentOperation.clone();
            archiveValidationAddress.add("archive-validation", "archive-validation");
            archiveValidationAddress.protect();
            archiveValidationOperation.get("address").set(archiveValidationAddress);
            int cnt = reader.getAttributeCount();
            block5: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case ENABLED: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_ENABLED.getAttribute().getXmlName());
                        JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_ENABLED.getAttribute().parseAndSetParameter(value, archiveValidationOperation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case FAIL_ON_ERROR: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_ERROR.getAttribute().getXmlName());
                        JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_ERROR.getAttribute().parseAndSetParameter(value, archiveValidationOperation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case FAIL_ON_WARN: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_WARN.getAttribute().getXmlName());
                        JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_WARN.getAttribute().parseAndSetParameter(value, archiveValidationOperation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return archiveValidationOperation;
        }

        private void parseWorkManager(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list, ModelNode node, boolean defaultWm) throws XMLStreamException {
            ModelNode workManagerOperation = new ModelNode();
            workManagerOperation.get("operation").set("add");
            int cnt = reader.getAttributeCount();
            String name = null;
            block13: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = this.rawAttributeText((XMLStreamReader)reader, JcaWorkManagerDefinition.WmParameters.NAME.getAttribute().getXmlName());
                        JcaWorkManagerDefinition.WmParameters.NAME.getAttribute().parseAndSetParameter(name, workManagerOperation, (XMLStreamReader)reader);
                        continue block13;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                if (defaultWm) {
                    name = "default";
                    workManagerOperation.get("name").set(name);
                } else {
                    throw new XMLStreamException("name attribute is mandatory for workmanager element");
                }
            }
            ModelNode workManagerAddress = parentAddress.clone();
            workManagerAddress.add("workmanager", name);
            workManagerAddress.protect();
            workManagerOperation.get("address").set(workManagerAddress);
            list.add(workManagerOperation);
            block14: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                Namespace readerNS = Namespace.forUri(reader.getNamespaceURI());
                switch (element) {
                    case LONG_RUNNING_THREADS: {
                        org.jboss.as.threads.Namespace ns;
                        switch (readerNS) {
                            case JCA_1_0: {
                                ns = org.jboss.as.threads.Namespace.THREADS_1_0;
                                ThreadsParser.getInstance().parseBlockingBoundedQueueThreadPool(reader, readerNS.getUriString(), ns, workManagerAddress, list, "long-running-threads", name);
                                continue block14;
                            }
                        }
                        ns = org.jboss.as.threads.Namespace.THREADS_1_1;
                        ThreadsParser.getInstance().parseBlockingBoundedQueueThreadPool(reader, readerNS.getUriString(), ns, workManagerAddress, list, "long-running-threads", name);
                        continue block14;
                    }
                    case SHORT_RUNNING_THREADS: {
                        org.jboss.as.threads.Namespace ns;
                        switch (readerNS) {
                            case JCA_1_0: {
                                ns = org.jboss.as.threads.Namespace.THREADS_1_0;
                                ThreadsParser.getInstance().parseBlockingBoundedQueueThreadPool(reader, readerNS.getUriString(), ns, workManagerAddress, list, "short-running-threads", name);
                                continue block14;
                            }
                        }
                        ns = org.jboss.as.threads.Namespace.THREADS_1_1;
                        ThreadsParser.getInstance().parseBlockingBoundedQueueThreadPool(reader, readerNS.getUriString(), ns, workManagerAddress, list, "short-running-threads", name);
                        continue block14;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        private ModelNode parseBeanValidation(XMLExtendedStreamReader reader, ModelNode parentOperation) throws XMLStreamException {
            ModelNode beanValidationOperation = new ModelNode();
            beanValidationOperation.get("operation").set("add");
            ModelNode beanValidationAddress = parentOperation.clone();
            beanValidationAddress.add("bean-validation", "bean-validation");
            beanValidationAddress.protect();
            beanValidationOperation.get("address").set(beanValidationAddress);
            int cnt = reader.getAttributeCount();
            block3: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case ENABLED: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, JcaBeanValidationDefinition.BeanValidationParameters.BEAN_VALIDATION_ENABLED.getAttribute().getXmlName());
                        JcaBeanValidationDefinition.BeanValidationParameters.BEAN_VALIDATION_ENABLED.getAttribute().parseAndSetParameter(value, beanValidationOperation, (XMLStreamReader)reader);
                        continue block3;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return beanValidationOperation;
        }

        private ModelNode parseCcm(XMLExtendedStreamReader reader, ModelNode parentOperation) throws XMLStreamException {
            ModelNode ccmOperation = new ModelNode();
            ccmOperation.get("operation").set("add");
            ModelNode ccmAddress = parentOperation.clone();
            ccmAddress.add("cached-connection-manager", "cached-connection-manager");
            ccmAddress.protect();
            ccmOperation.get("address").set(ccmAddress);
            int cnt = reader.getAttributeCount();
            block4: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case DEBUG: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, JcaCachedConnectionManagerDefinition.CcmParameters.DEBUG.getAttribute().getXmlName());
                        JcaCachedConnectionManagerDefinition.CcmParameters.DEBUG.getAttribute().parseAndSetParameter(value, ccmOperation, (XMLStreamReader)reader);
                        continue block4;
                    }
                    case ERROR: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, JcaCachedConnectionManagerDefinition.CcmParameters.ERROR.getAttribute().getXmlName());
                        JcaCachedConnectionManagerDefinition.CcmParameters.ERROR.getAttribute().parseAndSetParameter(value, ccmOperation, (XMLStreamReader)reader);
                        continue block4;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ccmOperation.get(JcaCachedConnectionManagerDefinition.CcmParameters.INSTALL.getAttribute().getName()).set(true);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return ccmOperation;
        }

        private void parseBootstrapContexts(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
            block7: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case BOOTSTRAP_CONTEXT: {
                        ModelNode bootstrapContextOperation = new ModelNode();
                        bootstrapContextOperation.get("operation").set("add");
                        int cnt = reader.getAttributeCount();
                        String name = null;
                        String wmName = null;
                        block8: for (int i = 0; i < cnt; ++i) {
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case NAME: {
                                    name = this.rawAttributeText((XMLStreamReader)reader, JcaBootstrapContextDefinition.BootstrapCtxParameters.NAME.getAttribute().getXmlName());
                                    JcaBootstrapContextDefinition.BootstrapCtxParameters.NAME.getAttribute().parseAndSetParameter(name, bootstrapContextOperation, (XMLStreamReader)reader);
                                    continue block8;
                                }
                                case WORKMANAGER: {
                                    wmName = this.rawAttributeText((XMLStreamReader)reader, JcaBootstrapContextDefinition.BootstrapCtxParameters.WORKMANAGER.getAttribute().getXmlName());
                                    JcaBootstrapContextDefinition.BootstrapCtxParameters.WORKMANAGER.getAttribute().parseAndSetParameter(wmName, bootstrapContextOperation, (XMLStreamReader)reader);
                                    continue block8;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        if (name == null) {
                            if ("default".equals(wmName)) {
                                name = "default";
                            } else {
                                throw new XMLStreamException("name attribute is mandatory for workmanager element");
                            }
                        }
                        ModelNode bootstrapContextAddress = parentAddress.clone();
                        bootstrapContextAddress.add("bootstrap-context", name);
                        bootstrapContextAddress.protect();
                        bootstrapContextOperation.get("address").set(bootstrapContextAddress);
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                        list.add(bootstrapContextOperation);
                        continue block7;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        public String rawAttributeText(XMLStreamReader reader, String attributeName) {
            String attributeString = reader.getAttributeValue("", attributeName) == null ? null : reader.getAttributeValue("", attributeName).trim();
            return attributeString;
        }
    }
}

