/*
 * JBoss, Home of Professional Open Source
 * Copyright <YEAR> Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @author tags. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */

package org.jboss.as.console.client.shared;

import com.google.gwt.core.client.JavaScriptObject;

/**
 * @author Heiko Braun
 * @date 3/16/11
 */
public class JSONUtil {

     public static native JavaScriptObject parseJson(String jsonStr) /*-{
	  return eval('(' + jsonStr + ')');
	}-*/;

    public static native String pretty(JavaScriptObject obj, String indent)/*-{

        var result = "";
        if (indent == null) indent = "";

        for (var property in obj)
        {
            var value = obj[property];
            if (typeof value == 'string')
                value = "'" + value + "'";
            else if (typeof value == 'object')
            {
                if (value instanceof Array)
                {
                    // Just let JS convert the Array to a string!
                    value = "[ " + value + " ]";
                }
                else
                {
                    // Recursive dump
                    // (replace "  " by "\t" or something else if you prefer)
                    var od = @org.jboss.as.console.client.shared.JSONUtil::pretty(Lcom/google/gwt/core/client/JavaScriptObject;Ljava/lang/String;)(value, indent + "\t");
                    // If you like { on the same line as the key
                    //value = "{\n" + od + "\n" + indent + "}";
                    // If you prefer { and } to be aligned
                    value = "\n" + indent + "{\n" + od + "\n" + indent + "}";
                }
            }
            result += indent + "'" + property + "' : " + value + ",\n";
        }
        return result.replace(/,\n$/, "");

    }-*/;
}
