/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @author tags. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.mbui.gui.reification;

import java.util.EnumMap;
import java.util.Map;

/**
 * @author Harald Pehl
 * @date 10/25/2012
 */
public class Context
{
    private final Map<ContextKey, Object> data;

    public Context()
    {
        this.data = new EnumMap<ContextKey, Object>(ContextKey.class);
    }

    public <T> Context set(final ContextKey key, final T value)
    {
        data.put(key, value);
        return this;
    }

    public <T> T get(final ContextKey name)
    {
        Object value = data.get(name);
        assert value != null : "Context key " + name + " expected";
        return (T) value;
    }

    public boolean has(final ContextKey name)
    {
        Object value = data.get(name);
        return value != null;
    }

    @Override
    public String toString()
    {
        return "Context " + data;
    }
}
