/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.client.ControllerClientMessages;
import org.jboss.as.controller.client.Operation;
import org.jboss.dmr.ModelNode;

class OperationImpl
implements Operation {
    private final ModelNode operation;
    private final List<InputStream> inputStreams;

    OperationImpl(ModelNode operation, List<InputStream> inputStreams) {
        this.operation = operation;
        this.inputStreams = inputStreams;
    }

    @Override
    public ModelNode getOperation() {
        return this.operation;
    }

    @Override
    public List<InputStream> getInputStreams() {
        if (this.inputStreams == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.inputStreams);
    }

    @Override
    public Operation clone() {
        ArrayList<InputStream> streamsCopy = this.inputStreams == null ? null : new ArrayList<InputStream>(this.inputStreams);
        return new OperationImpl(this.operation.clone(), streamsCopy);
    }

    @Override
    public Operation clone(ModelNode operation) {
        if (operation == null) {
            throw ControllerClientMessages.MESSAGES.nullVar("operation");
        }
        ArrayList<InputStream> streamsCopy = this.inputStreams == null ? null : new ArrayList<InputStream>(this.inputStreams);
        return new OperationImpl(operation, streamsCopy);
    }
}

