/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.StartException;

public interface ResultHandler {
    public static final String[] EMPTY_LOCATION = new String[0];

    public void handleResultFragment(String[] var1, ModelNode var2);

    public void handleResultComplete();

    public void handleFailed(ModelNode var1);

    public void handleCancellation();

    public static class ServiceStartListener
    extends AbstractServiceListener<Object> {
        private final ResultHandler resultHandler;

        public ServiceStartListener(ResultHandler resultHandler) {
            this.resultHandler = resultHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceStarted(ServiceController<?> controller) {
            try {
                this.resultHandler.handleResultComplete();
            }
            finally {
                controller.removeListener((ServiceListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceFailed(ServiceController<?> controller, StartException reason) {
            try {
                this.resultHandler.handleFailed(new ModelNode().set(reason.getLocalizedMessage()));
            }
            finally {
                controller.removeListener((ServiceListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceRemoved(ServiceController<?> controller) {
            try {
                this.resultHandler.handleCancellation();
            }
            finally {
                controller.removeListener((ServiceListener)this);
            }
        }
    }

    public static class ServiceRemoveListener
    extends AbstractServiceListener<Object> {
        private final ResultHandler resultHandler;

        public ServiceRemoveListener(ResultHandler resultHandler) {
            this.resultHandler = resultHandler;
        }

        public void listenerAdded(ServiceController<?> controller) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }

        public void serviceRemoved(ServiceController<?> controller) {
            this.resultHandler.handleResultComplete();
        }
    }
}

