/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;

public abstract class AbstractSocketBindingGroupAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    private final ParametersValidator validator;

    protected AbstractSocketBindingGroupAddHandler(ParametersValidator validator) {
        this.validator = new ParametersValidator(validator);
        this.validator.registerValidator("default-interface", new StringLengthValidator(1, Integer.MAX_VALUE, true, true));
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        this.validator.validate(operation);
        PathAddress address = PathAddress.pathAddress(operation.require("address"));
        String name = address.getLastElement().getValue();
        ModelNode model = context.getSubModel();
        model.get("name").set(name);
        ModelNode compensating = Util.getResourceRemoveOperation(operation.get("address"));
        model.get("default-interface").set(operation.get("default-interface"));
        this.populateModel(model, operation);
        model.get("socket-binding");
        return this.installSocketBindingGroup(name, operation, context, resultHandler, compensating);
    }

    protected abstract void populateModel(ModelNode var1, ModelNode var2);

    protected OperationResult installSocketBindingGroup(String name, ModelNode operation, OperationContext context, ResultHandler resultHandler, ModelNode compensatingOp) throws OperationFailedException {
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensatingOp);
    }
}

