/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.SocketBindingGroupDescription;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.InetAddressValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SocketBindingAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    public static final SocketBindingAddHandler INSTANCE = new SocketBindingAddHandler();
    private final ParametersValidator validator = new ParametersValidator();

    public static ModelNode getOperation(ModelNode address, ModelNode socketBinding) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        if (socketBinding.get("interface").isDefined()) {
            op.get("interface").set(socketBinding.get("interface"));
        }
        op.get("port").set(socketBinding.get("port"));
        if (socketBinding.get("fixed-port").isDefined()) {
            op.get("fixed-port").set(socketBinding.get("fixed-port"));
        }
        if (socketBinding.get("multicast-address").isDefined()) {
            op.get("multicast-address").set(socketBinding.get("multicast-address"));
        }
        if (socketBinding.get("multicast-port").isDefined()) {
            op.get("multicast-port").set(socketBinding.get("multicast-port"));
        }
        return op;
    }

    protected SocketBindingAddHandler() {
        this.validator.registerValidator("interface", new StringLengthValidator(1, Integer.MAX_VALUE, true, true));
        this.validator.registerValidator("port", new IntRangeValidator(0, 65535, false, true));
        this.validator.registerValidator("fixed-port", new ModelTypeValidator(ModelType.BOOLEAN, true, true));
        this.validator.registerValidator("multicast-address", new InetAddressValidator(true, true));
        this.validator.registerValidator("multicast-port", new IntRangeValidator(0, 65535, true, true));
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        this.validator.validate(operation);
        PathAddress address = PathAddress.pathAddress(operation.require("address"));
        String name = address.getLastElement().getValue();
        ModelNode model = context.getSubModel();
        model.get("name").set(name);
        model.get("interface").set(operation.get("interface"));
        model.get("port").set(operation.get("port"));
        model.get("fixed-port").set(operation.get("fixed-port"));
        model.get("multicast-address").set(operation.get("multicast-address"));
        model.get("multicast-port").set(operation.get("multicast-port"));
        ModelNode compensating = Util.getResourceRemoveOperation(operation.get("address"));
        return this.installSocketBinding(name, operation, context, resultHandler, compensating);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return SocketBindingGroupDescription.getSocketBindingAddOperation(locale);
    }

    protected OperationResult installSocketBinding(String name, ModelNode operation, OperationContext context, ResultHandler resultHandler, ModelNode compensatingOp) throws OperationFailedException {
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensatingOp);
    }
}

