/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions.common;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CommonDescriptions {
    private static final String RESOURCE_NAME = CommonDescriptions.class.getPackage().getName() + ".LocalDescriptions";
    public static final String READ_CONFIG_AS_XML = "read-config-as-xml";

    public static ModelNode getNamespacePrefixAttribute(Locale locale) {
        ResourceBundle bundle = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("type").set(ModelType.OBJECT);
        root.get("value-type").set(ModelType.STRING);
        root.get("description").set(bundle.getString("namespaces"));
        root.get("required").set(false);
        root.get("head-comment-allowed").set(false);
        root.get("tail-comment-allowed").set(false);
        return root;
    }

    public static ModelNode getSchemaLocationAttribute(Locale locale) {
        ResourceBundle bundle = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("type").set(ModelType.OBJECT);
        root.get("value-type").set(ModelType.STRING);
        root.get("description").set(bundle.getString("schema-locations"));
        root.get("required").set(false);
        root.get("head-comment-allowed").set(false);
        root.get("tail-comment-allowed").set(false);
        return root;
    }

    public static ModelNode getAddNamespaceOperation(Locale locale) {
        ResourceBundle bundle = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add-namespace");
        root.get("description").set(bundle.getString("namespaces.add"));
        root.get(new String[]{"request-properties", "namespace", "type"}).set(ModelType.PROPERTY);
        root.get(new String[]{"request-properties", "namespace", "value-type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "namespace", "description"}).set(bundle.getString("namespaces.add.namespace"));
        root.get(new String[]{"request-properties", "namespace", "required"}).set(true);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getRemoveNamespaceOperation(Locale locale) {
        ResourceBundle bundle = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove-namespace");
        root.get("description").set(bundle.getString("namespaces.remove"));
        root.get(new String[]{"request-properties", "namespace", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "namespace", "description"}).set(bundle.getString("namespaces.remove.namespace"));
        root.get(new String[]{"request-properties", "namespace", "required"}).set(true);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getAddSchemaLocationOperation(Locale locale) {
        ResourceBundle bundle = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add-schema-location");
        root.get("description").set(bundle.getString("schema-locations.add"));
        root.get(new String[]{"request-properties", "schema-location", "type"}).set(ModelType.PROPERTY);
        root.get(new String[]{"request-properties", "schema-location", "value-type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "schema-location", "description"}).set(bundle.getString("schema-locations.add.schema-location"));
        root.get(new String[]{"request-properties", "schema-location", "required"}).set(true);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getRemoveSchemaLocationOperation(Locale locale) {
        ResourceBundle bundle = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove-schema-location");
        root.get("description").set(bundle.getString("schema-locations.remove"));
        root.get(new String[]{"request-properties", "schema-location", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "schema-location", "description"}).set(bundle.getString("schema-locations.remove.schema-location"));
        root.get(new String[]{"request-properties", "schema-location", "required"}).set(true);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getSystemPropertiesAttribute(Locale locale) {
        ResourceBundle bundle = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("type").set(ModelType.OBJECT);
        root.get("value-type").set(ModelType.STRING);
        root.get("description").set(bundle.getString("system-properties"));
        root.get("required").set(false);
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(true);
        return root;
    }

    public static ModelNode getAddSystemPropertyOperation(Locale locale) {
        ResourceBundle bundle = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add-system-property");
        root.get("description").set(bundle.getString("system-properties.add"));
        root.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("system-properties.add.name"));
        root.get(new String[]{"request-properties", "name", "required"}).set(true);
        root.get(new String[]{"request-properties", "name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "name", "nillable"}).set(false);
        root.get(new String[]{"request-properties", "value", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "value", "description"}).set(bundle.getString("system-properties.add.value"));
        root.get(new String[]{"request-properties", "value", "required"}).set(false);
        root.get(new String[]{"request-properties", "value", "nillable"}).set(true);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getRemoveSystemPropertyOperation(Locale locale) {
        ResourceBundle bundle = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove-system-property");
        root.get("description").set(bundle.getString("system-properties.remove"));
        root.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("system-properties.remove.name"));
        root.get(new String[]{"request-properties", "name", "required"}).set(true);
        root.get(new String[]{"request-properties", "name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "name", "nillable"}).set(false);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getReadConfigAsXmlOperation(Locale locale) {
        ResourceBundle bundle = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set(READ_CONFIG_AS_XML);
        root.get("description").set(bundle.getString(READ_CONFIG_AS_XML));
        root.get("request-properties").setEmptyObject();
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        root.get(new String[]{"reply-properties", "description"}).set(bundle.getString("read-config-as-xml.response"));
        return root;
    }

    public static ModelNode getSubsystemDescribeOperation(Locale locale) {
        ResourceBundle bundle = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add");
        root.get("description").set(bundle.getString("subsystem.describe"));
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        root.get(new String[]{"reply-properties", "value-type"}).set(ModelType.OBJECT);
        return root;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    public static void main(String[] args) {
        System.out.println(CommonDescriptions.getSchemaLocationAttribute(null));
        System.out.println(CommonDescriptions.getNamespacePrefixAttribute(null));
        System.out.println(CommonDescriptions.getAddNamespaceOperation(null));
        System.out.println(CommonDescriptions.getRemoveNamespaceOperation(null));
        System.out.println(CommonDescriptions.getAddSchemaLocationOperation(null));
        System.out.println(CommonDescriptions.getRemoveSchemaLocationOperation(null));
        System.out.println(CommonDescriptions.getSystemPropertiesAttribute(null));
        System.out.println(CommonDescriptions.getAddSystemPropertyOperation(null));
        System.out.println(CommonDescriptions.getRemoveSystemPropertyOperation(null));
        System.out.println(CommonDescriptions.getReadConfigAsXmlOperation(null));
    }
}

