/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions.common;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.common.InterfaceDescription;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public final class JVMDescriptions {
    private static final String RESOURCE_NAME = InterfaceDescription.class.getPackage().getName() + ".LocalDescriptions";

    public static ModelNode getJVMDescription(Locale locale) {
        ResourceBundle bundle = JVMDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("jvm"));
        node.get(new String[]{"attributes", "agent-lib", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "agent-lib", "description"}).set(bundle.getString("jvm.agent.lib"));
        node.get(new String[]{"attributes", "agent-path", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "agent-path", "description"}).set(bundle.getString("jvm.agent.path"));
        node.get(new String[]{"attributes", "debug-enabled", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"attributes", "debug-enabled", "description"}).set(bundle.getString("jvm.debug.enabled"));
        node.get(new String[]{"attributes", "debug-options", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "debug-options", "description"}).set(bundle.getString("jvm.debug.options"));
        node.get(new String[]{"attributes", "env-classpath-ignored", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"attributes", "env-classpath-ignored", "description"}).set(bundle.getString("jvm.env.classpath.ignored"));
        node.get(new String[]{"attributes", "environment-variables", "type"}).set(ModelType.LIST);
        node.get(new String[]{"attributes", "environment-variables", "value-type"}).set(ModelType.PROPERTY);
        node.get(new String[]{"attributes", "environment-variables", "description"}).set(bundle.getString("jvm.env.variables"));
        node.get(new String[]{"attributes", "javaagent", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "javaagent", "description"}).set(bundle.getString("jvm.javaagent"));
        node.get(new String[]{"attributes", "java-home", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "java-home", "description"}).set(bundle.getString("jvm.java.home"));
        node.get(new String[]{"attributes", "jvm-options", "type"}).set(ModelType.LIST);
        node.get(new String[]{"attributes", "jvm-options", "value-type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "jvm-options", "description"}).set(bundle.getString("jvm.options"));
        node.get(new String[]{"attributes", "stack-size", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "stack-size", "description"}).set(bundle.getString("jvm.stack"));
        node.get(new String[]{"attributes", "system-properties", "type"}).set(ModelType.LIST);
        node.get(new String[]{"attributes", "system-properties", "value-type"}).set(ModelType.PROPERTY);
        node.get(new String[]{"attributes", "system-properties", "description"}).set(bundle.getString("jvm.system.properties"));
        node.get(new String[]{"attributes", "type", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "type", "description"}).set(bundle.getString("jvm.type"));
        node.get(new String[]{"children", "heap", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"children", "heap", "description"}).set(bundle.getString("jvm.heap"));
        node.get(new String[]{"children", "heap", "attributes", "size"}).set(ModelType.STRING);
        node.get(new String[]{"children", "heap", "attributes", "max-size"}).set(ModelType.STRING);
        node.get(new String[]{"children", "permgen", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"children", "permgen", "description"}).set(bundle.getString("jvm.heap"));
        node.get(new String[]{"children", "permgen", "attributes", "size"}).set(ModelType.STRING);
        node.get(new String[]{"children", "permgen", "attributes", "max-size"}).set(ModelType.STRING);
        return node;
    }

    public static ModelNode getJVMAddDescription(Locale locale) {
        ResourceBundle bundle = JVMDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(bundle.getString("jvm.add"));
        node.get(new String[]{"request-properties", "type", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "type", "description"}).set(bundle.getString("jvm.type"));
        node.get(new String[]{"request-properties", "type", "required"}).set(false);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    public static ModelNode getJVMRemoveDescription(Locale locale) {
        ResourceBundle bundle = JVMDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(bundle.getString("jvm.remove"));
        node.get("request-properties").setEmptyObject();
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    public static ModelNode getOptionAddOperation(Locale locale) {
        ResourceBundle bundle = JVMDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add-jvm-option");
        node.get("description").set(bundle.getString("jvm.option.add"));
        node.get(new String[]{"request-properties", "type", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "type", "description"}).set(bundle.getString("jvm.option"));
        node.get(new String[]{"request-properties", "type", "required"}).set(true);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    public static ModelNode getOptionRemoveOperation(Locale locale) {
        ResourceBundle bundle = JVMDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove-jvm-option");
        node.get("description").set(bundle.getString("jvm.option.remove"));
        node.get(new String[]{"request-properties", "jvm-option", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "jvm-option", "description"}).set(bundle.getString("jvm.option"));
        node.get(new String[]{"request-properties", "jvm-option", "required"}).set(true);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

