/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.SystemPropertyRemoveHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;

public class SystemPropertyAddHandler
implements ModelUpdateOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add-system-property";
    public static final SystemPropertyAddHandler INSTANCE = new SystemPropertyAddHandler();
    private final ParametersValidator validator = new ParametersValidator();

    public static ModelNode getOperation(ModelNode address, String name, String value) {
        ModelNode op = Util.getEmptyOperation(OPERATION_NAME, address);
        if (value == null) {
            op.get(name).set(new ModelNode());
        } else {
            op.get(name).set(value);
        }
        return op;
    }

    protected SystemPropertyAddHandler() {
        this.validator.registerValidator("name", new StringLengthValidator(1));
        this.validator.registerValidator("value", new StringLengthValidator(0, true));
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        this.validator.validate(operation);
        String name = operation.get("name").asString();
        String value = operation.get("value").isDefined() ? operation.get("value").asString() : null;
        ModelNode node = context.getSubModel().get(new String[]{"system-properties", name});
        if (value == null) {
            node.set(new ModelNode());
        } else {
            node.set(value);
        }
        ModelNode compensating = SystemPropertyRemoveHandler.getOperation(operation.get("address"), name);
        return this.updateSystemProperty(name, value, context, resultHandler, compensating);
    }

    protected OperationResult updateSystemProperty(String name, String value, OperationContext context, ResultHandler resultHandler, ModelNode compensating) {
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensating);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getAddSystemPropertyOperation(locale);
    }
}

