/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.XmlConfigurationPersister;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class BackupXmlConfigurationPersister
extends XmlConfigurationPersister {
    public BackupXmlConfigurationPersister(File fileName, QName rootElement, XMLElementReader<List<ModelNode>> rootParser, XMLElementWriter<ModelMarshallingContext> rootDeparser) {
        super(fileName, rootElement, rootParser, rootDeparser);
    }

    @Override
    protected void backup(File fileName) throws ConfigurationPersistenceException {
        File backup = new File(fileName.getParent(), fileName.getName() + ".last-known-good");
        try {
            this.moveFile(fileName, backup);
        }
        catch (IOException e) {
            throw new ConfigurationPersistenceException("Failed to back up " + fileName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveFile(File file, File backup) throws IOException {
        if (backup.exists()) {
            backup.delete();
        }
        if (!file.renameTo(backup) && file.exists()) {
            FileInputStream fis = new FileInputStream(file);
            try {
                FileOutputStream fos = new FileOutputStream(backup);
                try {
                    StreamUtils.copyStream((InputStream)fis, (OutputStream)fos);
                    fos.close();
                }
                finally {
                    StreamUtils.safeClose((Closeable)fos);
                }
            }
            finally {
                StreamUtils.safeClose((Closeable)fis);
            }
        }
    }
}

