/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AbstractNodeRegistration;
import org.jboss.as.controller.registry.AtomicMapFieldUpdater;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ConcreteNodeRegistration;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.ProxyControllerRegistration;

final class NodeSubregistry {
    private final String keyName;
    private final ConcreteNodeRegistration parent;
    private volatile Map<String, AbstractNodeRegistration> childRegistries;
    private static final AtomicMapFieldUpdater<NodeSubregistry, String, AbstractNodeRegistration> childRegistriesUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(NodeSubregistry.class, Map.class, "childRegistries"));

    NodeSubregistry(String keyName, ConcreteNodeRegistration parent) {
        this.keyName = keyName;
        this.parent = parent;
        childRegistriesUpdater.clear(this);
    }

    Set<String> getChildNames() {
        Map<String, AbstractNodeRegistration> snapshot = this.childRegistries;
        if (snapshot == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(snapshot.keySet());
    }

    ModelNodeRegistration register(String elementValue, DescriptionProvider provider) {
        ConcreteNodeRegistration newRegistry = new ConcreteNodeRegistration(elementValue, this, provider);
        this.register(elementValue, newRegistry);
        return newRegistry;
    }

    void register(String elementValue, ModelNodeRegistration subModel) {
        AbstractNodeRegistration appearingRegistry;
        AbstractNodeRegistration newRegistry = null;
        if (subModel instanceof AbstractNodeRegistration) {
            newRegistry = (AbstractNodeRegistration)subModel;
        }
        if ((appearingRegistry = childRegistriesUpdater.putIfAbsent(this, elementValue, newRegistry)) != null) {
            throw new IllegalArgumentException("A node is already registered at '" + this.getLocationString() + elementValue + ")'");
        }
    }

    void registerProxyController(String elementValue, ProxyController proxyController) {
        ProxyControllerRegistration newRegistry = new ProxyControllerRegistration(elementValue, this, proxyController);
        AbstractNodeRegistration appearingRegistry = childRegistriesUpdater.putIfAbsent(this, elementValue, newRegistry);
        if (appearingRegistry != null) {
            throw new IllegalArgumentException("A node is already registered at '" + this.getLocationString() + elementValue + ")'");
        }
    }

    void unregisterProxyController(String elementValue) {
        childRegistriesUpdater.remove(this, elementValue);
    }

    OperationHandler getHandler(ListIterator<PathElement> iterator, String child, String operationName) {
        Map<String, AbstractNodeRegistration> snapshot = childRegistriesUpdater.get(this);
        AbstractNodeRegistration childRegistry = snapshot.get(child);
        if (childRegistry != null) {
            return childRegistry.getHandler(iterator, operationName);
        }
        AbstractNodeRegistration wildcardRegistry = snapshot.get("*");
        if (wildcardRegistry != null) {
            return wildcardRegistry.getHandler(iterator, operationName);
        }
        return null;
    }

    void getHandlers(ListIterator<PathElement> iterator, String child, Map<String, OperationEntry> providers, boolean inherited) {
        Map<String, AbstractNodeRegistration> snapshot = childRegistriesUpdater.get(this);
        AbstractNodeRegistration childRegistry = snapshot.get(child);
        AbstractNodeRegistration wildcardRegistry = snapshot.get("*");
        if (wildcardRegistry == null) {
            if (childRegistry == null) {
                return;
            }
            childRegistry.getOperationDescriptions(iterator, providers, inherited);
            return;
        }
        if (childRegistry == null) {
            wildcardRegistry.getOperationDescriptions(iterator, providers, inherited);
            return;
        }
        wildcardRegistry.getOperationDescriptions(iterator, providers, inherited);
        childRegistry.getOperationDescriptions(iterator, providers, inherited);
    }

    String getLocationString() {
        return this.parent.getLocationString() + "(" + this.keyName + " => ";
    }

    DescriptionProvider getOperationDescription(Iterator<PathElement> iterator, String child, String operationName) {
        Map<String, AbstractNodeRegistration> snapshot = this.childRegistries;
        AbstractNodeRegistration childRegistry = snapshot.get(child);
        if (childRegistry == null && (childRegistry = snapshot.get("*")) == null) {
            return null;
        }
        return childRegistry.getOperationDescription(iterator, operationName);
    }

    DescriptionProvider getModelDescription(Iterator<PathElement> iterator, String child) {
        Map<String, AbstractNodeRegistration> snapshot = this.childRegistries;
        AbstractNodeRegistration childRegistry = snapshot.get(child);
        if (childRegistry == null && (childRegistry = snapshot.get("*")) == null) {
            return null;
        }
        return childRegistry.getModelDescription(iterator);
    }

    Set<String> getChildNames(Iterator<PathElement> iterator, String child) {
        Map<String, AbstractNodeRegistration> snapshot = this.childRegistries;
        AbstractNodeRegistration childRegistry = snapshot.get(child);
        if (childRegistry == null && (childRegistry = snapshot.get("*")) == null) {
            return null;
        }
        return childRegistry.getChildNames(iterator);
    }

    Set<String> getAttributeNames(Iterator<PathElement> iterator, String child) {
        Map<String, AbstractNodeRegistration> snapshot = this.childRegistries;
        AbstractNodeRegistration childRegistry = snapshot.get(child);
        if (childRegistry == null && (childRegistry = snapshot.get("*")) == null) {
            return null;
        }
        return childRegistry.getAttributeNames(iterator);
    }

    AttributeAccess getAttributeAccess(ListIterator<PathElement> iterator, String child, String attributeName) {
        Map<String, AbstractNodeRegistration> snapshot = childRegistriesUpdater.get(this);
        AbstractNodeRegistration childRegistry = snapshot.get(child);
        if (childRegistry != null) {
            return childRegistry.getAttributeAccess(iterator, attributeName);
        }
        AbstractNodeRegistration wildcardRegistry = snapshot.get("*");
        if (wildcardRegistry != null) {
            return wildcardRegistry.getAttributeAccess(iterator, attributeName);
        }
        return null;
    }

    Set<PathElement> getChildAddresses(Iterator<PathElement> iterator, String child) {
        Map<String, AbstractNodeRegistration> snapshot = this.childRegistries;
        AbstractNodeRegistration childRegistry = snapshot.get(child);
        if (childRegistry == null && (childRegistry = snapshot.get("*")) == null) {
            return null;
        }
        return childRegistry.getChildAddresses(iterator);
    }

    ProxyController getProxyController(Iterator<PathElement> iterator, String child) {
        Map<String, AbstractNodeRegistration> snapshot = this.childRegistries;
        AbstractNodeRegistration childRegistry = snapshot.get(child);
        if (childRegistry == null) {
            return null;
        }
        return childRegistry.getProxyController(iterator);
    }

    ModelNodeRegistration getModelNodeRegistration(Iterator<PathElement> iterator, String child) {
        Map<String, AbstractNodeRegistration> snapshot = this.childRegistries;
        AbstractNodeRegistration childRegistry = snapshot.get(child);
        if (childRegistry == null) {
            return null;
        }
        return childRegistry.getNodeRegistration(iterator);
    }

    void getProxyControllers(Iterator<PathElement> iterator, String child, Set<ProxyController> controllers) {
        Map<String, AbstractNodeRegistration> snapshot = this.childRegistries;
        if (child != null) {
            AbstractNodeRegistration childRegistry = snapshot.get(child);
            if (childRegistry == null) {
                return;
            }
            childRegistry.getProxyControllers(iterator, controllers);
        } else {
            for (AbstractNodeRegistration childRegistry : snapshot.values()) {
                childRegistry.getProxyControllers(iterator, controllers);
            }
        }
    }

    void resolveAddress(PathAddress address, PathAddress base, PathElement current, Set<PathAddress> addresses) {
        Map<String, AbstractNodeRegistration> snapshot = this.childRegistries;
        AbstractNodeRegistration childRegistry = snapshot.get(current.getValue());
        if (childRegistry == null) {
            AbstractNodeRegistration wildcardRegistry = snapshot.get("*");
            if (wildcardRegistry == null) {
                return;
            }
            wildcardRegistry.resolveAddress(address, base.append(current), addresses);
        } else {
            childRegistry.resolveAddress(address, base.append(current), addresses);
        }
    }
}

