/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLMapper;

public class XmlConfigurationPersister
extends AbstractConfigurationPersister {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.controller");
    private final File fileName;
    private final QName rootElement;
    private final XMLElementReader<List<ModelNode>> rootParser;

    public XmlConfigurationPersister(File fileName, QName rootElement, XMLElementReader<List<ModelNode>> rootParser, XMLElementWriter<ModelMarshallingContext> rootDeparser) {
        super(rootDeparser);
        this.fileName = fileName;
        this.rootElement = rootElement;
        this.rootParser = rootParser;
    }

    @Override
    public void store(ModelNode model) throws ConfigurationPersistenceException {
        this.store(model, this.fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(ModelNode model, File file) throws ConfigurationPersistenceException {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            try {
                BufferedOutputStream output = new BufferedOutputStream(fos);
                this.marshallAsXml(model, output);
                output.close();
                fos.close();
            }
            finally {
                XmlConfigurationPersister.safeClose(fos);
            }
        }
        catch (Exception e) {
            throw new ConfigurationPersistenceException("Failed to store configuration", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ModelNode> load() throws ConfigurationPersistenceException {
        XMLMapper mapper = XMLMapper.Factory.create();
        mapper.registerRootElement(this.rootElement, this.rootParser);
        ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
        try {
            FileInputStream fis = new FileInputStream(this.fileName);
            try {
                BufferedInputStream input = new BufferedInputStream(fis);
                XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(input);
                mapper.parseDocument(updates, streamReader);
                streamReader.close();
                input.close();
                fis.close();
            }
            finally {
                XmlConfigurationPersister.safeClose(fis);
            }
        }
        catch (Exception e) {
            throw new ConfigurationPersistenceException("Failed to parse configuration", e);
        }
        return updates;
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                log.errorf(t, "Failed to close resource %s", (Object)closeable);
            }
        }
    }

    protected void successfulBoot(File file) throws ConfigurationPersistenceException {
    }

    @Override
    public String snapshot() throws ConfigurationPersistenceException {
        return "";
    }
}

