/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.Cancellable;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.remote.ModelControllerOperationHandler;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementResponse;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class ModelControllerOperationHandlerImpl
extends AbstractMessageHandler
implements ModelControllerOperationHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.server.management");
    private final ModelController modelController;
    private final AtomicInteger currentAsynchronousRequestId = new AtomicInteger();
    private final Map<Integer, Cancellable> asynchOperations = Collections.synchronizedMap(new HashMap());
    private final MessageHandler initiatingHandler;

    protected ModelControllerOperationHandlerImpl(ModelController modelController, MessageHandler initiatingHandler) {
        this.modelController = modelController;
        this.initiatingHandler = initiatingHandler;
    }

    public void handle(Connection connection, InputStream input) throws IOException {
        ProtocolUtils.expectHeader((InputStream)input, (int)2);
        byte commandCode = StreamUtils.readByte((InputStream)input);
        ManagementResponse operation = this.operationFor(commandCode);
        if (operation == null) {
            throw new IOException("Invalid command code " + commandCode + " received from standalone client");
        }
        log.debugf("Received operation [%s]", (Object)operation);
        operation.handle(connection, input);
    }

    public byte getIdentifier() {
        return 1;
    }

    protected ModelController getController() {
        return this.modelController;
    }

    protected MessageHandler getInitiatingHandler() {
        return this.initiatingHandler;
    }

    protected int getNextAsynchronousRequestId() {
        return this.currentAsynchronousRequestId.incrementAndGet();
    }

    protected void addAsynchronousOperation(int id, Cancellable operation) {
        this.asynchOperations.put(id, operation);
    }

    protected Cancellable getAsynchronousOperation(int id) {
        return this.asynchOperations.get(id);
    }

    protected void clearAsynchronousOperation(int id) {
        this.asynchOperations.remove(id);
    }

    public ManagementResponse operationFor(byte commandByte) {
        switch (commandByte) {
            case 69: {
                return new ExecuteAsynchronousOperation();
            }
            case 71: {
                return new ExecuteSynchronousOperation();
            }
            case 73: {
                return new CancelAsynchronousOperation();
            }
        }
        return null;
    }

    private ModelNode readNode(InputStream in) throws IOException {
        ModelNode node = new ModelNode();
        node.readExternal(in);
        return node;
    }

    private final class IOExceptionHolder {
        IOException exception;

        private IOExceptionHolder() {
        }

        public IOException getException() {
            return this.exception;
        }

        public void setException(IOException exception) {
            this.exception = exception;
        }
    }

    private final class FailureHolder {
        ModelNode failure;

        private FailureHolder() {
        }

        public ModelNode getFailure() {
            ModelNode failure = this.failure;
            if (failure == null) {
                return new ModelNode();
            }
            return failure;
        }

        public void setFailure(ModelNode failure) {
            this.failure = failure;
        }
    }

    private class CancelAsynchronousOperation
    extends ManagementResponse {
        private boolean cancelled;

        private CancelAsynchronousOperation() {
        }

        protected final byte getResponseCode() {
            return 80;
        }

        protected final void readRequest(InputStream inputStream) throws IOException {
            ProtocolUtils.expectHeader((InputStream)inputStream, (int)102);
            int operationId = StreamUtils.readInt((InputStream)inputStream);
            Cancellable operation = ModelControllerOperationHandlerImpl.this.getAsynchronousOperation(operationId);
            this.cancelled = operation != null && operation.cancel();
        }

        protected void sendResponse(OutputStream outputStream) throws IOException {
            StreamUtils.writeBoolean((OutputStream)outputStream, (boolean)this.cancelled);
        }
    }

    private class ExecuteAsynchronousOperation
    extends ExecuteOperation {
        final int asynchronousRequestId;

        private ExecuteAsynchronousOperation() {
            this.asynchronousRequestId = ModelControllerOperationHandlerImpl.this.getNextAsynchronousRequestId();
        }

        protected final byte getResponseCode() {
            return 70;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendResponse(final OutputStream outputStream) throws IOException {
            final CountDownLatch completeLatch = new CountDownLatch(1);
            final IOExceptionHolder exceptionHolder = new IOExceptionHolder();
            final FailureHolder failureHolder = new FailureHolder();
            final AtomicInteger status = new AtomicInteger(0);
            OperationResult result = ModelControllerOperationHandlerImpl.this.modelController.execute(this.builder.build(), new ResultHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleResultFragment(String[] location, ModelNode fragment) {
                    try {
                        OutputStream outputStream2 = outputStream;
                        synchronized (outputStream2) {
                            outputStream.write(99);
                            outputStream.write(98);
                            StreamUtils.writeInt((OutputStream)outputStream, (int)location.length);
                            for (String loc : location) {
                                StreamUtils.writeUTFZBytes((OutputStream)outputStream, (String)loc);
                            }
                            outputStream.write(96);
                            fragment.writeExternal(outputStream);
                            outputStream.flush();
                        }
                    }
                    catch (IOException e) {
                        ModelControllerOperationHandlerImpl.this.clearAsynchronousOperation(ExecuteAsynchronousOperation.this.asynchronousRequestId);
                        exceptionHolder.setException(e);
                        completeLatch.countDown();
                    }
                }

                @Override
                public void handleResultComplete() {
                    ModelControllerOperationHandlerImpl.this.clearAsynchronousOperation(ExecuteAsynchronousOperation.this.asynchronousRequestId);
                    if (!status.compareAndSet(0, 1)) {
                        throw new RuntimeException("Result already set");
                    }
                    completeLatch.countDown();
                }

                @Override
                public void handleFailed(ModelNode failureDescription) {
                    ModelControllerOperationHandlerImpl.this.clearAsynchronousOperation(ExecuteAsynchronousOperation.this.asynchronousRequestId);
                    if (!status.compareAndSet(0, 2)) {
                        throw new RuntimeException("Result already set");
                    }
                    failureHolder.setFailure(failureDescription);
                    completeLatch.countDown();
                }

                @Override
                public void handleCancellation() {
                    ModelControllerOperationHandlerImpl.this.clearAsynchronousOperation(ExecuteAsynchronousOperation.this.asynchronousRequestId);
                    if (!status.compareAndSet(0, 3)) {
                        throw new RuntimeException("Result already set");
                    }
                    completeLatch.countDown();
                }
            });
            ModelNode compensating = result.getCompensatingOperation() != null ? result.getCompensatingOperation() : new ModelNode();
            OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                outputStream.write(96);
                compensating.writeExternal(outputStream);
                outputStream.flush();
            }
            if (completeLatch.getCount() != 0L) {
                ModelControllerOperationHandlerImpl.this.addAsynchronousOperation(this.asynchronousRequestId, result.getCancellable());
                outputStream2 = outputStream;
                synchronized (outputStream2) {
                    outputStream.write(102);
                    StreamUtils.writeInt((OutputStream)outputStream, (int)this.asynchronousRequestId);
                    outputStream.flush();
                }
                while (true) {
                    try {
                        completeLatch.await();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
            if (exceptionHolder.getException() != null) {
                throw exceptionHolder.getException();
            }
            switch (status.get()) {
                case 1: {
                    outputStream2 = outputStream;
                    synchronized (outputStream2) {
                        outputStream.write(100);
                        outputStream.flush();
                        break;
                    }
                }
                case 2: {
                    outputStream2 = outputStream;
                    synchronized (outputStream2) {
                        outputStream.write(103);
                        failureHolder.getFailure().writeExternal(outputStream);
                        outputStream.flush();
                        break;
                    }
                }
                case 3: {
                    outputStream2 = outputStream;
                    synchronized (outputStream2) {
                        outputStream.write(101);
                        outputStream.flush();
                        break;
                    }
                }
                default: {
                    throw new IOException("Unknown status type " + status.get());
                }
            }
        }
    }

    private class ExecuteSynchronousOperation
    extends ExecuteOperation {
        private ExecuteSynchronousOperation() {
        }

        protected final byte getResponseCode() {
            return 72;
        }

        protected void sendResponse(OutputStream outputStream) throws IOException {
            ModelNode result = ModelControllerOperationHandlerImpl.this.modelController.execute(this.builder.build());
            outputStream.write(96);
            result.writeExternal(outputStream);
        }
    }

    private abstract class ExecuteOperation
    extends ManagementResponse {
        OperationBuilder builder;

        ExecuteOperation() {
            super(ModelControllerOperationHandlerImpl.this.getInitiatingHandler());
        }

        protected void readRequest(InputStream inputStream) throws IOException {
            ProtocolUtils.expectHeader((InputStream)inputStream, (int)96);
            this.builder = OperationBuilder.Factory.create((ModelNode)ModelControllerOperationHandlerImpl.this.readNode(inputStream));
            int cmd = inputStream.read();
            if (cmd == 105) {
                return;
            }
            if (cmd != 104) {
                throw new IllegalArgumentException("Expected 104 received " + cmd);
            }
            while (cmd == 104) {
                int length = StreamUtils.readInt((InputStream)inputStream);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                for (int i = 0; i < length; ++i) {
                    int b = inputStream.read();
                    if (b == -1) {
                        throw new IllegalArgumentException("Unexpected end of file");
                    }
                    bout.write(b);
                }
                this.builder.addInputStream((InputStream)new ByteArrayInputStream(bout.toByteArray()));
                cmd = inputStream.read();
            }
            if (cmd != 105) {
                throw new IllegalArgumentException("Expected 105 received " + cmd);
            }
        }
    }
}

