/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ResourceBundle;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class ListAttributeDefinition
extends AttributeDefinition {
    private final ParameterValidator elementValidator;

    public ListAttributeDefinition(String name, boolean allowNull, ParameterValidator elementValidator) {
        this(name, name, allowNull, 0, Integer.MAX_VALUE, elementValidator);
    }

    public ListAttributeDefinition(String name, String xmlName, boolean allowNull, int minSize, int maxSize, ParameterValidator elementValidator) {
        super(name, xmlName, null, ModelType.LIST, allowNull, false, MeasurementUnit.NONE, new ListValidator(elementValidator, allowNull, minSize, maxSize));
        this.elementValidator = elementValidator;
    }

    public ModelNode parse(String value, Location location) throws XMLStreamException {
        String trimmed = value == null ? null : value.trim();
        ModelNode node = trimmed != null ? new ModelNode().set(trimmed) : new ModelNode();
        try {
            this.elementValidator.validateParameter(this.getXmlName(), node);
        }
        catch (OperationFailedException e) {
            throw new XMLStreamException(e.getFailureDescription().toString(), location);
        }
        return node;
    }

    public void parseAndAddParameterElement(String value, ModelNode operation, Location location) throws XMLStreamException {
        ModelNode paramVal = this.parse(value, location);
        operation.get(this.getName()).add(paramVal);
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle, String prefix, ModelNode resourceDescription) {
        ModelNode result = super.addResourceAttributeDescription(bundle, prefix, resourceDescription);
        this.addValueTypeDescription(result);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ResourceBundle bundle, String prefix, ModelNode operationDescription) {
        ModelNode result = super.addOperationParameterDescription(bundle, prefix, operationDescription);
        this.addValueTypeDescription(result);
        return result;
    }

    protected abstract void addValueTypeDescription(ModelNode var1);
}

