/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions.common;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ProfileDescription {
    private static final String RESOURCE_NAME = ProfileDescription.class.getPackage().getName() + ".LocalDescriptions";

    public static ModelNode getProfileDescription(Locale locale) {
        ResourceBundle bundle = ProfileDescription.getResourceBundle(locale);
        ModelNode root = ProfileDescription.getBasicProfileDescription(bundle);
        ProfileDescription.appendSubsystemChild(root, bundle);
        return root;
    }

    private static ModelNode getBasicProfileDescription(ResourceBundle bundle) {
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("profile"));
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(true);
        root.get(new String[]{"attributes", "name", "head-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "name", "tail-comment-allowed"}).set(false);
        root.get("operations").setEmptyObject();
        return root;
    }

    public static ModelNode getProfileWithIncludesDescription(Locale locale) {
        ResourceBundle bundle = ProfileDescription.getResourceBundle(locale);
        ModelNode root = ProfileDescription.getBasicProfileDescription(bundle);
        root.get(new String[]{"attributes", "includes", "description"}).set(bundle.getString("profile.includes"));
        root.get(new String[]{"attributes", "includes", "type"}).set(ModelType.LIST);
        root.get(new String[]{"attributes", "includes", "value-type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "includes", "required"}).set(false);
        ProfileDescription.appendSubsystemChild(root, bundle);
        return root;
    }

    public static ModelNode getProfileIncludesDescription(Locale locale) {
        ResourceBundle bundle = ProfileDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("profile.include"));
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(false);
        root.get(new String[]{"attributes", "profile", "type"}).set(ModelType.LIST);
        root.get(new String[]{"attributes", "profile", "description"}).set(bundle.getString("profile.include.profile"));
        root.get(new String[]{"attributes", "profile", "required"}).set(true);
        root.get(new String[]{"attributes", "profile", "value-type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "profile", "head-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "profile", "tail-comment-allowed"}).set(false);
        root.get("operations").setEmptyObject();
        return root;
    }

    private static void appendSubsystemChild(ModelNode root, ResourceBundle bundle) {
        root.get(new String[]{"children", "subsystem", "description"}).set(bundle.getString("profile.subsystem"));
        root.get(new String[]{"children", "subsystem", "min-occurs"}).set(1);
        root.get(new String[]{"children", "subsystem", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "subsystem", "model-description"}).setEmptyObject();
    }

    public static ModelNode getProfileAddOperation(Locale locale) {
        ResourceBundle bundle = ProfileDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add");
        root.get("description").set(bundle.getString("profile.add"));
        root.get(new String[]{"request-properties", "includes", "type"}).set(ModelType.LIST);
        root.get(new String[]{"request-properties", "includes", "description"}).set(bundle.getString("profile.add.includes"));
        root.get(new String[]{"request-properties", "includes", "value-type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "includes", "required"}).set(false);
        root.get(new String[]{"request-properties", "includes", "nillable"}).set(true);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getProfileDescribeOperation(Locale locale) {
        ResourceBundle bundle = ProfileDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add");
        root.get("description").set(bundle.getString("profile.describe"));
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        root.get(new String[]{"reply-properties", "value-type"}).set(ModelType.OBJECT);
        return root;
    }

    public static ModelNode getProfileRemoveOperation(Locale locale) {
        ResourceBundle bundle = ProfileDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove");
        root.get("description").set(bundle.getString("profile.remove"));
        root.get("request-properties").setEmptyObject();
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

