/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

public class RemoteProxyController
implements ManagementRequestHandlerFactory,
ProxyController {
    private final PathAddress pathAddress;
    private final ManagementChannelAssociation channelAssociation;
    private final ProxyOperationAddressTranslator addressTranslator;

    private RemoteProxyController(ManagementChannelAssociation channelAssociation, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator) {
        this.channelAssociation = channelAssociation;
        this.pathAddress = pathAddress;
        this.addressTranslator = addressTranslator;
    }

    public static RemoteProxyController create(ManagementChannelHandler channelAssociation, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator) {
        RemoteProxyController controller = new RemoteProxyController((ManagementChannelAssociation)channelAssociation, pathAddress, addressTranslator);
        channelAssociation.addHandlerFactory((ManagementRequestHandlerFactory)controller);
        return controller;
    }

    @Override
    public PathAddress getProxyNodeAddress() {
        return this.pathAddress;
    }

    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
        byte operationType = header.getOperationId();
        if (operationType == 72) {
            return new HandleReportRequestHandler();
        }
        if (operationType == 76) {
            return new ReadAttachmentInputStreamRequestHandler();
        }
        return handlers.resolveNext();
    }

    @Override
    public void execute(ModelNode original, OperationMessageHandler handler, ProxyController.ProxyOperationControl control, OperationAttachments attachments) {
        ModelNode operation = this.getOperationForProxy(original);
        ExecuteRequestContext context = new ExecuteRequestContext(operation, attachments, handler, control);
        try {
            this.channelAssociation.executeRequest((ManagementRequest)new ExecuteRequest(), (Object)context, (ActiveOperation.CompletedCallback)context);
            context.awaitPreparedOrFailed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ModelNode getOperationForProxy(ModelNode op) {
        PathAddress translated;
        PathAddress addr = PathAddress.pathAddress(op.get("address"));
        if (addr.equals(translated = this.addressTranslator.translateAddress(addr))) {
            return op;
        }
        ModelNode proxyOp = op.clone();
        proxyOp.get("address").set(translated.toModelNode());
        return proxyOp;
    }

    static ModelNode getResponse(String outcome) {
        return RemoteProxyController.getResponse(outcome, null);
    }

    static ModelNode getResponse(String outcome, String message) {
        ModelNode response = new ModelNode();
        response.get("outcome").set(outcome);
        if (message != null) {
            response.get("failure-description").set(message);
        }
        return response;
    }

    static class ExecuteRequestContext
    implements ActiveOperation.CompletedCallback<Void>,
    ProxyController.ProxyOperationControl {
        final ModelNode operation;
        final OperationAttachments attachments;
        final OperationMessageHandler messageHandler;
        final ProxyController.ProxyOperationControl control;
        final AtomicBoolean completed = new AtomicBoolean(false);
        final CountDownLatch prepareOrFailedLatch = new CountDownLatch(1);

        ExecuteRequestContext(ModelNode operation, OperationAttachments attachments, OperationMessageHandler messageHandler, ProxyController.ProxyOperationControl delegate) {
            this.operation = operation;
            this.attachments = attachments;
            this.messageHandler = messageHandler;
            this.control = delegate;
        }

        public OperationMessageHandler getMessageHandler() {
            return this.messageHandler;
        }

        public ModelNode getOperation() {
            return this.operation;
        }

        public OperationAttachments getAttachments() {
            return this.attachments;
        }

        public List<InputStream> getInputStreams() {
            OperationAttachments attachments = this.getAttachments();
            if (attachments == null) {
                return Collections.emptyList();
            }
            return attachments.getInputStreams();
        }

        public void completed(Void result) {
        }

        public void failed(Exception e) {
            this.operationFailed(RemoteProxyController.getResponse("failed", e.getMessage()));
        }

        public void cancelled() {
            this.operationFailed(RemoteProxyController.getResponse("cancelled"));
        }

        @Override
        public synchronized void operationFailed(ModelNode response) {
            if (this.completed.compareAndSet(false, true)) {
                this.control.operationFailed(response);
                this.prepareOrFailedLatch.countDown();
            }
        }

        @Override
        public synchronized void operationCompleted(ModelNode response) {
            if (this.completed.compareAndSet(false, true)) {
                this.control.operationCompleted(response);
            }
        }

        @Override
        public synchronized void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
            this.control.operationPrepared(transaction, result);
            this.prepareOrFailedLatch.countDown();
        }

        public void awaitPreparedOrFailed() throws InterruptedException {
            this.prepareOrFailedLatch.await();
        }
    }

    private class ReadAttachmentInputStreamRequestHandler
    implements ManagementRequestHandler<Void, ExecuteRequestContext> {
        private ReadAttachmentInputStreamRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)102);
            final int index = input.readInt();
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<ExecuteRequestContext>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(ManagementRequestContext<ExecuteRequestContext> context) throws Exception {
                    ExecuteRequestContext exec = (ExecuteRequestContext)context.getAttachment();
                    ManagementRequestHeader header = (ManagementRequestHeader)ManagementRequestHeader.class.cast(context.getRequestHeader());
                    ManagementResponseHeader response = new ManagementResponseHeader(header.getVersion(), header.getRequestId(), null);
                    InputStream is = (InputStream)exec.getAttachments().getInputStreams().get(index);
                    ByteArrayOutputStream bout = ReadAttachmentInputStreamRequestHandler.this.copyStream(is);
                    FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)response);
                    try {
                        output.writeByte(103);
                        output.writeInt(bout.size());
                        output.writeByte(104);
                        output.write(bout.toByteArray());
                        output.writeByte(36);
                        output.close();
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)output);
                    }
                }
            });
        }

        protected ByteArrayOutputStream copyStream(InputStream is) throws IOException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            if (is != null) {
                StreamUtils.copyStream((InputStream)is, (OutputStream)bout);
            }
            return bout;
        }
    }

    private static class HandleReportRequestHandler
    implements ManagementRequestHandler<Void, ExecuteRequestContext> {
        private HandleReportRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)98);
            MessageSeverity severity = Enum.valueOf(MessageSeverity.class, input.readUTF());
            ProtocolUtils.expectHeader((DataInput)input, (int)99);
            String message = input.readUTF();
            ProtocolUtils.expectHeader((DataInput)input, (int)21);
            ExecuteRequestContext requestContext = (ExecuteRequestContext)context.getAttachment();
            OperationMessageHandler handler = requestContext.getMessageHandler();
            handler.handleReport(severity, message);
        }
    }

    private static class CompleteTxRequest
    extends AbstractManagementRequest<Void, ExecuteRequestContext> {
        private final byte status;

        private CompleteTxRequest(byte status) {
            this.status = status;
        }

        public byte getOperationType() {
            return 78;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context, FlushableDataOutput output) throws IOException {
            output.write((int)this.status);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ExecuteRequestContext executeRequestContext = (ExecuteRequestContext)context.getAttachment();
            ProtocolUtils.expectHeader((DataInput)input, (int)74);
            ModelNode response = new ModelNode();
            response.readExternal(input);
            executeRequestContext.operationCompleted(response);
            resultHandler.done(null);
        }
    }

    private class ExecuteRequest
    extends AbstractManagementRequest<Void, ExecuteRequestContext> {
        private ExecuteRequest() {
        }

        public byte getOperationType() {
            return 71;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context, FlushableDataOutput output) throws IOException {
            ExecuteRequestContext executionContext = (ExecuteRequestContext)context.getAttachment();
            List<InputStream> streams = executionContext.getInputStreams();
            ModelNode operation = executionContext.getOperation();
            int inputStreamLength = 0;
            if (streams != null) {
                inputStreamLength = streams.size();
            }
            output.write(97);
            operation.writeExternal((DataOutput)output);
            output.write(101);
            output.writeInt(inputStreamLength);
        }

        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<Void> resultHandler, final ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            byte responseType = input.readByte();
            ModelNode response = new ModelNode();
            response.readExternal(input);
            boolean prepared = responseType == 75;
            ExecuteRequestContext executeRequestContext = (ExecuteRequestContext)context.getAttachment();
            if (prepared) {
                executeRequestContext.operationPrepared(new ModelController.OperationTransaction(){

                    @Override
                    public void rollback() {
                        this.done(false);
                    }

                    @Override
                    public void commit() {
                        this.done(true);
                    }

                    private void done(boolean commit) {
                        byte status = commit ? (byte)112 : 113;
                        try {
                            AsyncFuture result = RemoteProxyController.this.channelAssociation.executeRequest(context.getOperationId(), (ManagementRequest)new CompleteTxRequest(status));
                            result.await();
                        }
                        catch (InterruptedException e) {
                            throw ControllerMessages.MESSAGES.transactionTimeout(commit ? "commit" : "rollback");
                        }
                        catch (Exception e) {
                            resultHandler.failed(e);
                        }
                    }
                }, response);
            } else {
                executeRequestContext.operationFailed(response);
                resultHandler.done(null);
            }
        }
    }
}

