/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.Map;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.SubsystemInformation;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.SubsystemTransformer;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class SimpleFullModelTransformer {
    private static Logger log = Logger.getLogger(SimpleFullModelTransformer.class);
    private ExtensionRegistry extensionRegistry;

    public SimpleFullModelTransformer(ExtensionRegistry extensionRegistry) {
        this.extensionRegistry = extensionRegistry;
    }

    public Resource transformResource(Resource root, ImmutableManagementResourceRegistration rootResource, Map<String, String> subsystemVersions) {
        return this.resolveRecursive(root.clone(), rootResource, PathAddress.EMPTY_ADDRESS, subsystemVersions);
    }

    private Resource resolveRecursive(Resource resource, ImmutableManagementResourceRegistration registration, PathAddress address, Map<String, String> subsystemVersions) {
        boolean subsystem;
        boolean bl = subsystem = address.size() > 0 && !"extension".equals(address.getElement(0).getKey()) && "subsystem".equals(address.getLastElement().getKey());
        if (subsystem) {
            String subsystemName = address.getLastElement().getValue();
            if (subsystemVersions.containsKey(subsystemName)) {
                String[] version = subsystemVersions.get(subsystemName).split("\\.");
                int major = Integer.parseInt(version[0]);
                int minor = Integer.parseInt(version[1]);
                SubsystemInformation info = this.extensionRegistry.getSubsystemInfo(subsystemName);
                if (info.getManagementInterfaceMajorVersion() == major && info.getManagementInterfaceMinorVersion() == minor) {
                    return resource;
                }
                log.debug((Object)("transforming subsystem: " + subsystem + ", to model version: " + subsystemVersions.get(subsystemName)));
                SubsystemTransformer transformer = this.extensionRegistry.getTransformerRegistry().getSubsystemTransformer(subsystemName, major, minor);
                if (transformer != null) {
                    ResourceDefinition rd = TransformerRegistry.loadSubsystemDefinition(subsystemName, major, minor);
                    ManagementResourceRegistration targetDefinition = ManagementResourceRegistration.Factory.create(rd);
                    ModelNode fullSubsystemModel = Resource.Tools.readModel(resource);
                    ModelNode transformed = transformer.transformModel(null, fullSubsystemModel);
                    return TransformerRegistry.modelToResource(targetDefinition, transformed);
                }
                log.debug((Object)("We have no transformer for subsystem: " + subsystemName + "-" + major + "." + minor + " model transfer can break!"));
            }
            return resource;
        }
        for (PathElement element : registration.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
            Resource res;
            if (element.isMultiTarget()) {
                String childType = element.getKey();
                for (Resource.ResourceEntry entry : resource.getChildren(childType)) {
                    ImmutableManagementResourceRegistration childRegistration;
                    Resource res2 = this.resolveRecursive(entry, childRegistration = registration.getSubModel(PathAddress.pathAddress(PathElement.pathElement(childType, entry.getName()))), address.append(entry.getPathElement()), subsystemVersions);
                    if (res2.equals(entry)) continue;
                    resource.removeChild(entry.getPathElement());
                    resource.registerChild(entry.getPathElement(), res2);
                }
                continue;
            }
            Resource child = resource.getChild(element);
            ImmutableManagementResourceRegistration childRegistration = registration.getSubModel(PathAddress.pathAddress(element));
            if (child == null || (res = this.resolveRecursive(child, childRegistration, address.append(element), subsystemVersions)).equals(child)) continue;
            resource.removeChild(element);
            resource.registerChild(element, res);
        }
        return resource;
    }
}

