/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.LegacyResourceDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.SimpleFullModelTransformer;
import org.jboss.as.controller.transform.SubsystemTransformer;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;

public final class TransformerRegistry {
    private static final Logger log = Logger.getLogger(TransformerRegistry.class);
    private final ConcurrentHashMap<String, List<SubsystemTransformer>> subsystemTransformers = new ConcurrentHashMap();
    private static TransformerRegistry INSTANCE;
    private final SimpleFullModelTransformer modelTransformer;
    private final ExtensionRegistry extensionRegistry;

    private TransformerRegistry(ExtensionRegistry extensionRegistry) {
        this.modelTransformer = new SimpleFullModelTransformer(extensionRegistry);
        this.extensionRegistry = extensionRegistry;
        INSTANCE = this;
    }

    public static TransformerRegistry getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModelNode getSubsystemDefinitionForVersion(String subsystemName, int majorVersion, int minorVersion) {
        block16: {
            ModelNode modelNode;
            String key = subsystemName + "-" + majorVersion + "." + minorVersion + ".dmr";
            InputStream is = null;
            try {
                is = TransformerRegistry.class.getResourceAsStream(key);
                if (is == null) {
                    ModelNode modelNode2 = null;
                    return modelNode2;
                }
                modelNode = ModelNode.fromStream((InputStream)is);
            }
            catch (IOException e) {
                log.error((Object)"Could not read target definition!", (Throwable)e);
                break block16;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            return modelNode;
        }
        return null;
    }

    public static ResourceDefinition loadSubsystemDefinition(String subsystemName, int majorVersion, int minorVersion) {
        ModelNode desc = TransformerRegistry.getSubsystemDefinitionForVersion(subsystemName, majorVersion, minorVersion);
        if (desc == null) {
            return null;
        }
        LegacyResourceDefinition rd = new LegacyResourceDefinition(desc);
        return rd;
    }

    public static Resource modelToResource(ImmutableManagementResourceRegistration reg, ModelNode model) {
        return TransformerRegistry.modelToResource(reg, model, false);
    }

    public static Resource modelToResource(ImmutableManagementResourceRegistration reg, ModelNode model, boolean includeUndefined) {
        Resource res = Resource.Factory.create();
        ModelNode value = new ModelNode();
        for (String name : reg.getAttributeNames(PathAddress.EMPTY_ADDRESS)) {
            if (includeUndefined) {
                value.get(name).set(model.get(name));
                continue;
            }
            if (!model.hasDefined(name)) continue;
            value.get(name).set(model.get(name));
        }
        res.writeModel(value);
        for (PathElement path : reg.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
            ModelNode subModel;
            ImmutableManagementResourceRegistration sub = reg.getSubModel(PathAddress.pathAddress(path));
            if (path.isWildcard()) {
                subModel = model.get(path.getKey());
                if (!subModel.isDefined()) continue;
                for (Property p : subModel.asPropertyList()) {
                    if (!p.getValue().isDefined()) continue;
                    res.registerChild(PathElement.pathElement(path.getKey(), p.getName()), TransformerRegistry.modelToResource(sub, p.getValue(), includeUndefined));
                }
                continue;
            }
            subModel = model.get(path.getKeyValuePair());
            if (!subModel.isDefined()) continue;
            res.registerChild(path, TransformerRegistry.modelToResource(sub, subModel));
        }
        return res;
    }

    public void registerSubsystemTransformer(String subsystemName, SubsystemTransformer subsystemModelTransformer) {
        this.subsystemTransformers.putIfAbsent(subsystemName, new LinkedList());
        List<SubsystemTransformer> transformers = this.subsystemTransformers.get(subsystemName);
        transformers.add(subsystemModelTransformer);
    }

    public Resource getTransformedResource(Resource resource, ImmutableManagementResourceRegistration resourceRegistration, Map<String, String> subsystemVersions) {
        try {
            return this.modelTransformer.transformResource(resource, resourceRegistration, subsystemVersions);
        }
        catch (Exception e) {
            log.error((Object)"could not transform", (Throwable)e);
            return resource;
        }
    }

    public Resource getTransformedSubsystemResource(Resource resource, ImmutableManagementResourceRegistration resourceRegistration, String subsystemName, int majorVersion, int minorVersion) {
        HashMap<String, String> versions = new HashMap<String, String>();
        versions.put(subsystemName, majorVersion + "." + minorVersion);
        return this.getTransformedResource(resource, resourceRegistration, versions);
    }

    public SubsystemTransformer getSubsystemTransformer(String name, int majorVersion, int minorVersion) {
        List<SubsystemTransformer> transformers = this.subsystemTransformers.get(name);
        if (transformers == null) {
            return null;
        }
        for (SubsystemTransformer t : transformers) {
            if (t.getMajorManagementVersion() != majorVersion || t.getMinorManagementVersion() != minorVersion) continue;
            return t;
        }
        return null;
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    public static class Factory {
        public static TransformerRegistry create(ExtensionRegistry extensionRegistry) {
            return new TransformerRegistry(extensionRegistry);
        }
    }
}

