/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.GlobalTransformerRegistry;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationTransformerRegistry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationUtils;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public final class TransformerRegistry {
    private final ExtensionRegistry extensionRegistry;
    private static final PathElement HOST = PathElement.pathElement("host");
    private static final PathElement PROFILE = PathElement.pathElement("profile");
    private static final PathElement SERVER = PathElement.pathElement("server");
    private final GlobalTransformerRegistry domain = new GlobalTransformerRegistry();
    private final GlobalTransformerRegistry subsystem = new GlobalTransformerRegistry();

    TransformerRegistry(ExtensionRegistry extensionRegistry) {
        this.extensionRegistry = extensionRegistry;
        this.domain.createChildRegistry(PathAddress.pathAddress(PROFILE), ModelVersion.create(0), ResourceTransformer.DEFAULT, false);
        this.domain.createChildRegistry(PathAddress.pathAddress(HOST), ModelVersion.create(0), ResourceTransformer.DEFAULT, false);
        this.domain.createChildRegistry(PathAddress.pathAddress(HOST, SERVER), ModelVersion.create(0), ResourceTransformer.DEFAULT, false);
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    public TransformersSubRegistration registerSubsystemTransformers(String name, ModelVersionRange range, ResourceTransformer subsystemTransformer) {
        PathAddress subsystemAddress = PathAddress.EMPTY_ADDRESS.append(PathElement.pathElement("subsystem", name));
        for (ModelVersion version : range.getVersions()) {
            this.subsystem.createChildRegistry(subsystemAddress, version, subsystemTransformer, false);
        }
        return new TransformersSubRegistrationImpl(range, this.subsystem, subsystemAddress);
    }

    public TransformersSubRegistration getDomainRegistration(ModelVersionRange range) {
        PathAddress address = PathAddress.EMPTY_ADDRESS;
        return new TransformersSubRegistrationImpl(range, this.domain, address);
    }

    public TransformersSubRegistration getHostRegistration(ModelVersionRange range) {
        PathAddress address = PathAddress.EMPTY_ADDRESS.append(HOST);
        return new TransformersSubRegistrationImpl(range, this.domain, address);
    }

    public TransformersSubRegistration getServerRegistration(ModelVersionRange range) {
        PathAddress address = PathAddress.EMPTY_ADDRESS.append(HOST, SERVER);
        return new TransformersSubRegistrationImpl(range, this.domain, address);
    }

    public OperationTransformerRegistry resolveHost(ModelVersion mgmtVersion, ModelNode subsystems) {
        return this.resolveHost(mgmtVersion, TransformerRegistry.resolveVersions(subsystems));
    }

    public OperationTransformerRegistry resolveHost(ModelVersion mgmtVersion, Map<PathAddress, ModelVersion> subsystems) {
        OperationTransformerRegistry root = this.domain.create(mgmtVersion, Collections.<PathAddress, ModelVersion>emptyMap());
        this.subsystem.mergeSubtree(root, PathAddress.pathAddress(PROFILE), subsystems);
        return root;
    }

    public OperationTransformerRegistry resolveServer(ModelVersion mgmtVersion, ModelNode subsystems) {
        return this.resolveServer(mgmtVersion, TransformerRegistry.resolveVersions(subsystems));
    }

    public OperationTransformerRegistry resolveServer(ModelVersion mgmtVersion, Map<PathAddress, ModelVersion> subsystems) {
        OperationTransformerRegistry root = this.domain.create(mgmtVersion, Collections.<PathAddress, ModelVersion>emptyMap());
        return this.subsystem.mergeSubtree(root, PathAddress.pathAddress(HOST, SERVER), subsystems);
    }

    void addSubsystem(OperationTransformerRegistry registry, String name, ModelVersion version) {
        OperationTransformerRegistry profile = registry.getChild(PathAddress.pathAddress(PROFILE));
        PathAddress address = PathAddress.pathAddress(PathElement.pathElement("subsystem", name));
        this.subsystem.mergeSubtree(profile, Collections.singletonMap(address, version));
    }

    static Map<PathAddress, ModelVersion> resolveVersions(ModelNode subsystems) {
        PathAddress base = PathAddress.EMPTY_ADDRESS;
        HashMap<PathAddress, ModelVersion> versions = new HashMap<PathAddress, ModelVersion>();
        for (Property property : subsystems.asPropertyList()) {
            String name = property.getName();
            PathAddress address = base.append(PathElement.pathElement("subsystem", name));
            versions.put(address, ModelVersion.fromString(property.getValue().asString()));
        }
        return versions;
    }

    static ModelVersion convert(String version) {
        String[] s = version.split("\\.");
        int length = s.length;
        if (length > 3) {
            throw new IllegalStateException();
        }
        int major = Integer.valueOf(s[0]);
        int minor = length > 1 ? Integer.valueOf(s[1]) : 0;
        int micro = length == 3 ? Integer.valueOf(s[2]) : 0;
        return ModelVersion.create(major, minor, micro);
    }

    public static ResourceDefinition loadSubsystemDefinition(String subsystemName, ModelVersion version) {
        return TransformationUtils.loadSubsystemDefinition(subsystemName, version);
    }

    public static Resource modelToResource(ImmutableManagementResourceRegistration reg, ModelNode model, boolean includeUndefined) {
        return TransformationUtils.modelToResource(reg, model, includeUndefined);
    }

    public static class TransformersSubRegistrationImpl
    implements TransformersSubRegistration {
        private final PathAddress current;
        private final ModelVersionRange range;
        private final GlobalTransformerRegistry registry;

        public TransformersSubRegistrationImpl(ModelVersionRange range, GlobalTransformerRegistry registry, PathAddress parent) {
            this.range = range;
            this.registry = registry;
            this.current = parent;
        }

        @Override
        public TransformersSubRegistration registerSubResource(PathElement element) {
            return this.registerSubResource(element, ResourceTransformer.DEFAULT, OperationTransformer.DEFAULT);
        }

        @Override
        public TransformersSubRegistration registerSubResource(PathElement element, boolean discard) {
            if (discard) {
                PathAddress address = this.current.append(element);
                for (ModelVersion version : this.range.getVersions()) {
                    this.registry.createDiscardingChildRegistry(address, version);
                }
                return new TransformersSubRegistrationImpl(this.range, this.registry, address);
            }
            return this.registerSubResource(element, ResourceTransformer.DEFAULT, OperationTransformer.DEFAULT);
        }

        @Override
        public TransformersSubRegistration registerSubResource(PathElement element, OperationTransformer operationTransformer) {
            return this.registerSubResource(element, ResourceTransformer.DEFAULT, operationTransformer);
        }

        @Override
        public TransformersSubRegistration registerSubResource(PathElement element, ResourceTransformer resourceTransformer) {
            return this.registerSubResource(element, resourceTransformer, OperationTransformer.DEFAULT);
        }

        @Override
        public TransformersSubRegistration registerSubResource(PathElement element, ResourceTransformer resourceTransformer, OperationTransformer operationTransformer) {
            PathAddress address = this.current.append(element);
            for (ModelVersion version : this.range.getVersions()) {
                this.registry.createChildRegistry(address, version, resourceTransformer, operationTransformer);
            }
            return new TransformersSubRegistrationImpl(this.range, this.registry, address);
        }

        @Override
        public void discardOperations(String ... operationNames) {
            for (ModelVersion version : this.range.getVersions()) {
                for (String operationName : operationNames) {
                    this.registry.discardOperation(this.current, version, operationName);
                }
            }
        }

        @Override
        public void registerOperationTransformer(String operationName, OperationTransformer transformer) {
            for (ModelVersion version : this.range.getVersions()) {
                this.registry.registerTransformer(this.current, version, operationName, transformer);
            }
        }
    }

    public static class Factory {
        public static TransformerRegistry create(ExtensionRegistry extensionRegistry) {
            return new TransformerRegistry(extensionRegistry);
        }
    }
}

