/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.as.server.deployment.impl.HashUtil;
import org.jboss.logging.Logger;

public class DeploymentRepositoryImpl
implements DeploymentRepository {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.deployment");
    protected static final String CONTENT = "content";
    private final File repoRoot;
    protected final MessageDigest messageDigest;

    protected DeploymentRepositoryImpl(File repoRoot) {
        if (repoRoot == null) {
            throw new IllegalArgumentException("repoRoot is null");
        }
        if (repoRoot.exists()) {
            if (!repoRoot.isDirectory()) {
                throw new IllegalStateException("Deployment repository root " + repoRoot.getAbsolutePath() + " is not a directory");
            }
            if (!repoRoot.canWrite()) {
                throw new IllegalStateException("Deployment repository root " + repoRoot.getAbsolutePath() + " is not a writable");
            }
        } else if (!repoRoot.mkdirs()) {
            throw new IllegalStateException("Failed to create a directory at " + repoRoot.getAbsolutePath());
        }
        this.repoRoot = repoRoot;
        try {
            this.messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot obtain SHA-1 " + MessageDigest.class.getSimpleName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] addDeploymentContent(InputStream stream) throws IOException {
        byte[] sha1Bytes = null;
        File tmp = File.createTempFile(CONTENT, "tmp", this.repoRoot);
        FileOutputStream fos = new FileOutputStream(tmp);
        MessageDigest messageDigest = this.messageDigest;
        synchronized (messageDigest) {
            this.messageDigest.reset();
            try {
                int read;
                DigestOutputStream dos = new DigestOutputStream(fos, this.messageDigest);
                BufferedInputStream bis = new BufferedInputStream(stream);
                byte[] bytes = new byte[8192];
                while ((read = bis.read(bytes)) > -1) {
                    dos.write(bytes, 0, read);
                }
            }
            finally {
                DeploymentRepositoryImpl.safeClose(fos);
            }
            sha1Bytes = this.messageDigest.digest();
        }
        File realFile = this.getDeploymentContentFile(sha1Bytes, true);
        if (this.hasDeploymentContent(sha1Bytes)) {
            if (!tmp.delete()) {
                tmp.deleteOnExit();
            }
            log.debugf("Content was already present in repository at location %s", (Object)realFile.getAbsolutePath());
        } else {
            this.moveTempToPermanent(tmp, realFile);
            log.infof("Content added at location %s", (Object)realFile.getAbsolutePath());
        }
        return sha1Bytes;
    }

    @Override
    public boolean hasDeploymentContent(byte[] hash) {
        return this.getDeploymentContentFile(hash).exists();
    }

    protected File getRepoRoot() {
        return this.repoRoot;
    }

    protected File getDeploymentContentFile(byte[] deploymentHash) {
        return this.getDeploymentContentFile(deploymentHash, false);
    }

    private File getDeploymentContentFile(byte[] deploymentHash, boolean validate) {
        File hashDir = this.getDeploymentHashDir(deploymentHash, validate);
        return new File(hashDir, CONTENT);
    }

    protected File getDeploymentHashDir(byte[] deploymentHash, boolean validate) {
        String sha1 = HashUtil.bytesToHexString(deploymentHash);
        String partA = sha1.substring(0, 2);
        String partB = sha1.substring(2);
        File base = new File(this.getRepoRoot(), partA);
        if (validate) {
            this.validateDir(base);
        }
        File hashDir = new File(base, partB);
        if (validate && !hashDir.exists() && !hashDir.mkdirs()) {
            throw new IllegalStateException("Cannot create directory " + hashDir.getAbsolutePath());
        }
        return hashDir;
    }

    protected void validateDir(File dir) {
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IllegalStateException("Cannot create directory " + dir.getAbsolutePath());
            }
        } else {
            if (!dir.isDirectory()) {
                throw new IllegalStateException(dir.getAbsolutePath() + " is not a directory");
            }
            if (!dir.canWrite()) {
                throw new IllegalStateException("Cannot write to directory " + dir.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTempToPermanent(File tmpFile, File permanentFile) throws IOException {
        if (!tmpFile.renameTo(permanentFile)) {
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            FileInputStream fis = null;
            try {
                int read;
                fos = new FileOutputStream(permanentFile);
                bos = new BufferedOutputStream(fos);
                fis = new FileInputStream(tmpFile);
                BufferedInputStream bis = new BufferedInputStream(fis);
                byte[] bytes = new byte[8192];
                while ((read = bis.read(bytes)) > -1) {
                    bos.write(bytes, 0, read);
                }
            }
            catch (Throwable throwable) {
                DeploymentRepositoryImpl.safeClose(bos);
                DeploymentRepositoryImpl.safeClose(fos);
                DeploymentRepositoryImpl.safeClose(fis);
                if (!tmpFile.delete()) {
                    tmpFile.deleteOnExit();
                }
                throw throwable;
            }
            DeploymentRepositoryImpl.safeClose(bos);
            DeploymentRepositoryImpl.safeClose(fos);
            DeploymentRepositoryImpl.safeClose(fis);
            if (!tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
        }
    }

    protected static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

