/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.catalina;

import java.util.Arrays;
import java.util.Iterator;
import javax.management.MBeanServer;
import org.apache.catalina.Container;
import org.apache.catalina.Globals;
import org.apache.coyote.ProtocolHandler;
import org.apache.jasper.Constants;
import org.apache.tomcat.util.IntrospectionUtils;
import org.jboss.modcluster.Connector;
import org.jboss.modcluster.Engine;
import org.jboss.modcluster.Host;
import org.jboss.modcluster.Server;
import org.jboss.modcluster.catalina.CatalinaConnector;
import org.jboss.modcluster.catalina.CatalinaHost;
import org.jboss.modcluster.catalina.CatalinaServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalinaEngine
implements Engine {
    private final org.apache.catalina.Engine engine;
    private final Server server;

    public CatalinaEngine(org.apache.catalina.Engine engine, Server server) {
        this.engine = engine;
        this.server = server;
    }

    public CatalinaEngine(org.apache.catalina.Engine engine, MBeanServer mbeanServer) {
        this(engine, new CatalinaServer(engine.getService().getServer(), mbeanServer));
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public Iterable<Host> getHosts() {
        final Iterator<Container> children = Arrays.asList(this.engine.findChildren()).iterator();
        final Iterator<Host> hosts = new Iterator<Host>(){

            @Override
            public boolean hasNext() {
                return children.hasNext();
            }

            @Override
            public Host next() {
                return new CatalinaHost((org.apache.catalina.Host)children.next(), CatalinaEngine.this);
            }

            @Override
            public void remove() {
                children.remove();
            }
        };
        return new Iterable<Host>(){

            @Override
            public Iterator<Host> iterator() {
                return hosts;
            }
        };
    }

    @Override
    public String getJvmRoute() {
        return this.engine.getJvmRoute();
    }

    @Override
    public void setJvmRoute(String jvmRoute) {
        this.engine.setJvmRoute(jvmRoute);
    }

    @Override
    public String getName() {
        return this.engine.getName();
    }

    @Override
    public Connector getProxyConnector() {
        int highestMaxThreads = 0;
        CatalinaConnector bestConnector = null;
        for (org.apache.catalina.connector.Connector connector : this.engine.getService().findConnectors()) {
            CatalinaConnector catalinaConnector = new CatalinaConnector(connector);
            if (CatalinaConnector.isAJP(connector) || catalinaConnector.isReverse()) {
                return catalinaConnector;
            }
            ProtocolHandler handler = connector.getProtocolHandler();
            int maxThreads = (Integer)IntrospectionUtils.getProperty((Object)handler, (String)"maxThreads");
            if (maxThreads <= highestMaxThreads) continue;
            highestMaxThreads = maxThreads;
            bestConnector = catalinaConnector;
        }
        if (bestConnector == null) {
            throw new IllegalStateException();
        }
        return bestConnector;
    }

    @Override
    public Host findHost(String name) {
        org.apache.catalina.Host host = (org.apache.catalina.Host)this.engine.findChild(name);
        return host != null ? new CatalinaHost(host, this) : null;
    }

    @Override
    public String getSessionCookieName() {
        try {
            return Globals.SESSION_COOKIE_NAME;
        }
        catch (NoSuchFieldError e) {
            return "JSESSIONID";
        }
    }

    @Override
    public String getSessionParameterName() {
        try {
            return Globals.SESSION_PARAMETER_NAME;
        }
        catch (NoSuchFieldError e) {
            return Constants.SESSION_PARAMETER_NAME;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CatalinaEngine)) {
            return false;
        }
        CatalinaEngine engine = (CatalinaEngine)object;
        return this.engine == engine.engine;
    }

    public int hashCode() {
        return this.engine.hashCode();
    }

    public String toString() {
        return this.engine.getName();
    }
}

