/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.rmi.NotBoundException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import javax.management.MBeanServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import org.jboss.logging.Logger;
import org.jboss.osgi.jmx.internal.DefaultSocketFactory;

public class JMXConnectorService {
    private static final Logger log = Logger.getLogger(JMXConnectorService.class);
    private JMXServiceURL serviceURL;
    private RMIConnectorServer connectorServer;
    private RMIJRMPServerImpl rmiServer;
    private boolean shutdownRegistry;
    private Registry rmiRegistry;
    private String rmiHost;
    private int rmiPort;

    public JMXConnectorService(JMXServiceURL serviceURL, int rmiPort) throws IOException {
        this.serviceURL = serviceURL;
        this.rmiHost = serviceURL.getHost();
        this.rmiPort = rmiPort;
        this.rmiRegistry = LocateRegistry.getRegistry(this.rmiHost, rmiPort);
        try {
            this.rmiRegistry.list();
            log.debug((Object)("RMI registry running at host=" + this.rmiHost + ",port=" + rmiPort));
        }
        catch (Exception ex) {
            log.debug((Object)("No RMI registry running at host=" + this.rmiHost + ",port=" + rmiPort + ".  Will create one."));
            this.rmiRegistry = LocateRegistry.createRegistry(rmiPort, null, new DefaultSocketFactory(InetAddress.getByName(this.rmiHost)));
            this.shutdownRegistry = true;
        }
    }

    public void start(MBeanServer mbeanServer) throws IOException {
        boolean jmxConnectorAvailable = false;
        try {
            this.rmiRegistry.lookup("jmxrmi");
            jmxConnectorAvailable = true;
        }
        catch (NotBoundException ex) {
            // empty catch block
        }
        if (!jmxConnectorAvailable) {
            DefaultSocketFactory serverSocketFactory = new DefaultSocketFactory(InetAddress.getByName(this.rmiHost));
            this.rmiServer = new RMIJRMPServerImpl(this.rmiPort, null, serverSocketFactory, null);
            this.connectorServer = new RMIConnectorServer(this.serviceURL, null, this.rmiServer, mbeanServer);
            log.debug((Object)("JMXConnectorServer created: " + this.serviceURL));
            this.connectorServer.start();
            this.rmiRegistry.rebind("jmxrmi", this.rmiServer.toStub());
            log.debug((Object)("JMXConnectorServer started: " + this.serviceURL));
        }
    }

    public void stop() {
        try {
            if (this.connectorServer != null) {
                this.connectorServer.stop();
                this.rmiRegistry.unbind("jmxrmi");
            }
            if (this.shutdownRegistry) {
                log.debug((Object)"Shutdown RMI registry");
                UnicastRemoteObject.unexportObject(this.rmiRegistry, true);
            }
            log.debug((Object)"JMXConnectorServer stopped");
        }
        catch (Exception ex) {
            log.warn((Object)"Cannot stop JMXConnectorServer", (Throwable)ex);
        }
    }
}

