/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment.aspect;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.jboss.logging.Logger;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.stack.cxf.client.util.SpringUtils;
import org.jboss.wsf.stack.cxf.metadata.MetadataBuilder;
import org.jboss.wsf.stack.cxf.metadata.services.DDBeans;

public class DescriptorDeploymentAspect
extends AbstractDeploymentAspect {
    private static final Logger log = Logger.getLogger(DescriptorDeploymentAspect.class);
    private String invokerEJB3;
    private String invokerJSE;

    public void setInvokerEJB3(String invokerEJB3) {
        this.invokerEJB3 = invokerEJB3;
    }

    public void setInvokerJSE(String invokerJSE) {
        this.invokerJSE = invokerJSE;
    }

    public void start(Deployment dep) {
        if (SpringUtils.isSpringAvailable((ClassLoader[])new ClassLoader[0])) {
            URL cxfURL = this.getCXFConfigFromDeployment(dep);
            if (cxfURL == null) {
                cxfURL = this.generateCXFConfigFromDeployment(dep);
            }
            this.putCXFConfigToDeployment(dep, cxfURL);
        } else {
            log.info((Object)"Spring not available, skipping check for user provided jbossws-cxf.xml / cxf.xml configuration files.");
            this.generateMetadataFromDeployment(dep);
        }
    }

    public void stop(Deployment dep) {
        DDBeans dd = (DDBeans)dep.getAttachment(DDBeans.class);
        if (dd != null) {
            dd.destroyFileURL();
        }
    }

    private URL getCXFConfigFromDeployment(Deployment dep) {
        String metadir;
        Deployment.DeploymentType depType = dep.getType();
        if (depType == Deployment.DeploymentType.JAXWS_EJB3) {
            metadir = "META-INF";
        } else if (depType == Deployment.DeploymentType.JAXWS_JSE) {
            metadir = "WEB-INF";
        } else {
            throw new IllegalStateException("Unsupported deployment type: " + depType);
        }
        URL cxfURL = null;
        try {
            ArchiveDeployment archDep = (ArchiveDeployment)dep;
            cxfURL = archDep.getResourceResolver().resolve(metadir + "/jbossws-cxf.xml");
            log.info((Object)("JBossWS-CXF configuration found: " + cxfURL));
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return cxfURL;
    }

    private URL generateCXFConfigFromDeployment(Deployment dep) {
        DDBeans dd = this.generateMetadataFromDeployment(dep);
        URL cxfURL = dd.createFileURL();
        log.info((Object)("JBossWS-CXF configuration generated: " + cxfURL));
        return cxfURL;
    }

    private DDBeans generateMetadataFromDeployment(Deployment dep) {
        MetadataBuilder builder = new MetadataBuilder();
        DDBeans dd = builder.build(dep, this.invokerEJB3, this.invokerJSE);
        dep.addAttachment(DDBeans.class, (Object)dd);
        return dd;
    }

    private void putCXFConfigToDeployment(Deployment dep, URL cxfURL) {
        HashMap<String, String> contextParams = (HashMap<String, String>)dep.getProperty("stack.context.parameters");
        if (contextParams == null) {
            contextParams = new HashMap<String, String>();
            dep.setProperty("stack.context.parameters", contextParams);
        }
        contextParams.put("jbossws.cxf.beans.url", cxfURL.toExternalForm());
    }
}

