/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.sort;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.wsf.spi.deployment.DeploymentAspect;

public final class DeploymentAspectSorter {
    private static final DeploymentAspectSorter INSTANCE = new DeploymentAspectSorter();

    private DeploymentAspectSorter() {
    }

    public static DeploymentAspectSorter getInstance() {
        return INSTANCE;
    }

    public List<DeploymentAspect> sort(List<DeploymentAspect> aspects) {
        DeploymentAspect lastAspect = this.getLastAspect(aspects);
        List<DeploymentAspect> sortedAspects = this.createOrientedGraph(aspects).sort();
        sortedAspects.add(lastAspect);
        return sortedAspects;
    }

    private DeploymentAspect getLastAspect(List<DeploymentAspect> aspects) {
        Iterator<DeploymentAspect> i = aspects.iterator();
        while (i.hasNext()) {
            DeploymentAspect aspect = i.next();
            if (!aspect.isLast()) continue;
            i.remove();
            return aspect;
        }
        throw new IllegalStateException("No deployment aspect found with attribute last='true'");
    }

    private Graph createOrientedGraph(List<DeploymentAspect> aspects) {
        Graph graph = new Graph();
        for (DeploymentAspect aspect : aspects) {
            graph.addVertex(aspect);
        }
        graph.createEdges();
        return graph;
    }

    private static class Graph {
        private Map<String, Dependency> dependencies = new HashMap<String, Dependency>();
        private Set<Vertex> vertices = new HashSet<Vertex>();

        private Graph() {
        }

        public void addVertex(DeploymentAspect aspect) {
            Dependency dependency;
            HashSet<String> inputs = new HashSet<String>();
            inputs.addAll(aspect.getRequiresAsSet());
            HashSet<String> outputs = new HashSet<String>();
            outputs.addAll(aspect.getProvidesAsSet());
            Set<String> intersection = this.getIntersection(inputs, outputs);
            Vertex vertex = new Vertex(aspect);
            this.vertices.add(vertex);
            for (String in : inputs) {
                dependency = this.getDependency(in);
                dependency.consumers.add(vertex);
            }
            for (String inOut : intersection) {
                dependency = this.getDependency(inOut);
                dependency.modifiers.add(vertex);
            }
            for (String out : outputs) {
                dependency = this.getDependency(out);
                dependency.producers.add(vertex);
            }
        }

        public List<DeploymentAspect> sort() {
            LinkedList<DeploymentAspect> retVal = new LinkedList<DeploymentAspect>();
            List<Vertex> roots = this.getRoots();
            while (!roots.isEmpty()) {
                Vertex root = roots.remove(0);
                retVal.add(root.getAspect());
                if (!root.hasConsumers()) continue;
                LinkedList<Vertex> nextLevel = new LinkedList<Vertex>();
                for (Vertex consumer : root.consumers) {
                    consumer.decrementDegree();
                    if (consumer.hasProducers()) continue;
                    this.remove(consumer);
                    nextLevel.add(consumer);
                }
                roots.addAll(nextLevel);
            }
            if (this.vertices.size() > 0) {
                throw new IllegalStateException("Cycle detected in subgraph: " + this.vertices);
            }
            return retVal;
        }

        private Set<String> getIntersection(Set<String> inputs, Set<String> outputs) {
            HashSet<String> intersection = new HashSet<String>();
            for (String input : inputs) {
                for (String output : outputs) {
                    if (!input.equals(output)) continue;
                    intersection.add(input);
                }
            }
            inputs.removeAll(intersection);
            outputs.removeAll(intersection);
            return intersection;
        }

        private Dependency getDependency(String name) {
            if (this.dependencies.containsKey(name)) {
                return this.dependencies.get(name);
            }
            Dependency newDependency = new Dependency();
            this.dependencies.put(name, newDependency);
            return newDependency;
        }

        private void createEdges() {
            for (String dependencyName : this.dependencies.keySet()) {
                boolean hasModifiers;
                Dependency dependency = this.dependencies.get(dependencyName);
                boolean bl = hasModifiers = dependency.modifiers.size() > 0;
                if (hasModifiers) {
                    this.createEdges(dependency.producers, dependency.modifiers);
                    this.createEdges(dependency.modifiers, dependency.consumers);
                    continue;
                }
                this.createEdges(dependency.producers, dependency.consumers);
            }
        }

        private void createEdges(List<Vertex> producers, List<Vertex> consumers) {
            for (Vertex producer : producers) {
                for (Vertex consumer : consumers) {
                    producer.addConsumer(consumer);
                    consumer.incrementDegree();
                }
            }
        }

        private List<Vertex> getRoots() {
            LinkedList<Vertex> retVal = new LinkedList<Vertex>();
            Iterator<Vertex> i = this.vertices.iterator();
            while (i.hasNext()) {
                Vertex current = i.next();
                if (current.hasProducers()) continue;
                retVal.add(current);
                i.remove();
            }
            return retVal;
        }

        private void remove(Vertex v) {
            this.vertices.remove(v);
        }

        private static class Dependency {
            private List<Vertex> producers = new LinkedList<Vertex>();
            private List<Vertex> modifiers = new LinkedList<Vertex>();
            private List<Vertex> consumers = new LinkedList<Vertex>();

            private Dependency() {
            }
        }

        private static class Vertex {
            private DeploymentAspect aspect;
            private int inDegree;
            private List<Vertex> consumers = new LinkedList<Vertex>();

            public Vertex(DeploymentAspect aspect) {
                this.aspect = aspect;
            }

            public void incrementDegree() {
                ++this.inDegree;
            }

            public void decrementDegree() {
                --this.inDegree;
            }

            public boolean hasProducers() {
                return this.inDegree > 0;
            }

            public void addConsumer(Vertex v) {
                this.consumers.add(v);
            }

            public boolean hasConsumers() {
                return this.consumers.size() > 0;
            }

            public DeploymentAspect getAspect() {
                return this.aspect;
            }

            public String toString() {
                return this.aspect.toString();
            }
        }
    }
}

