/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.as.weld.SecurityActions;
import org.jboss.as.weld.deployment.WeldDeployment;
import org.jboss.as.weld.services.ModuleGroupSingletonProvider;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;

public class WeldContainer {
    private final WeldBootstrap bootstrap;
    private final WeldDeployment deployment;
    private final Environment environment;
    private final Map<String, BeanDeploymentArchive> beanDeploymentArchives;
    private volatile boolean started;

    public WeldContainer(WeldDeployment deployment, Environment environment) {
        this.deployment = deployment;
        this.environment = environment;
        this.bootstrap = new WeldBootstrap();
        HashMap<String, BeanDeploymentArchive> bdas = new HashMap<String, BeanDeploymentArchive>();
        for (BeanDeploymentArchive archive : deployment.getBeanDeploymentArchives()) {
            bdas.put(archive.getId(), archive);
        }
        bdas.put(deployment.getAdditionalBeanDeploymentArchive().getId(), deployment.getAdditionalBeanDeploymentArchive());
        this.beanDeploymentArchives = Collections.unmodifiableMap(bdas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        if (this.started) {
            throw new IllegalStateException("WeldContainer is already running");
        }
        ModuleGroupSingletonProvider.addClassLoaders((ClassLoader)this.deployment.getModule().getClassLoader(), this.deployment.getSubDeploymentClassLoaders());
        this.started = true;
        ClassLoader oldTccl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader((ClassLoader)this.deployment.getModule().getClassLoader());
            this.bootstrap.startContainer(this.environment, (Deployment)this.deployment);
            this.bootstrap.startInitialization();
            this.bootstrap.deployBeans();
            this.bootstrap.validateBeans();
            this.bootstrap.endInitialization();
        }
        finally {
            SecurityActions.setContextClassLoader(oldTccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (!this.started) {
            throw new IllegalStateException("WeldContainer is not started");
        }
        ClassLoader oldTccl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader((ClassLoader)this.deployment.getModule().getClassLoader());
            this.bootstrap.shutdown();
        }
        finally {
            SecurityActions.setContextClassLoader(oldTccl);
            ModuleGroupSingletonProvider.removeClassLoader((ClassLoader)this.deployment.getModule().getClassLoader());
        }
        this.started = false;
    }

    public BeanManager getBeanManager(BeanDeploymentArchive archive) {
        if (!this.started) {
            throw new IllegalStateException("WeldContainer is not started");
        }
        return this.bootstrap.getManager(archive);
    }

    public BeanManager getBeanManager(String beanArchiveId) {
        if (!this.started) {
            throw new IllegalStateException("WeldContainer is not started");
        }
        BeanDeploymentArchive beanDeploymentArchive = this.beanDeploymentArchives.get(beanArchiveId);
        if (beanDeploymentArchive == null) {
            throw new IllegalArgumentException("BeanDeploymentArchive with id " + beanArchiveId + " not found in deplyoment");
        }
        return this.bootstrap.getManager(beanDeploymentArchive);
    }

    public <T extends Service> void addWeldService(Class<T> type, T service) {
        if (this.started) {
            throw new IllegalStateException("services cannot be added after weld has started");
        }
        this.deployment.getServices().add(type, service);
        this.deployment.getAdditionalBeanDeploymentArchive().getServices().add(type, service);
    }

    public BeanManager getBeanManager() {
        if (!this.started) {
            throw new IllegalStateException("WeldContainer is not started");
        }
        return this.bootstrap.getManager((BeanDeploymentArchive)this.deployment.getAdditionalBeanDeploymentArchive());
    }

    public Set<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return new HashSet<BeanDeploymentArchive>(this.beanDeploymentArchives.values());
    }

    public boolean isStarted() {
        return this.started;
    }
}

