/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.ejb.EJB;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.injection.spi.EjbInjectionServices;

public class WeldEjbInjectionServices
implements EjbInjectionServices {
    private final ServiceRegistry serviceRegistry;
    private final EEModuleDescription moduleDescription;
    private final EEApplicationDescription applicationDescription;
    private final VirtualFile deploymentRoot;

    public WeldEjbInjectionServices(ServiceRegistry serviceRegistry, EEModuleDescription moduleDescription, EEApplicationDescription applicationDescription, VirtualFile deploymentRoot) {
        this.serviceRegistry = serviceRegistry;
        this.moduleDescription = moduleDescription;
        this.applicationDescription = applicationDescription;
        this.deploymentRoot = deploymentRoot;
    }

    public Object resolveEjb(InjectionPoint injectionPoint) {
        EJB ejb = (EJB)injectionPoint.getAnnotated().getAnnotation(EJB.class);
        if (ejb == null) {
            throw new RuntimeException("@Ejb annotation not found on " + injectionPoint.getMember());
        }
        if (injectionPoint.getMember() instanceof Method && ((Method)injectionPoint.getMember()).getParameterTypes().length != 1) {
            throw new IllegalArgumentException("Injection point represents a method which doesn't follow JavaBean conventions (must have exactly one parameter) " + injectionPoint);
        }
        if (!ejb.lookup().equals("")) {
            ServiceName ejbServiceName = ContextNames.serviceNameOfContext((String)this.moduleDescription.getApplicationName(), (String)this.moduleDescription.getModuleName(), (String)this.moduleDescription.getModuleName(), (String)ejb.lookup());
            ServiceController controller = this.serviceRegistry.getRequiredService(ejbServiceName);
            ManagedReferenceFactory factory = (ManagedReferenceFactory)controller.getValue();
            return factory.getReference().getInstance();
        }
        if (this.applicationDescription != null) {
            Set viewService = ejb.beanName().isEmpty() ? (ejb.beanInterface() != Object.class ? this.applicationDescription.getComponentsForViewName(ejb.beanInterface().getName()) : this.applicationDescription.getComponentsForViewName(WeldEjbInjectionServices.getType(injectionPoint.getType()).getName())) : (ejb.beanInterface() != Object.class ? this.applicationDescription.getComponents(ejb.beanName(), ejb.beanInterface().getName(), this.deploymentRoot) : this.applicationDescription.getComponents(ejb.beanName(), WeldEjbInjectionServices.getType(injectionPoint.getType()).getName(), this.deploymentRoot));
            if (viewService.isEmpty()) {
                throw new RuntimeException("Could not resolve @Ejb reference " + ejb);
            }
            if (viewService.size() > 1) {
                throw new RuntimeException("More than 1 ejb found for @Ejb reference " + ejb);
            }
            ViewDescription viewDescription = (ViewDescription)viewService.iterator().next();
            ServiceController controller = this.serviceRegistry.getRequiredService(viewDescription.getServiceName());
            ComponentView view = (ComponentView)controller.getValue();
            return view.createInstance().createProxy();
        }
        throw new RuntimeException("No EjbLookup registry has been provided CDI @EJB injection " + injectionPoint);
    }

    public void cleanup() {
    }

    private static Class<?> getType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return WeldEjbInjectionServices.getType(((ParameterizedType)type).getRawType());
        }
        throw new RuntimeException("Could not determine bean class from injection point type of " + type);
    }
}

