/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

public enum EntityMode {
    POJO("pojo"),
    DOM4J("dom4j"),
    MAP("dynamic-map");

    private final String name;

    private EntityMode(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static EntityMode parse(String entityMode) {
        if (entityMode == null) {
            return POJO;
        }
        if ((entityMode = entityMode.toUpperCase()).equals("DYNAMIC-MAP")) {
            return MAP;
        }
        return EntityMode.valueOf(entityMode);
    }
}

