/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PersistentObjectException;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.event.internal.AbstractSaveEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PersistEvent;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.IdentityMap;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.jboss.logging.Logger;

public class DefaultPersistEventListener
extends AbstractSaveEventListener
implements PersistEventListener {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)DefaultPersistEventListener.class.getName());

    @Override
    public void onPersist(PersistEvent event) throws HibernateException {
        this.onPersist(event, IdentityMap.instantiate(10));
    }

    @Override
    public void onPersist(PersistEvent event, Map createCache) throws HibernateException {
        EntityPersister persister;
        String entityName;
        Object entity;
        EventSource source = event.getSession();
        Object object = event.getObject();
        if (object instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                if (li.getSession() == source) {
                    return;
                }
                throw new PersistentObjectException("uninitialized proxy passed to persist()");
            }
            entity = li.getImplementation();
        } else {
            entity = object;
        }
        if (event.getEntityName() != null) {
            entityName = event.getEntityName();
        } else {
            entityName = source.bestGuessEntityName(entity);
            event.setEntityName(entityName);
        }
        EntityEntry entityEntry = source.getPersistenceContext().getEntry(entity);
        int entityState = this.getEntityState(entity, entityName, entityEntry, source);
        if (entityState == 2 && ForeignGenerator.class.isInstance((persister = source.getFactory().getEntityPersister(entityName)).getIdentifierGenerator())) {
            if (LOG.isDebugEnabled() && persister.getIdentifier(entity, source) != null) {
                LOG.debugf("Resetting entity id attribute to null for foreign generator", new Object[0]);
            }
            persister.setIdentifier(entity, null, source);
            entityState = this.getEntityState(entity, entityName, entityEntry, source);
        }
        switch (entityState) {
            case 2: {
                throw new PersistentObjectException("detached entity passed to persist: " + this.getLoggableName(event.getEntityName(), entity));
            }
            case 0: {
                this.entityIsPersistent(event, createCache);
                break;
            }
            case 1: {
                this.entityIsTransient(event, createCache);
                break;
            }
            default: {
                throw new ObjectDeletedException("deleted entity passed to persist", null, this.getLoggableName(event.getEntityName(), entity));
            }
        }
    }

    protected void entityIsPersistent(PersistEvent event, Map createCache) {
        LOG.trace("Ignoring persistent instance");
        EventSource source = event.getSession();
        Object entity = source.getPersistenceContext().unproxy(event.getObject());
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        if (createCache.put(entity, entity) == null) {
            this.cascadeBeforeSave(source, persister, entity, createCache);
            this.cascadeAfterSave(source, persister, entity, createCache);
        }
    }

    protected void entityIsTransient(PersistEvent event, Map createCache) throws HibernateException {
        LOG.trace("Saving transient instance");
        EventSource source = event.getSession();
        Object entity = source.getPersistenceContext().unproxy(event.getObject());
        if (createCache.put(entity, entity) == null) {
            this.saveWithGeneratedId(entity, event.getEntityName(), createCache, source, false);
        }
    }

    @Override
    protected CascadingAction getCascadeAction() {
        return CascadingAction.PERSIST;
    }

    @Override
    protected Boolean getAssumedUnsaved() {
        return Boolean.TRUE;
    }
}

