/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class CollectionHelper {
    public static final int MINIMUM_INITIAL_CAPACITY = 16;
    public static final float LOAD_FACTOR = 0.75f;
    public static final List EMPTY_LIST = Collections.unmodifiableList(new ArrayList(0));
    public static final Collection EMPTY_COLLECTION = Collections.unmodifiableCollection(new ArrayList(0));
    public static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap(0));

    private CollectionHelper() {
    }

    public static Map mapOfSize(int size) {
        return new HashMap(CollectionHelper.determineProperSizing(size), 0.75f);
    }

    public static int determineProperSizing(Map original) {
        return CollectionHelper.determineProperSizing(original.size());
    }

    public static int determineProperSizing(Set original) {
        return CollectionHelper.determineProperSizing(original.size());
    }

    public static int determineProperSizing(int numberOfElements) {
        int actual = (int)((float)numberOfElements / 0.75f) + 1;
        return Math.max(actual, 16);
    }

    public static <K, V> ConcurrentHashMap<K, V> concurrentMap(int expectedNumberOfElements) {
        return CollectionHelper.concurrentMap(expectedNumberOfElements, 0.75f);
    }

    public static <K, V> ConcurrentHashMap<K, V> concurrentMap(int expectedNumberOfElements, float loadFactor) {
        int size = expectedNumberOfElements + 1 + (int)((float)expectedNumberOfElements * loadFactor);
        return new ConcurrentHashMap(size, loadFactor);
    }

    public static <T> List<T> arrayList(int anticipatedSize) {
        return new ArrayList(anticipatedSize);
    }
}

