/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.CascadeType;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.EntityReferencingAttributeBinding;
import org.hibernate.metamodel.binding.HibernateTypeDescriptor;
import org.hibernate.metamodel.binding.state.AttributeBindingState;
import org.hibernate.metamodel.domain.Attribute;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.DerivedValue;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.Tuple;
import org.hibernate.metamodel.relational.Value;
import org.hibernate.metamodel.relational.state.SimpleValueRelationalState;
import org.hibernate.metamodel.relational.state.TupleRelationalState;
import org.hibernate.metamodel.relational.state.ValueCreator;
import org.hibernate.metamodel.relational.state.ValueRelationalState;
import org.hibernate.metamodel.source.spi.MetaAttributeContext;

public abstract class AbstractAttributeBinding
implements AttributeBinding {
    private final HibernateTypeDescriptor hibernateTypeDescriptor = new HibernateTypeDescriptor();
    private final EntityBinding entityBinding;
    private final Set<EntityReferencingAttributeBinding> entityReferencingAttributeBindings = new HashSet<EntityReferencingAttributeBinding>();
    private Attribute attribute;
    private Value value;
    private boolean isLazy;
    private String propertyAccessorName;
    private boolean isAlternateUniqueKey;
    private Set<CascadeType> cascadeTypes;
    private boolean optimisticLockable;
    private String nodeName;
    private MetaAttributeContext metaAttributeContext;

    protected AbstractAttributeBinding(EntityBinding entityBinding) {
        this.entityBinding = entityBinding;
    }

    protected void initialize(AttributeBindingState state) {
        this.hibernateTypeDescriptor.setTypeName(state.getTypeName());
        this.hibernateTypeDescriptor.setTypeParameters(state.getTypeParameters());
        this.isLazy = state.isLazy();
        this.propertyAccessorName = state.getPropertyAccessorName();
        this.isAlternateUniqueKey = state.isAlternateUniqueKey();
        this.cascadeTypes = state.getCascadeTypes();
        this.optimisticLockable = state.isOptimisticLockable();
        this.nodeName = state.getNodeName();
        this.metaAttributeContext = state.getMetaAttributeContext();
    }

    @Override
    public EntityBinding getEntityBinding() {
        return this.entityBinding;
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    protected void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    protected boolean forceNonNullable() {
        return false;
    }

    protected boolean forceUnique() {
        return false;
    }

    protected final boolean isPrimaryKey() {
        return this == this.getEntityBinding().getEntityIdentifier().getValueBinding();
    }

    protected void initializeValueRelationalState(ValueRelationalState state) {
        this.value = ValueCreator.createValue(this.getEntityBinding().getBaseTable(), this.getAttribute().getName(), state, this.forceNonNullable(), this.forceUnique());
        if (this.isPrimaryKey()) {
            if (SimpleValue.class.isInstance(this.value)) {
                if (!Column.class.isInstance(this.value)) {
                    throw new MappingException("Simple ID is not a column.");
                }
                this.entityBinding.getBaseTable().getPrimaryKey().addColumn((Column)Column.class.cast(this.value));
            } else {
                for (SimpleValueRelationalState val : ((TupleRelationalState)TupleRelationalState.class.cast(state)).getRelationalStates()) {
                    if (!Column.class.isInstance(val)) continue;
                    this.entityBinding.getBaseTable().getPrimaryKey().addColumn((Column)Column.class.cast(val));
                }
            }
        }
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    @Override
    public HibernateTypeDescriptor getHibernateTypeDescriptor() {
        return this.hibernateTypeDescriptor;
    }

    public Set<CascadeType> getCascadeTypes() {
        return this.cascadeTypes;
    }

    public boolean isOptimisticLockable() {
        return this.optimisticLockable;
    }

    @Override
    public MetaAttributeContext getMetaAttributeContext() {
        return this.metaAttributeContext;
    }

    @Override
    public Iterable<SimpleValue> getValues() {
        return this.value == null ? Collections.emptyList() : (this.value instanceof Tuple ? ((Tuple)this.value).values() : Collections.singletonList((SimpleValue)this.value));
    }

    @Override
    public String getPropertyAccessorName() {
        return this.propertyAccessorName;
    }

    @Override
    public boolean hasFormula() {
        for (SimpleValue simpleValue : this.getValues()) {
            if (!(simpleValue instanceof DerivedValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAlternateUniqueKey() {
        return this.isAlternateUniqueKey;
    }

    public void setAlternateUniqueKey(boolean alternateUniqueKey) {
        this.isAlternateUniqueKey = alternateUniqueKey;
    }

    @Override
    public boolean isNullable() {
        for (SimpleValue simpleValue : this.getValues()) {
            if (simpleValue instanceof DerivedValue) {
                return true;
            }
            Column column = (Column)simpleValue;
            if (!column.isNullable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean[] getColumnInsertability() {
        ArrayList<Boolean> tmp = new ArrayList<Boolean>();
        for (SimpleValue simpleValue : this.getValues()) {
            tmp.add(!(simpleValue instanceof DerivedValue));
        }
        boolean[] rtn = new boolean[tmp.size()];
        int i = 0;
        for (Boolean insertable : tmp) {
            rtn[i++] = insertable;
        }
        return rtn;
    }

    @Override
    public boolean[] getColumnUpdateability() {
        return this.getColumnInsertability();
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    protected void setLazy(boolean isLazy) {
        this.isLazy = isLazy;
    }

    @Override
    public void addEntityReferencingAttributeBinding(EntityReferencingAttributeBinding referencingAttributeBinding) {
        this.entityReferencingAttributeBindings.add(referencingAttributeBinding);
    }

    @Override
    public Set<EntityReferencingAttributeBinding> getEntityReferencingAttributeBindings() {
        return Collections.unmodifiableSet(this.entityReferencingAttributeBindings);
    }

    @Override
    public void validate() {
        if (!this.entityReferencingAttributeBindings.isEmpty()) {
            // empty if block
        }
    }
}

