/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.BagBinding;
import org.hibernate.metamodel.binding.Caching;
import org.hibernate.metamodel.binding.CollectionElementType;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.EntityDiscriminator;
import org.hibernate.metamodel.binding.EntityIdentifier;
import org.hibernate.metamodel.binding.EntityReferencingAttributeBinding;
import org.hibernate.metamodel.binding.InheritanceType;
import org.hibernate.metamodel.binding.ManyToOneAttributeBinding;
import org.hibernate.metamodel.binding.SimpleAttributeBinding;
import org.hibernate.metamodel.binding.state.EntityBindingState;
import org.hibernate.metamodel.domain.Entity;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.source.spi.MetaAttributeContext;

public class EntityBinding {
    private final EntityIdentifier entityIdentifier = new EntityIdentifier(this);
    private boolean isRoot;
    private InheritanceType entityInheritanceType;
    private EntityDiscriminator entityDiscriminator;
    private SimpleAttributeBinding versionBinding;
    private Entity entity;
    private TableSpecification baseTable;
    private Map<String, AttributeBinding> attributeBindingMap = new HashMap<String, AttributeBinding>();
    private Set<EntityReferencingAttributeBinding> entityReferencingAttributeBindings = new HashSet<EntityReferencingAttributeBinding>();
    private Caching caching;
    private MetaAttributeContext metaAttributeContext;
    private String proxyInterfaceName;
    private boolean lazy;
    private boolean mutable;
    private boolean explicitPolymorphism;
    private String whereFilter;
    private String rowId;
    private boolean dynamicUpdate;
    private boolean dynamicInsert;
    private int batchSize;
    private boolean selectBeforeUpdate;
    private boolean hasSubselectLoadableCollections;
    private int optimisticLockMode;
    private Class entityPersisterClass;
    private Boolean isAbstract;
    private CustomSQL customInsert;
    private CustomSQL customUpdate;
    private CustomSQL customDelete;
    private List<String> synchronizedTableNames;
    private String loaderName;

    public EntityBinding initialize(EntityBindingState state) {
        this.isRoot = state.isRoot();
        this.entityInheritanceType = state.getEntityInheritanceType();
        this.caching = state.getCaching();
        this.metaAttributeContext = state.getMetaAttributeContext();
        this.proxyInterfaceName = state.getProxyInterfaceName();
        this.lazy = state.isLazy();
        this.mutable = state.isMutable();
        this.explicitPolymorphism = state.isExplicitPolymorphism();
        this.whereFilter = state.getWhereFilter();
        this.rowId = state.getRowId();
        this.dynamicInsert = state.isDynamicUpdate();
        this.dynamicInsert = state.isDynamicInsert();
        this.batchSize = state.getBatchSize();
        this.selectBeforeUpdate = state.isSelectBeforeUpdate();
        this.optimisticLockMode = state.getOptimisticLockMode();
        this.entityPersisterClass = state.getEntityPersisterClass();
        this.isAbstract = state.isAbstract();
        this.customInsert = state.getCustomInsert();
        this.customUpdate = state.getCustomUpdate();
        this.customDelete = state.getCustomDelete();
        if (state.getSynchronizedTableNames() != null) {
            for (String synchronizedTableName : state.getSynchronizedTableNames()) {
                this.addSynchronizedTable(synchronizedTableName);
            }
        }
        return this;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public TableSpecification getBaseTable() {
        return this.baseTable;
    }

    public void setBaseTable(TableSpecification baseTable) {
        this.baseTable = baseTable;
    }

    public EntityIdentifier getEntityIdentifier() {
        return this.entityIdentifier;
    }

    public void bindEntityIdentifier(SimpleAttributeBinding attributeBinding) {
        if (!Column.class.isInstance(attributeBinding.getValue())) {
            throw new MappingException("Identifier value must be a Column; instead it is: " + attributeBinding.getValue().getClass());
        }
        this.entityIdentifier.setValueBinding(attributeBinding);
        this.baseTable.getPrimaryKey().addColumn((Column)Column.class.cast(attributeBinding.getValue()));
    }

    public EntityDiscriminator getEntityDiscriminator() {
        return this.entityDiscriminator;
    }

    public void setInheritanceType(InheritanceType entityInheritanceType) {
        this.entityInheritanceType = entityInheritanceType;
    }

    public InheritanceType getInheritanceType() {
        return this.entityInheritanceType;
    }

    public boolean isVersioned() {
        return this.versionBinding != null;
    }

    public SimpleAttributeBinding getVersioningValueBinding() {
        return this.versionBinding;
    }

    public Iterable<AttributeBinding> getAttributeBindings() {
        return this.attributeBindingMap.values();
    }

    public AttributeBinding getAttributeBinding(String name) {
        return this.attributeBindingMap.get(name);
    }

    public Iterable<EntityReferencingAttributeBinding> getEntityReferencingAttributeBindings() {
        return this.entityReferencingAttributeBindings;
    }

    public SimpleAttributeBinding makeSimpleIdAttributeBinding(String name) {
        SimpleAttributeBinding binding = this.makeSimpleAttributeBinding(name, true, true);
        this.getEntityIdentifier().setValueBinding(binding);
        return binding;
    }

    public EntityDiscriminator makeEntityDiscriminator(String attributeName) {
        if (this.entityDiscriminator != null) {
            throw new AssertionFailure("Creation of entity discriminator was called more than once");
        }
        this.entityDiscriminator = new EntityDiscriminator();
        this.entityDiscriminator.setValueBinding(this.makeSimpleAttributeBinding(attributeName, true, false));
        return this.entityDiscriminator;
    }

    public SimpleAttributeBinding makeVersionBinding(String attributeName) {
        this.versionBinding = this.makeSimpleAttributeBinding(attributeName, true, false);
        return this.versionBinding;
    }

    public SimpleAttributeBinding makeSimpleAttributeBinding(String name) {
        return this.makeSimpleAttributeBinding(name, false, false);
    }

    private SimpleAttributeBinding makeSimpleAttributeBinding(String name, boolean forceNonNullable, boolean forceUnique) {
        SimpleAttributeBinding binding = new SimpleAttributeBinding(this, forceNonNullable, forceUnique);
        this.registerAttributeBinding(name, binding);
        binding.setAttribute(this.entity.getAttribute(name));
        return binding;
    }

    public ManyToOneAttributeBinding makeManyToOneAttributeBinding(String attributeName) {
        ManyToOneAttributeBinding binding = new ManyToOneAttributeBinding(this);
        this.registerAttributeBinding(attributeName, binding);
        binding.setAttribute(this.entity.getAttribute(attributeName));
        return binding;
    }

    public BagBinding makeBagAttributeBinding(String attributeName, CollectionElementType collectionElementType) {
        BagBinding binding = new BagBinding(this, collectionElementType);
        this.registerAttributeBinding(attributeName, binding);
        binding.setAttribute(this.entity.getAttribute(attributeName));
        return binding;
    }

    private void registerAttributeBinding(String name, EntityReferencingAttributeBinding attributeBinding) {
        this.entityReferencingAttributeBindings.add(attributeBinding);
        this.registerAttributeBinding(name, (AttributeBinding)attributeBinding);
    }

    private void registerAttributeBinding(String name, AttributeBinding attributeBinding) {
        this.attributeBindingMap.put(name, attributeBinding);
    }

    public Caching getCaching() {
        return this.caching;
    }

    public void setCaching(Caching caching) {
        this.caching = caching;
    }

    public MetaAttributeContext getMetaAttributeContext() {
        return this.metaAttributeContext;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setProxyInterfaceName(String proxyInterfaceName) {
        this.proxyInterfaceName = proxyInterfaceName;
    }

    public String getProxyInterfaceName() {
        return this.proxyInterfaceName;
    }

    public String getWhereFilter() {
        return this.whereFilter;
    }

    public void setWhereFilter(String whereFilter) {
        this.whereFilter = whereFilter;
    }

    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    public void setExplicitPolymorphism(boolean explicitPolymorphism) {
        this.explicitPolymorphism = explicitPolymorphism;
    }

    public String getRowId() {
        return this.rowId;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public String getDiscriminatorValue() {
        return this.entityDiscriminator == null ? null : this.entityDiscriminator.getDiscriminatorValue();
    }

    public boolean isDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public void setDynamicUpdate(boolean dynamicUpdate) {
        this.dynamicUpdate = dynamicUpdate;
    }

    public boolean isDynamicInsert() {
        return this.dynamicInsert;
    }

    public void setDynamicInsert(boolean dynamicInsert) {
        this.dynamicInsert = dynamicInsert;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    public void setSelectBeforeUpdate(Boolean selectBeforeUpdate) {
        this.selectBeforeUpdate = selectBeforeUpdate;
    }

    public boolean hasSubselectLoadableCollections() {
        return this.hasSubselectLoadableCollections;
    }

    void setSubselectLoadableCollections(boolean hasSubselectLoadableCollections) {
        this.hasSubselectLoadableCollections = hasSubselectLoadableCollections;
    }

    public int getOptimisticLockMode() {
        return this.optimisticLockMode;
    }

    public void setOptimisticLockMode(int optimisticLockMode) {
        this.optimisticLockMode = optimisticLockMode;
    }

    public Class getEntityPersisterClass() {
        return this.entityPersisterClass;
    }

    public void setEntityPersisterClass(Class entityPersisterClass) {
        this.entityPersisterClass = entityPersisterClass;
    }

    public Boolean isAbstract() {
        return this.isAbstract;
    }

    protected void addSynchronizedTable(String tablename) {
        if (this.synchronizedTableNames == null) {
            this.synchronizedTableNames = new ArrayList<String>();
        }
        this.synchronizedTableNames.add(tablename);
    }

    public String getLoaderName() {
        return this.loaderName;
    }

    public void setLoaderName(String loaderName) {
        this.loaderName = loaderName;
    }

    public CustomSQL getCustomInsert() {
        return this.customInsert;
    }

    public CustomSQL getCustomUpdate() {
        return this.customUpdate;
    }

    public CustomSQL getCustomDelete() {
        return this.customDelete;
    }
}

