/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import org.hibernate.metamodel.binding.SimpleAttributeBinding;
import org.hibernate.metamodel.binding.state.DiscriminatorBindingState;
import org.hibernate.metamodel.relational.state.ValueRelationalState;

public class EntityDiscriminator {
    private SimpleAttributeBinding valueBinding;
    private String discriminatorValue;
    private boolean forced;
    private boolean inserted = true;

    public SimpleAttributeBinding getValueBinding() {
        return this.valueBinding;
    }

    void setValueBinding(SimpleAttributeBinding valueBinding) {
        this.valueBinding = valueBinding;
    }

    public EntityDiscriminator initialize(DiscriminatorBindingState state) {
        if (this.valueBinding == null) {
            throw new IllegalStateException("Cannot bind state because the value binding has not been initialized.");
        }
        this.valueBinding.initialize(state);
        this.discriminatorValue = state.getDiscriminatorValue();
        this.forced = state.isForced();
        this.inserted = state.isInserted();
        return this;
    }

    public EntityDiscriminator initialize(ValueRelationalState state) {
        this.valueBinding.initialize(state);
        return this;
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public boolean isInserted() {
        return this.inserted;
    }

    public void setInserted(boolean inserted) {
        this.inserted = inserted;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EntityDiscriminator");
        sb.append("{valueBinding=").append(this.valueBinding);
        sb.append(", forced=").append(this.forced);
        sb.append(", inserted=").append(this.inserted);
        sb.append('}');
        return sb.toString();
    }
}

