/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.binding.AbstractAttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.KeyValueBinding;
import org.hibernate.metamodel.binding.state.SimpleAttributeBindingState;
import org.hibernate.metamodel.relational.state.ColumnRelationalState;
import org.hibernate.metamodel.relational.state.ValueRelationalState;

public class SimpleAttributeBinding
extends AbstractAttributeBinding
implements KeyValueBinding {
    private final boolean forceNonNullable;
    private final boolean forceUnique;
    private boolean insertable;
    private boolean updatable;
    private boolean keyCascadeDeleteEnabled;
    private String unsavedValue;
    private PropertyGeneration generation;

    SimpleAttributeBinding(EntityBinding entityBinding, boolean forceNonNullable, boolean forceUnique) {
        super(entityBinding);
        this.forceNonNullable = forceNonNullable;
        this.forceUnique = forceUnique;
    }

    public final SimpleAttributeBinding initialize(SimpleAttributeBindingState state) {
        super.initialize(state);
        this.insertable = state.isInsertable();
        this.updatable = state.isUpdatable();
        this.keyCascadeDeleteEnabled = state.isKeyCascadeDeleteEnabled();
        this.unsavedValue = state.getUnsavedValue();
        this.generation = state.getPropertyGeneration() == null ? PropertyGeneration.NEVER : state.getPropertyGeneration();
        return this;
    }

    public SimpleAttributeBinding initialize(ValueRelationalState state) {
        super.initializeValueRelationalState(state);
        return this;
    }

    private boolean isUnique(ColumnRelationalState state) {
        return this.isPrimaryKey() || state.isUnique();
    }

    @Override
    public boolean isSimpleValue() {
        return true;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    protected void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    protected void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    @Override
    public boolean isKeyCascadeDeleteEnabled() {
        return this.keyCascadeDeleteEnabled;
    }

    public void setKeyCascadeDeleteEnabled(boolean keyCascadeDeleteEnabled) {
        this.keyCascadeDeleteEnabled = keyCascadeDeleteEnabled;
    }

    @Override
    public String getUnsavedValue() {
        return this.unsavedValue;
    }

    public void setUnsavedValue(String unsaveValue) {
        this.unsavedValue = unsaveValue;
    }

    @Override
    public boolean forceNonNullable() {
        return this.forceNonNullable;
    }

    @Override
    public boolean forceUnique() {
        return this.forceUnique;
    }

    public PropertyGeneration getGeneration() {
        return this.generation;
    }
}

