/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.Schema;

public class Database {
    private Map<Schema.Name, Schema> schemaMap = new HashMap<Schema.Name, Schema>();

    public Schema getSchema(Schema.Name name) {
        Schema schema = this.schemaMap.get(name);
        if (schema == null) {
            schema = new Schema(name);
            this.schemaMap.put(name, schema);
        }
        return schema;
    }

    public Schema getSchema(Identifier schema, Identifier catalog) {
        return this.getSchema(new Schema.Name(schema, catalog));
    }

    public Schema getSchema(String schema, String catalog) {
        return this.getSchema(new Schema.Name(Identifier.toIdentifier(schema), Identifier.toIdentifier(catalog)));
    }
}

