/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.relational.AbstractConstraint;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Constraint;
import org.hibernate.metamodel.relational.Exportable;
import org.hibernate.metamodel.relational.TableSpecification;
import org.jboss.logging.Logger;

public class ForeignKey
extends AbstractConstraint
implements Constraint,
Exportable {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)AbstractConstraint.class.getName());
    private final TableSpecification targetTable;
    private List<Column> targetColumns;
    private ReferentialAction deleteRule = ReferentialAction.NO_ACTION;
    public ReferentialAction updateRule = ReferentialAction.NO_ACTION;

    protected ForeignKey(TableSpecification sourceTable, TableSpecification targetTable, String name) {
        super(sourceTable, name);
        this.targetTable = targetTable;
    }

    protected ForeignKey(TableSpecification sourceTable, TableSpecification targetTable) {
        this(sourceTable, targetTable, null);
    }

    public TableSpecification getSourceTable() {
        return this.getTable();
    }

    public TableSpecification getTargetTable() {
        return this.targetTable;
    }

    public Iterable<Column> getSourceColumns() {
        return this.getColumns();
    }

    public Iterable<Column> getTargetColumns() {
        return this.targetColumns == null ? this.getTargetTable().getPrimaryKey().getColumns() : this.targetColumns;
    }

    @Override
    public void addColumn(Column column) {
        this.addColumnMapping(column, null);
    }

    public void addColumnMapping(Column sourceColumn, Column targetColumn) {
        if (targetColumn == null) {
            if (this.targetColumns != null) {
                LOG.debugf("Attempt to map column [%s] to no target column after explicit target column(s) named for FK [name=%s]", sourceColumn.toLoggableString(), this.getName());
            }
        } else {
            if (this.targetColumns == null) {
                if (!this.internalColumnAccess().isEmpty()) {
                    LOG.debugf("Value mapping mismatch as part of FK [table=%s, name=%s] while adding source column [%s]", this.getTable().toLoggableString(), this.getName(), sourceColumn.toLoggableString());
                }
                this.targetColumns = new ArrayList<Column>();
            }
            this.targetColumns.add(targetColumn);
        }
        this.internalColumnAccess().add(sourceColumn);
    }

    @Override
    public String getExportIdentifier() {
        return this.getSourceTable().getLoggableValueQualifier() + ".FK-" + this.getName();
    }

    public ReferentialAction getDeleteRule() {
        return this.deleteRule;
    }

    public void setDeleteRule(ReferentialAction deleteRule) {
        this.deleteRule = deleteRule;
    }

    public ReferentialAction getUpdateRule() {
        return this.updateRule;
    }

    public void setUpdateRule(ReferentialAction updateRule) {
        this.updateRule = updateRule;
    }

    public static enum ReferentialAction {
        NO_ACTION,
        CASCADE,
        SET_NULL,
        SET_DEFAULT,
        RESTRICT;

    }
}

