/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.global;

import org.hibernate.AnnotationException;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Index;
import org.hibernate.metamodel.relational.ObjectName;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.util.JandexHelper;
import org.hibernate.metamodel.source.spi.MetadataImplementor;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.logging.Logger;

public class TableBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)TableBinder.class.getName());

    public static void bind(MetadataImplementor metadata, org.jboss.jandex.Index jandex) {
        for (AnnotationInstance tableAnnotation : jandex.getAnnotations(HibernateDotNames.TABLE)) {
            TableBinder.bind(metadata, tableAnnotation);
        }
        for (AnnotationInstance tables : jandex.getAnnotations(HibernateDotNames.TABLES)) {
            for (AnnotationInstance table : JandexHelper.getValueAsArray(tables, "value")) {
                TableBinder.bind(metadata, table);
            }
        }
    }

    private static void bind(MetadataImplementor metadata, AnnotationInstance tableAnnotation) {
        String tableName = JandexHelper.getValueAsString(tableAnnotation, "appliesTo");
        ObjectName objectName = new ObjectName(tableName);
        Schema schema = metadata.getDatabase().getSchema(objectName.getSchema(), objectName.getCatalog());
        Table table = schema.getTable(objectName.getName());
        if (table != null) {
            TableBinder.bindHibernateTableAnnotation(table, tableAnnotation);
        }
    }

    private static void bindHibernateTableAnnotation(Table table, AnnotationInstance tableAnnotation) {
        for (AnnotationInstance indexAnnotation : JandexHelper.getValueAsArray(tableAnnotation, "indexes")) {
            TableBinder.bindIndexAnnotation(table, indexAnnotation);
        }
        String comment = JandexHelper.getValueAsString(tableAnnotation, "comment");
        if (StringHelper.isNotEmpty(comment)) {
            table.addComment(comment.trim());
        }
    }

    private static void bindIndexAnnotation(Table table, AnnotationInstance indexAnnotation) {
        String indexName = JandexHelper.getValueAsString(indexAnnotation, "appliesTo");
        String[] columnNames = (String[])JandexHelper.getValue(indexAnnotation, "columnNames");
        if (columnNames == null) {
            LOG.noColumnsSpecifiedForIndex(indexName, table.toLoggableString());
            return;
        }
        Index index = table.getOrCreateIndex(indexName);
        for (String columnName : columnNames) {
            Column column = TableBinder.findColumn(table, columnName);
            if (column == null) {
                throw new AnnotationException("@Index references a unknown column: " + columnName);
            }
            index.addColumn(column);
        }
    }

    private static Column findColumn(Table table, String columnName) {
        Column column = null;
        for (SimpleValue value : table.values()) {
            if (!(value instanceof Column) || !((Column)value).getName().equals(columnName)) continue;
            column = (Column)value;
            break;
        }
        return column;
    }

    private TableBinder() {
    }
}

