/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AnnotationException;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.entity.ConfiguredClassHierarchy;
import org.hibernate.metamodel.source.annotations.util.JandexHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

public class ConfiguredClassHierarchyBuilder {
    public static Set<ConfiguredClassHierarchy> createEntityHierarchies(Index index, ServiceRegistry serviceRegistry) {
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        HashMap<ClassInfo, List<ClassInfo>> processedClassInfos = new HashMap<ClassInfo, List<ClassInfo>>();
        block0: for (ClassInfo info : index.getKnownClasses()) {
            if (!ConfiguredClassHierarchyBuilder.isConfiguredClass(info) || processedClassInfos.containsKey(info)) continue;
            ArrayList<ClassInfo> configuredClassList = new ArrayList<ClassInfo>();
            ClassInfo tmpClassInfo = info;
            for (Class clazz = classLoaderService.classForName(tmpClassInfo.toString()); clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
                tmpClassInfo = index.getClassByName(DotName.createSimple((String)clazz.getName()));
                if (tmpClassInfo == null) continue;
                if (ConfiguredClassHierarchyBuilder.existsHierarchyWithClassInfoAsLeaf(processedClassInfos, tmpClassInfo)) {
                    List classInfoList = (List)processedClassInfos.get(tmpClassInfo);
                    for (ClassInfo tmpInfo : configuredClassList) {
                        classInfoList.add(tmpInfo);
                        processedClassInfos.put(tmpInfo, classInfoList);
                    }
                    continue block0;
                }
                configuredClassList.add(0, tmpClassInfo);
                processedClassInfos.put(tmpClassInfo, configuredClassList);
            }
        }
        HashSet<ConfiguredClassHierarchy> hierarchies = new HashSet<ConfiguredClassHierarchy>();
        ArrayList<List> processedList = new ArrayList<List>();
        for (List classInfoList : processedClassInfos.values()) {
            if (processedList.contains(classInfoList)) continue;
            hierarchies.add(ConfiguredClassHierarchy.create(classInfoList, serviceRegistry));
            processedList.add(classInfoList);
        }
        return hierarchies;
    }

    private static boolean isConfiguredClass(ClassInfo info) {
        boolean isConfiguredClass = true;
        AnnotationInstance jpaEntityAnnotation = JandexHelper.getSingleAnnotation(info, JPADotNames.ENTITY);
        AnnotationInstance mappedSuperClassAnnotation = JandexHelper.getSingleAnnotation(info, JPADotNames.MAPPED_SUPERCLASS);
        AnnotationInstance embeddableAnnotation = JandexHelper.getSingleAnnotation(info, JPADotNames.EMBEDDABLE);
        if (jpaEntityAnnotation == null && mappedSuperClassAnnotation == null && embeddableAnnotation == null) {
            return false;
        }
        String className = info.toString();
        ConfiguredClassHierarchyBuilder.assertNotEntityAndMappedSuperClass(jpaEntityAnnotation, mappedSuperClassAnnotation, className);
        ConfiguredClassHierarchyBuilder.assertNotEntityAndEmbeddable(jpaEntityAnnotation, embeddableAnnotation, className);
        return isConfiguredClass;
    }

    private static boolean existsHierarchyWithClassInfoAsLeaf(Map<ClassInfo, List<ClassInfo>> processedClassInfos, ClassInfo tmpClassInfo) {
        if (!processedClassInfos.containsKey(tmpClassInfo)) {
            return false;
        }
        List<ClassInfo> classInfoList = processedClassInfos.get(tmpClassInfo);
        return classInfoList.get(classInfoList.size() - 1).equals(tmpClassInfo);
    }

    private static void assertNotEntityAndMappedSuperClass(AnnotationInstance jpaEntityAnnotation, AnnotationInstance mappedSuperClassAnnotation, String className) {
        if (jpaEntityAnnotation != null && mappedSuperClassAnnotation != null) {
            throw new AnnotationException("An entity cannot be annotated with both @Entity and @MappedSuperclass. " + className + " has both annotations.");
        }
    }

    private static void assertNotEntityAndEmbeddable(AnnotationInstance jpaEntityAnnotation, AnnotationInstance embeddableAnnotation, String className) {
        if (jpaEntityAnnotation != null && embeddableAnnotation != null) {
            throw new AnnotationException("An entity cannot be annotated with both @Entity and @Embeddable. " + className + " has both annotations.");
        }
    }
}

