/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hibernate.metamodel.source.annotation.xml.XMLColumnResult;
import org.hibernate.metamodel.source.annotation.xml.XMLEntityResult;
import org.hibernate.metamodel.source.annotation.xml.XMLFieldResult;
import org.hibernate.metamodel.source.annotation.xml.XMLNamedNativeQuery;
import org.hibernate.metamodel.source.annotation.xml.XMLNamedQuery;
import org.hibernate.metamodel.source.annotation.xml.XMLQueryHint;
import org.hibernate.metamodel.source.annotation.xml.XMLSequenceGenerator;
import org.hibernate.metamodel.source.annotation.xml.XMLSqlResultSetMapping;
import org.hibernate.metamodel.source.annotation.xml.XMLTableGenerator;
import org.hibernate.metamodel.source.annotations.xml.mocker.AbstractMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.GlobalAnnotations;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

class GlobalAnnotationMocker
extends AbstractMocker {
    private GlobalAnnotations globalAnnotations;

    GlobalAnnotationMocker(IndexBuilder indexBuilder, GlobalAnnotations globalAnnotations) {
        super(indexBuilder);
        this.globalAnnotations = globalAnnotations;
    }

    void process() {
        Collection<Object> namedQueries;
        if (!this.globalAnnotations.getTableGeneratorMap().isEmpty()) {
            for (XMLTableGenerator xMLTableGenerator : this.globalAnnotations.getTableGeneratorMap().values()) {
                this.parserTableGenerator(xMLTableGenerator);
            }
        }
        if (!this.globalAnnotations.getSequenceGeneratorMap().isEmpty()) {
            for (XMLSequenceGenerator xMLSequenceGenerator : this.globalAnnotations.getSequenceGeneratorMap().values()) {
                this.parserSequenceGenerator(xMLSequenceGenerator);
            }
        }
        if (!this.globalAnnotations.getNamedQueryMap().isEmpty()) {
            namedQueries = this.globalAnnotations.getNamedQueryMap().values();
            if (namedQueries.size() > 1) {
                this.parserNamedQueries(namedQueries);
            } else {
                this.parserNamedQuery((XMLNamedQuery)namedQueries.iterator().next());
            }
        }
        if (!this.globalAnnotations.getNamedNativeQueryMap().isEmpty()) {
            namedQueries = this.globalAnnotations.getNamedNativeQueryMap().values();
            if (namedQueries.size() > 1) {
                this.parserNamedNativeQueries(namedQueries);
            } else {
                this.parserNamedNativeQuery((XMLNamedNativeQuery)namedQueries.iterator().next());
            }
        }
        if (!this.globalAnnotations.getSqlResultSetMappingMap().isEmpty()) {
            this.parserSqlResultSetMappings(this.globalAnnotations.getSqlResultSetMappingMap().values());
        }
        this.indexBuilder.finishGlobalConfigurationMocking(this.globalAnnotations);
    }

    private AnnotationInstance parserSqlResultSetMappings(Collection<XMLSqlResultSetMapping> namedQueries) {
        AnnotationValue[] values = new AnnotationValue[namedQueries.size()];
        int i = 0;
        Iterator<XMLSqlResultSetMapping> iterator = namedQueries.iterator();
        while (iterator.hasNext()) {
            AnnotationInstance annotationInstance = this.parserSqlResultSetMapping(iterator.next());
            values[i++] = MockHelper.nestedAnnotationValue("", annotationInstance);
        }
        return this.create(SQL_RESULT_SET_MAPPINGS, null, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"values", (AnnotationValue[])values)});
    }

    private AnnotationInstance parserSqlResultSetMapping(XMLSqlResultSetMapping mapping) {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", mapping.getName(), annotationValueList);
        this.nestedEntityResultList("entities", mapping.getEntityResult(), annotationValueList);
        this.nestedColumnResultList("columns", mapping.getColumnResult(), annotationValueList);
        return this.create(SQL_RESULT_SET_MAPPING, null, annotationValueList);
    }

    private AnnotationInstance parserEntityResult(XMLEntityResult result) {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("discriminatorColumn", result.getDiscriminatorColumn(), annotationValueList);
        this.nestedFieldResultList("fields", result.getFieldResult(), annotationValueList);
        MockHelper.classValue("entityClass", result.getEntityClass(), annotationValueList, this.indexBuilder.getServiceRegistry());
        return this.create(ENTITY_RESULT, null, annotationValueList);
    }

    private void nestedEntityResultList(String name, List<XMLEntityResult> entityResults, List<AnnotationValue> annotationValueList) {
        if (MockHelper.isNotEmpty(entityResults)) {
            AnnotationValue[] values = new AnnotationValue[entityResults.size()];
            for (int i = 0; i < entityResults.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserEntityResult(entityResults.get(i));
                values[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(annotationValueList, AnnotationValue.createArrayValue((String)name, (AnnotationValue[])values));
        }
    }

    private AnnotationInstance parserColumnResult(XMLColumnResult result) {
        return this.create(COLUMN_RESULT, null, MockHelper.stringValueArray("name", result.getName()));
    }

    private void nestedColumnResultList(String name, List<XMLColumnResult> columnResults, List<AnnotationValue> annotationValueList) {
        if (MockHelper.isNotEmpty(columnResults)) {
            AnnotationValue[] values = new AnnotationValue[columnResults.size()];
            for (int i = 0; i < columnResults.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserColumnResult(columnResults.get(i));
                values[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(annotationValueList, AnnotationValue.createArrayValue((String)name, (AnnotationValue[])values));
        }
    }

    private AnnotationInstance parserFieldResult(XMLFieldResult result) {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", result.getName(), annotationValueList);
        MockHelper.stringValue("column", result.getColumn(), annotationValueList);
        return this.create(FIELD_RESULT, null, annotationValueList);
    }

    private void nestedFieldResultList(String name, List<XMLFieldResult> fieldResultList, List<AnnotationValue> annotationValueList) {
        if (MockHelper.isNotEmpty(fieldResultList)) {
            AnnotationValue[] values = new AnnotationValue[fieldResultList.size()];
            for (int i = 0; i < fieldResultList.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserFieldResult(fieldResultList.get(i));
                values[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(annotationValueList, AnnotationValue.createArrayValue((String)name, (AnnotationValue[])values));
        }
    }

    private AnnotationInstance parserNamedNativeQueries(Collection<XMLNamedNativeQuery> namedQueries) {
        AnnotationValue[] values = new AnnotationValue[namedQueries.size()];
        int i = 0;
        Iterator<XMLNamedNativeQuery> iterator = namedQueries.iterator();
        while (iterator.hasNext()) {
            AnnotationInstance annotationInstance = this.parserNamedNativeQuery(iterator.next());
            values[i++] = MockHelper.nestedAnnotationValue("", annotationInstance);
        }
        return this.create(NAMED_NATIVE_QUERIES, null, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"values", (AnnotationValue[])values)});
    }

    private AnnotationInstance parserNamedNativeQuery(XMLNamedNativeQuery namedNativeQuery) {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", namedNativeQuery.getName(), annotationValueList);
        MockHelper.stringValue("query", namedNativeQuery.getQuery(), annotationValueList);
        MockHelper.stringValue("resultSetMapping", namedNativeQuery.getResultSetMapping(), annotationValueList);
        MockHelper.classValue("resultClass", namedNativeQuery.getResultClass(), annotationValueList, this.indexBuilder.getServiceRegistry());
        this.nestedQueryHintList("hints", namedNativeQuery.getHint(), annotationValueList);
        return this.create(NAMED_NATIVE_QUERY, null, annotationValueList);
    }

    private AnnotationInstance parserNamedQueries(Collection<XMLNamedQuery> namedQueries) {
        AnnotationValue[] values = new AnnotationValue[namedQueries.size()];
        int i = 0;
        Iterator<XMLNamedQuery> iterator = namedQueries.iterator();
        while (iterator.hasNext()) {
            AnnotationInstance annotationInstance = this.parserNamedQuery(iterator.next());
            values[i++] = MockHelper.nestedAnnotationValue("", annotationInstance);
        }
        return this.create(NAMED_QUERIES, null, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"values", (AnnotationValue[])values)});
    }

    private AnnotationInstance parserNamedQuery(XMLNamedQuery namedQuery) {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", namedQuery.getName(), annotationValueList);
        MockHelper.stringValue("query", namedQuery.getQuery(), annotationValueList);
        MockHelper.enumValue("lockMode", LOCK_MODE_TYPE, namedQuery.getLockMode(), annotationValueList);
        this.nestedQueryHintList("hints", namedQuery.getHint(), annotationValueList);
        return this.create(NAMED_QUERY, null, annotationValueList);
    }

    private AnnotationInstance parserQueryHint(XMLQueryHint queryHint) {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", queryHint.getName(), annotationValueList);
        MockHelper.stringValue("value", queryHint.getValue(), annotationValueList);
        return this.create(QUERY_HINT, null, annotationValueList);
    }

    private void nestedQueryHintList(String name, List<XMLQueryHint> constraints, List<AnnotationValue> annotationValueList) {
        if (MockHelper.isNotEmpty(constraints)) {
            AnnotationValue[] values = new AnnotationValue[constraints.size()];
            for (int i = 0; i < constraints.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserQueryHint(constraints.get(i));
                values[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(annotationValueList, AnnotationValue.createArrayValue((String)name, (AnnotationValue[])values));
        }
    }

    private AnnotationInstance parserSequenceGenerator(XMLSequenceGenerator generator) {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", generator.getName(), annotationValueList);
        MockHelper.stringValue("catalog", generator.getCatalog(), annotationValueList);
        MockHelper.stringValue("schema", generator.getSchema(), annotationValueList);
        MockHelper.stringValue("sequenceName", generator.getSequenceName(), annotationValueList);
        MockHelper.integerValue("initialValue", generator.getInitialValue(), annotationValueList);
        MockHelper.integerValue("allocationSize", generator.getAllocationSize(), annotationValueList);
        return this.create(SEQUENCE_GENERATOR, null, annotationValueList);
    }

    private AnnotationInstance parserTableGenerator(XMLTableGenerator generator) {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", generator.getName(), annotationValueList);
        MockHelper.stringValue("catalog", generator.getCatalog(), annotationValueList);
        MockHelper.stringValue("schema", generator.getSchema(), annotationValueList);
        MockHelper.stringValue("table", generator.getTable(), annotationValueList);
        MockHelper.stringValue("pkColumnName", generator.getPkColumnName(), annotationValueList);
        MockHelper.stringValue("valueColumnName", generator.getValueColumnName(), annotationValueList);
        MockHelper.stringValue("pkColumnValue", generator.getPkColumnValue(), annotationValueList);
        MockHelper.integerValue("initialValue", generator.getInitialValue(), annotationValueList);
        MockHelper.integerValue("allocationSize", generator.getAllocationSize(), annotationValueList);
        this.nestedUniqueConstraintList("uniqueConstraints", generator.getUniqueConstraint(), annotationValueList);
        return this.create(TABLE_GENERATOR, null, annotationValueList);
    }

    @Override
    protected AnnotationInstance push(AnnotationInstance annotationInstance) {
        if (annotationInstance != null) {
            return this.globalAnnotations.push(annotationInstance.name(), annotationInstance);
        }
        return null;
    }
}

